<?php
/**
 * Client Reply Ticket
 *
 * @package     AutomatorWP\Integrations\Awesome_Support\Triggers\Client_Reply_Ticket
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Awesome_Support_Client_Reply_Ticket extends AutomatorWP_Integration_Trigger {

    public $integration = 'awesome_support';
    public $trigger = 'awesome_support_client_reply_ticket';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'Client replies to a ticket', 'automatorwp-pro' ),
            'select_option'     => __( 'Client <strong>replies</strong> to a ticket', 'automatorwp-pro' ),
            /* translators: %1$s: Number of times. */
            'edit_label'        => sprintf( __( 'Client replies to a ticket %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'Client replies to a ticket', 'automatorwp-pro' ),
            'action'            => 'wpas_add_reply_complete',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 2,
            'options'           => array(
                'times' => automatorwp_utilities_times_option()
            ),
            'tags' => array(
                automatorwp_utilities_post_tags( __( 'Ticket', 'automatorwp-pro' ) ),
                'times' => automatorwp_utilities_times_tag( true )
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param int   $reply_id   Reply ID
     * @param array $data       Data to be inserted as the reply
     */
    public function listener( $reply_id, $data ) {

        $user_id = absint( $data['post_author'] );

        // Bail if user is not a client
        if( user_can( $user_id, 'edit_ticket' ) ) {
            return;
        }

        $ticket_id = absint( $data['post_parent'] );

        automatorwp_trigger_event( array(
            'trigger' => $this->trigger,
            'post_id' => $ticket_id,
            'user_id' => $user_id,
        ) );

    }

}

new AutomatorWP_Awesome_Support_Client_Reply_Ticket();