<?php
/**
 * Agent Close Ticket
 *
 * @package     AutomatorWP\Integrations\Awesome_Support\Triggers\Agent_Close_Ticket
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Awesome_Support_Agent_Close_Ticket extends AutomatorWP_Integration_Trigger {

    public $integration = 'awesome_support';
    public $trigger = 'awesome_support_agent_close_ticket';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'Agent closes a ticket', 'automatorwp-pro' ),
            'select_option'     => __( 'Agent <strong>closes</strong> a ticket', 'automatorwp-pro' ),
            /* translators: %1$s: Number of times. */
            'edit_label'        => sprintf( __( 'Agent closes a ticket %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'Agent closes a ticket', 'automatorwp-pro' ),
            'action'            => 'wpas_after_close_ticket',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 3,
            'options'           => array(
                'times' => automatorwp_utilities_times_option()
            ),
            'tags' => array(
                automatorwp_utilities_post_tags( __( 'Ticket', 'automatorwp-pro' ) ),
                'times' => automatorwp_utilities_times_tag( true )
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param integer $ticket_id ID of the ticket we just closed
     * @param boolean $update    True on success, false on fialure
     * @param integer $user_id   ID of the user who did the action
     */
    public function listener( $ticket_id, $update, $user_id ) {

        $user_id = intval( get_post_meta( $ticket_id, '_wpas_assignee', true ) );

        automatorwp_trigger_event( array(
            'trigger' => $this->trigger,
            'post_id' => $ticket_id,
            'user_id' => $user_id,
        ) );

    }

}

new AutomatorWP_Awesome_Support_Agent_Close_Ticket();