<?php
/**
 * Create Contact
 *
 * @package     AutomatorWP\Integrations\Autonami\Actions\Create_Contact
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly

if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Autonami_Create_Contact extends AutomatorWP_Integration_Action {

    public $integration = 'autonami';
    public $action = 'autonami_create_contact';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Add contact to FunnelKit', 'automatorwp-pro' ),
            'select_option'     => __( 'Add <strong>contact</strong> to FunnelKit', 'automatorwp-pro' ),
            /* translators: %1$s: Contact. */
            'edit_label'        => sprintf( __( 'Add %1$s to FunnelKit', 'automatorwp-pro' ), '{contact}' ),
            /* translators: %1$s: Contact. */
            'log_label'         => sprintf( __( 'Add %1$s to FunnelKit', 'automatorwp-pro' ), '{contact}' ),
            'options'           => array(
                'contact' => array(
                    'from' => 'email',
                    'default' => __( 'contact', 'automatorwp-pro' ),
                    'fields' => array(
                        'email' => array(
                            'name' => __( 'Contact Email:', 'automatorwp-pro' ),
                            'desc' => __( 'The contact email address.', 'automatorwp-pro' ),
                            'type' => 'text',
                            'required'  => true,
                            'default' => ''
                        ),
                        'f_name' => array(
                            'name' => __( 'First name:', 'automatorwp-pro' ),
                            'desc' => __( 'The contact first name.', 'automatorwp-pro' ),
                            'type' => 'text',
                            'default' => ''
                        ),
                        'l_name' => array(
                            'name' => __( 'Last name:', 'automatorwp-pro' ),
                            'desc' => __( 'The contact last name.', 'automatorwp-pro' ),
                            'type' => 'text',
                            'default' => ''
                        ),
                        'contact_no' => array(
                            'name' => __( 'Phone:', 'automatorwp-pro' ),
                            'desc' => __( 'The phone number.', 'automatorwp-pro' ),
                            'type' => 'text',
                            'default' => ''
                        ),
                        'subscribed' => array(
                            'name' => __( 'Subscribed:', 'automatorwp-pro' ),
                            'desc' => __( 'Mark Contact as subscribed.', 'automatorwp-pro' ),
                            'type' => 'checkbox',
                            'classes'   => 'cmb2-switch',
                        ),
                     ) )
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $first_name = $action_options['f_name'];
        $last_name = $action_options['l_name'];
        $phone = $action_options['contact_no'];
        $status = $action_options['subscribed'];
        $contact_email = $action_options['email'];
        $this->result = '';
       
        $contact = new BWFCRM_Contact( $contact_email );

        // Bail if contact exists
        if ( $contact->is_contact_exists() ){
            $this->result = __( 'Contact is already in FunnelKit', 'automatorwp-pro' );
            return;
        }

        $args = array(
            'f_name'        => $first_name,
            'l_name'        => $last_name,
            'contact_no'    => $phone,
            'status'        => (bool) $status,
        );

		$response = $contact->create_contact( $contact_email, $args );

        $this->result = __( 'Contact added to FunnelKit', 'automatorwp-pro' );

    }

    /**
     * Register required hooks
     *
     * @since 1.0.0
     */
    public function hooks() {

        // Log meta data
        add_filter( 'automatorwp_user_completed_action_log_meta', array( $this, 'log_meta' ), 10, 5 );

        // Log fields
        add_filter( 'automatorwp_log_fields', array( $this, 'log_fields' ), 10, 5 );

        parent::hooks();

    }

    /**
     * Action custom log meta
     *
     * @since 1.0.0
     *
     * @param array     $log_meta           Log meta data
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     *
     * @return array
     */
    public function log_meta( $log_meta, $action, $user_id, $action_options, $automation ) {

        // Bail if action type don't match this action
        if( $action->type !== $this->action ) {
            return $log_meta;
        }

        // Store the action's result
        $log_meta['result'] = $this->result;

        return $log_meta;
    }

    /**
     * Action custom log fields
     *
     * @since 1.0.0
     *
     * @param array     $log_fields The log fields
     * @param stdClass  $log        The log object
     * @param stdClass  $object     The trigger/action/automation object attached to the log
     *
     * @return array
     */
    public function log_fields( $log_fields, $log, $object ) {

        // Bail if log is not assigned to an action
        if( $log->type !== 'action' ) {
            return $log_fields;
        }

        // Bail if action type don't match this action
        if( $object->type !== $this->action ) {
            return $log_fields;
        }

        $log_fields['result'] = array(
            'name' => __( 'Result:', 'automatorwp-pro' ),
            'type' => 'text',
        );

        return $log_fields;
    }

}

new AutomatorWP_Autonami_Create_Contact();