<?php
/**
 * Users
 *
 * @package     AutomatorWP\User Lists\Users
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Display achievements for a user on their profile screen
 *
 * @since  1.0.0
 * @param  object $user The current user's $user object
 * @return void
 */
function automatorwp_user_lists_user_profile_data( $user = null ) {

    if( ! current_user_can( automatorwp_get_manager_capability() ) ) {
        return;
    }

    $user_lists = automatorwp_user_lists_get_user_lists( $user->ID );
    $content = array();

    foreach( $user_lists as $user_list ) {
        $content[] = '<a href="' . ct_get_edit_link( 'automatorwp_user_lists', $user_list->id ) . '" target="_blank">' . $user_list->name . '</a>';
    }
    ?>

    <h2><?php echo automatorwp_dashicon( 'automatorwp' ); ?> <?php _e( 'User Lists', 'automatorwp-pro' ); ?></h2>

    <table class="form-table">
        <tbody>
            <tr>
                <th><label><?php _e( 'Lists the user is on:' ) ?></label></th>
                <td>
                    <?php echo implode( ', ', $content ); ?>
                </td>
            </tr>

        </tbody>

    </table>


    <?php



}
add_action( 'show_user_profile', 'automatorwp_user_lists_user_profile_data' );
add_action( 'edit_user_profile', 'automatorwp_user_lists_user_profile_data' );