<?php
/**
 * Plugin Name:           AutomatorWP - Ultimate Member
 * Plugin URI:            https://automatorwp.com/add-ons/ultimate-member/
 * Description:           Connect AutomatorWP with Ultimate Member.
 * Version:               1.0.2
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-ultimate-member
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          5.8
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\Ultimate_Member
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_Ultimate_Member {

    /**
     * @var         AutomatorWP_Ultimate_Member $instance The one true AutomatorWP_Ultimate_Member
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_Ultimate_Member self::$instance The one true AutomatorWP_Ultimate_Member
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_Ultimate_Member();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_ULTIMATE_MEMBER_VER', '1.0.2' );

        // Plugin file
        define( 'AUTOMATORWP_ULTIMATE_MEMBER_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_ULTIMATE_MEMBER_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_ULTIMATE_MEMBER_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Triggers
            require_once AUTOMATORWP_ULTIMATE_MEMBER_DIR . 'includes/triggers/user-approved.php';
            require_once AUTOMATORWP_ULTIMATE_MEMBER_DIR . 'includes/triggers/user-inactive.php';
            require_once AUTOMATORWP_ULTIMATE_MEMBER_DIR . 'includes/triggers/change-photo.php';
            require_once AUTOMATORWP_ULTIMATE_MEMBER_DIR . 'includes/triggers/change-cover.php';
            require_once AUTOMATORWP_ULTIMATE_MEMBER_DIR . 'includes/triggers/remove-photo.php';
            require_once AUTOMATORWP_ULTIMATE_MEMBER_DIR . 'includes/triggers/remove-cover.php';
            require_once AUTOMATORWP_ULTIMATE_MEMBER_DIR . 'includes/triggers/update-description.php';
            require_once AUTOMATORWP_ULTIMATE_MEMBER_DIR . 'includes/triggers/update-information.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'ultimate_member', array(
            'label' => 'Ultimate Member',
            'icon'  => AUTOMATORWP_ULTIMATE_MEMBER_URL . 'assets/ultimate-member.svg',
        ) );

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! class_exists( 'UM' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_Ultimate_Member instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_Ultimate_Member The one true AutomatorWP_Ultimate_Member
 */
function AutomatorWP_Ultimate_Member() {
    return AutomatorWP_Ultimate_Member::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_Ultimate_Member' );
