<?php
/**
 * Remove user from a subscription plan.
 *
 * @package     AutomatorWP\Integrations\Paid_Membership_Subscriptions\Triggers\Remove_User_From_Subscription_Plan
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */

// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

class AutomatorWP_PMS_Remove_User_From_Subscription_Plan extends AutomatorWP_Integration_Action
{
    public $integration = 'paid_membership_subscriptions';
    public $action = 'paid_membership_subscriptions_remove_user_from_subscription_plan';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register()
    {
        automatorwp_register_action( $this->action, array(
                'integration' => $this->integration,
                'label' => __('Remove user from a subscription plan', 'automatorwp-pro'),
                'select_option' => __('<strong>Remove user</strong> from a subscription plan', 'automatorwp-pro'),
                /* translators: %1$s: Subscription Plan. */
                'edit_label' => sprintf(__('Remove user from a %1$s', 'automatorwp-pro'), '{subscription_plan}'),
                /* translators: %1$s: Subscription Plan. */
                'log_label' => sprintf(__('Remove user from a %1$s', 'automatorwp-pro'), '{subscription_plan}'),
                'options' => array(
                    'subscription_plan' => automatorwp_utilities_post_option(
                        array(
                            'name' => __('Subscription plan:', 'automatorwp-pro'),
                            'option_none_label' => __('Subscription plan', 'automatorwp-pro'),
                            'post_type' => 'pms-subscription'
                        )
                    ),
                )
            )
        );

    }


    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute($action, $user_id, $action_options, $automation)
    {
        $subscription_plan_id_action = $action_options['post'];

        $member = pms_get_member($user_id);
        $subscriptions = $member->get_subscriptions_ids();

        $res = false;

        if( is_array( $subscriptions ) ) {

            foreach ($subscriptions as $old_subscription_plan_id) {

                if( $old_subscription_plan_id == $subscription_plan_id_action ) {

                    $member_subscription_data = $member->get_subscription($subscription_plan_id_action);
         
                    $member_subscription = new PMS_Member_Subscription($member_subscription_data);

                    $res = $member_subscription->remove();
                }
            }
        }

        if ($res) {
            $this->result = __('Subscription removed from member.', 'automatorwp-pro');
        } else {
            $this->result = __('Subscruption could not be removed from member.', 'automatorwp-pro');
        }

    }

    /**
     * Register required hooks
     *
     * @since 1.0.0
     */
    public function hooks()
    {

        // Log meta data
        add_filter('automatorwp_user_completed_action_log_meta', array($this, 'log_meta'), 10, 5);

        // Log fields
        add_filter('automatorwp_log_fields', array($this, 'log_fields'), 10, 5);

        parent::hooks();

    }

    /**
     * Action custom log meta
     *
     * @since 1.0.0
     *
     * @param array     $log_meta           Log meta data
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     *
     * @return array
     */
    public function log_meta($log_meta, $action, $user_id, $action_options, $automation)
    {

        // Bail if action type don't match this action
        if ($action->type !== $this->action) {
            return $log_meta;
        }

        // Store the action's result
        $log_meta['result'] = $this->result;

        return $log_meta;
    }

    /**
     * Action custom log fields
     *
     * @since 1.0.0
     *
     * @param array     $log_fields The log fields
     * @param stdClass  $log        The log object
     * @param stdClass  $object     The trigger/action/automation object attached to the log
     *
     * @return array
     */
    public function log_fields($log_fields, $log, $object)
    {

        // Bail if log is not assigned to an action
        if ($log->type !== 'action') {
            return $log_fields;
        }

        // Bail if action type don't match this action
        if ($object->type !== $this->action) {
            return $log_fields;
        }

        $log_fields['result'] = array(
            'name' => __('Result:', 'automatorwp-pro'),
            'type' => 'text',
        );

        return $log_fields;
    }

}

new AutomatorWP_PMS_Remove_User_From_Subscription_Plan();