<?php
/**
 * Scripts
 *
 * @package     AutomatorWP\Multimedia_Content\Scripts
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Register frontend scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_multimedia_content_register_scripts() {

    // Use minified libraries if SCRIPT_DEBUG is turned off
    $suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

    // Scripts
    wp_register_script( 'automatorwp-multimedia-content-js', AUTOMATORWP_MULTIMEDIA_CONTENT_URL . 'assets/js/automatorwp-multimedia-content' . $suffix . '.js', array( 'jquery' ), AUTOMATORWP_MULTIMEDIA_CONTENT_VER, true );

}
add_action( 'init', 'automatorwp_multimedia_content_register_scripts' );

/**
 * Enqueue frontend scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_multimedia_content_enqueue_scripts( $hook = null ) {

    // Scripts
    wp_localize_script( 'automatorwp-multimedia-content-js', 'automatorwp_multimedia_content', array(
        'ajaxurl' => esc_url( admin_url( 'admin-ajax.php', 'relative' ) ),
        'post_id' => get_the_ID(),
    ) );

    wp_enqueue_script( 'automatorwp-multimedia-content-js' );

}
add_action( 'wp_enqueue_scripts', 'automatorwp_multimedia_content_enqueue_scripts', 100 );