<?php
/**
 * Plugin Name:           AutomatorWP - Give
 * Plugin URI:            https://automatorwp.com/add-ons/give/
 * Description:           Connect AutomatorWP with Give.
 * Version:               1.0.1
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-give
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.4
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\Give
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_Give {

    /**
     * @var         AutomatorWP_Give $instance The one true AutomatorWP_Give
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_Give self::$instance The one true AutomatorWP_Give
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_Give();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_GIVE_VER', '1.0.1' );

        // Plugin file
        define( 'AUTOMATORWP_GIVE_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_GIVE_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_GIVE_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_GIVE_DIR . 'includes/tags.php';

            // Triggers
            require_once AUTOMATORWP_GIVE_DIR . 'includes/triggers/donation.php';
            require_once AUTOMATORWP_GIVE_DIR . 'includes/triggers/donation-total.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        // Setup our activation and deactivation hooks
        register_activation_hook( __FILE__, array( $this, 'activate' ) );
        register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'give', array(
            'label' => 'Give',
            'icon'  => AUTOMATORWP_GIVE_URL . 'assets/give.svg',
        ) );

    }

    /**
     * Activation hook for the plugin.
     *
     * @since  1.0.0
     */
    function activate() {

        if( $this->meets_requirements() ) {

        }

    }

    /**
     * Deactivation hook for the plugin.
     *
     * @since  1.0.0
     */
    function deactivate() {

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! class_exists( 'Give' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_Give instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_Give The one true AutomatorWP_Give
 */
function AutomatorWP_Give() {
    return AutomatorWP_Give::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_Give' );
