<?php
/**
 * Contact Tag
 *
 * @package     AutomatorWP\Integrations\FluentCRM\Actions\Contact_Tag
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly

if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_FluentCRM_Contact_Tag extends AutomatorWP_Integration_Action {

    public $integration = 'fluentcrm';
    public $action = 'fluentcrm_contact_tag';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Add or remove tag to contact', 'automatorwp-pro' ),
            'select_option'     => __( 'Add or remove <strong>tag</strong> to contact', 'automatorwp-pro' ),
            /* translators: %1$s: Operation (add or remove). %2$s: Tag. %3$s: Contact Email. */
            'edit_label'        => sprintf( __( '%1$s tag %2$s to %3$s', 'automatorwp-pro' ), '{operation}', '{tag}', '{contact}' ),
            /* translators: %1$s: Operation (add or remove). %2$s: Tag. %3$s: Contact Email. */
            'log_label'         => sprintf( __( '%1$s tag %2$s to %3$s', 'automatorwp-pro' ), '{operation}', '{tag}', '{contact}' ),
            'options'           => array(
                'operation' => array(
                    'from' => 'operation',
                    'fields' => array(
                        'operation' => array(
                            'name' => __( 'Operation:', 'automatorwp-pro' ),
                            'type' => 'select',
                            'options' => array(
                                'add'       => __( 'Add', 'automatorwp-pro' ),
                                'remove'    => __( 'Remove', 'automatorwp-pro' ),
                            ),
                            'default' => 'add'
                        ),
                    )
                ),
                'tag' => automatorwp_utilities_ajax_selector_option( array(
                    'field'             => 'tag',
                    'option_default'    => __( 'Select a tag', 'automatorwp-pro' ),
                    'name'              => __( 'Tag:', 'automatorwp-pro' ),
                    'option_custom'         => true,
                    'option_custom_desc'    => __( 'List ID', 'automatorwp-pro' ),
                    'action_cb'         => 'automatorwp_fluentcrm_get_tags',
                    'options_cb'        => 'automatorwp_fluentcrm_options_cb_tag',
                    'default'           => ''
                ) ),
                'contact' => array(
                    'from' => 'contact',
                    'default' => __( 'contact', 'automatorwp-pro' ),
                    'fields' => array(
                        'contact' => array(
                            'name' => __( 'Contact Email:', 'automatorwp-pro' ),
                            'type' => 'text',
                        ),
                    )
                ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        global $wpdb;

        // Shorthand
        $operation = $action_options['operation'];
        $tag_id = $action_options['tag'];
        $contact = $action_options['contact'];

        // Ensure operation default value
        if( empty( $operation ) ) {
            $operation = 'add';
        }

        // Bail if empty tag to assign
        if( empty( $tag_id ) ) {
            return;
        }

        $tag = $wpdb->get_row( $wpdb->prepare(
            "SELECT * FROM {$wpdb->prefix}fc_tags WHERE id = %s",
            $tag_id
        ) );

        // Bail if tag not exists
        if( ! $tag ) {
            return;
        }

        $subscriber = FluentCrm\App\Models\Subscriber::where( 'email', $contact )->first();

        // Bail if subscriber not exists
        if( ! $subscriber ) {
            return;
        }

        switch ( $operation ) {
            case 'add':
                // Add tag to the user
                $subscriber->attachTags( array( $tag_id ) );
                break;
            case 'remove':
                // Remove tag to the user
                $subscriber->detachTags( array( $tag_id ) );
                break;
        }


    }

}

new AutomatorWP_FluentCRM_Contact_Tag();