<?php
/**
 * Scripts
 *
 * @package     AutomatorWP\Custom_User_Fields\Scripts
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Register admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_custom_user_fields_admin_register_scripts() {

    // Use minified libraries if SCRIPT_DEBUG is turned off
    $suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

    // Stylesheets
    wp_register_style( 'automatorwp-custom-user-fields-admin-css', AUTOMATORWP_CUSTOM_USER_FIELDS_URL . 'assets/css/automatorwp-custom-user-fields-admin' . $suffix . '.css', array( ), AUTOMATORWP_CUSTOM_USER_FIELDS_VER, 'all' );

    // Scripts
    wp_register_script( 'automatorwp-custom-user-fields-admin-js', AUTOMATORWP_CUSTOM_USER_FIELDS_URL . 'assets/js/automatorwp-custom-user-fields-admin' . $suffix . '.js', array( 'jquery', 'jquery-ui-dialog' ), AUTOMATORWP_CUSTOM_USER_FIELDS_VER, true );
    wp_register_script( 'automatorwp-custom-user-fields-restrict-content-js', AUTOMATORWP_CUSTOM_USER_FIELDS_URL . 'assets/js/automatorwp-custom-user-fields-restrict-content' . $suffix . '.js', array( 'jquery' ), AUTOMATORWP_CUSTOM_USER_FIELDS_VER, true );

}
add_action( 'admin_init', 'automatorwp_custom_user_fields_admin_register_scripts' );

/**
 * Enqueue admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_custom_user_fields_admin_enqueue_scripts( $hook ) {

    // Global JS
    wp_enqueue_script( 'automatorwp-custom-user-fields-restrict-content-js' );
    
    // Custom User Fields list, add and edit screens
    if( $hook === 'automatorwp_page_automatorwp_custom_user_fields' || $hook === 'admin_page_edit_automatorwp_custom_user_fields' ) {
        // Stylesheets
        wp_enqueue_style( 'automatorwp-custom-user-fields-admin-css' );

        // Localize admin script
        wp_localize_script( 'automatorwp-custom-user-fields-admin-js', 'automatorwp_custom_user_fields_admin', array(
            'nonce'             => automatorwp_get_admin_nonce(),
            'get_samples'       => __( 'We\'re checking for a new hook. We\'ll keep trying for 60 seconds.', 'automatorwp-pro' ),
            'no_samples_found'  => __( 'No samples found.', 'automatorwp-pro' ),
            'url_error'         => __( 'Please enter a valid webhook url.', 'automatorwp-pro' ),
        ) );

        // Scripts
        wp_enqueue_script( 'automatorwp-custom-user-fields-admin-js' );

    }
}
add_action( 'admin_enqueue_scripts', 'automatorwp_custom_user_fields_admin_enqueue_scripts' );