<?php
/**
 * Custom Tables
 *
 * @package     AutomatorWP\Webhooks\Custom_Tables
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

require_once AUTOMATORWP_WEBHOOKS_DIR . 'includes/custom-tables/logs.php';

/**
 * Register all custom database Tables
 *
 * @since   1.0.0
 *
 * @return void
 */
function automatorwp_webhooks_register_custom_tables() {

    // Webhooks Logs
    ct_register_table( 'automatorwp_webhooks_logs', array(
        'singular' => __( 'Webhook Log', 'automatorwp-pro' ),
        'plural' => __( 'Webhooks Logs', 'automatorwp-pro' ),
        'show_ui' => true,
        'show_in_rest' => true,
        'rest_base' => 'automatorwp-webhook-logs',
        'version' => 1,
        'capability' => automatorwp_get_manager_capability(),
        'supports' => array( 'meta' ),
        'views' => array(
            'list' => array(
                'menu_title' => __( 'Webhooks Logs', 'automatorwp-pro' ),
                'parent_slug' => 'automatorwp',
            ),
        ),
        'schema' => array(
            'id' => array(
                'type' => 'bigint',
                'length' => '20',
                'auto_increment' => true,
                'primary_key' => true,
            ),
            'url' => array(
                'type' => 'text',
            ),
            'method' => array(
                'type' => 'text',
            ),
            'data' => array(
                'type' => 'longtext',
                'nullable' => true,
                'default' => null
            ),
            'logged_in_user_id' => array(
                'type' => 'bigint',
                'length' => '20',
                'key' => true,
            ),
            'user_id' => array(
                'type' => 'bigint',
                'length' => '20',
                'key' => true,
            ),
            'date' => array(
                'type' => 'datetime',
                'default' => '0000-00-00 00:00:00'
            ),
        ),
    ) );

}
add_action( 'ct_init', 'automatorwp_webhooks_register_custom_tables' );