<?php
/**
 * Shortcodes
 *
 * @package     AutomatorWP\Vimeo\Shortcodes
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * [automatorwp_vimeo]
 *
 * @since 1.0.0
 *
 * @param array     $atts       Shortcode's attributes
 * @param string    $content    Shortcode's content
 *
 * @return string
 */
function automatorwp_vimeo_shortcode( $atts = array(), $content = '' ) {

    // Get the received shortcode attributes
    $atts = shortcode_atts( array(
        'trigger'   => '',
        'url'       => '',
        'width'     => '640',
        'height'    => '360',
        'from_url'  => 'no',
    ), $atts, 'automatorwp_vimeo' );

    $video_id = automatorwp_vimeo_get_video_id_from_url( $atts['url'] );

    ob_start(); ?>
    <div id="<?php echo $video_id; ?>" class="automatorwp-vimeo-video"
         data-id="<?php echo $video_id; ?>"
        <?php // Loop all atts to place them as data attributes
        foreach( $atts as $att => $val ) : ?>
            data-<?php echo $att; ?>="<?php echo $atts[$att]; ?>"
        <?php endforeach; ?>
    ></div>
    <?php $output = ob_get_clean();

    // Return our rendered vimeo video
    return $output;

}
add_shortcode( 'automatorwp_vimeo', 'automatorwp_vimeo_shortcode' );