// Setup vars
var automatorwp_vimeo_videos = {};
var automatorwp_vimeo_players = {};

// Get all video players on page
var automatorwp_vimeo_elements = document.querySelectorAll( '.automatorwp-vimeo-video' );

for (var automatorwp_vimeo_i = 0; automatorwp_vimeo_i < automatorwp_vimeo_elements.length; automatorwp_vimeo_i++ ) {

    var automatorwp_vimeo_player = automatorwp_vimeo_elements[automatorwp_vimeo_i];

    var id = automatorwp_vimeo_player.getAttribute( 'data-id' );
    var url = automatorwp_vimeo_player.getAttribute( 'data-url' );
    var from_url = automatorwp_vimeo_player.getAttribute( 'data-from-url' );

    automatorwp_vimeo_players[id] = new Vimeo.Player( automatorwp_vimeo_player, {
        id: ( from_url === 'yes' ? url : id ),
        height: automatorwp_vimeo_player.getAttribute( 'data-height' ),
        width: automatorwp_vimeo_player.getAttribute( 'data-width' )
    } );

    // Play
    automatorwp_vimeo_players[id].on('play', function(e) {

        var id = this._originalElement.getAttribute( 'data-id' );
        var trigger = this._originalElement.getAttribute( 'data-trigger' );

        automatorwp_vimeo_video_change( id, trigger, e.duration, 'play' );

    });

    // Pause
    automatorwp_vimeo_players[id].on('pause', function(e) {

        var id = this._originalElement.getAttribute( 'data-id' );
        var trigger = this._originalElement.getAttribute( 'data-trigger' );

        automatorwp_vimeo_video_change( id, trigger, e.duration, 'pause' );

    });

    // Ended
    automatorwp_vimeo_players[id].on('ended', function(e) {

        var id = this._originalElement.getAttribute( 'data-id' );
        var trigger = this._originalElement.getAttribute( 'data-trigger' );

        automatorwp_vimeo_video_change( id, trigger, e.duration, 'ended' );

    });

}

function automatorwp_vimeo_video_change( id, trigger, duration, state ) {

    // Initialize video object
    if( automatorwp_vimeo_videos[id] === undefined ) {

        automatorwp_vimeo_videos[id] = {
            trigger: trigger,
            state: state,
            last_state: state,
            seconds: 0,
            duration: Math.floor( duration ),
            interval: undefined
        };

        // Start interval
        automatorwp_vimeo_videos[id].interval = setInterval( function() {

            // Only increase seconds if the video gets watched
            if( automatorwp_vimeo_videos[id].last_state === 'play' )
                automatorwp_vimeo_videos[id].seconds++;

            // Update last state
            automatorwp_vimeo_videos[id].last_state = automatorwp_vimeo_videos[id].state;
        }, 1000 );

    }

    // Update the video state
    automatorwp_vimeo_videos[id].state = state;

    if( state === 'play' ) {
        // Play

    } else if( state === 'pause' ) {
        // Pause

        // Clear the interval
        //clearInterval( automatorwp_vimeo_videos[id].interval );

    } else if( state === 'ended' ) {
        // End

        // Add an extra second to watched seconds to avoid any delay issue
        if( automatorwp_vimeo_videos[id].seconds < automatorwp_vimeo_videos[id].duration
            && ( automatorwp_vimeo_videos[id].seconds + automatorwp_vimeo.allowed_delay ) >= automatorwp_vimeo_videos[id].duration )
            automatorwp_vimeo_videos[id].seconds += automatorwp_vimeo.allowed_delay;

        // Update last state
        automatorwp_vimeo_videos[id].last_state = automatorwp_vimeo_videos[id].state;

        // Check if user has seen the video
        if( automatorwp_vimeo_videos[id].seconds >= automatorwp_vimeo_videos[id].duration ) {

            jQuery.ajax({
                url: automatorwp_vimeo.ajaxurl,
                type: 'POST',
                data: {
                    action: 'automatorwp_vimeo_track_watch_video',
                    nonce: automatorwp_vimeo.nonce,
                    trigger: automatorwp_vimeo_videos[id].trigger,
                    video_id: id,
                    seconds: automatorwp_vimeo_videos[id].seconds,
                    duration: automatorwp_vimeo_videos[id].duration,
                    user_id: automatorwp_vimeo.user_id,
                    post_id: automatorwp_vimeo.post_id
                },
                success: function(response) {

                }
            }).fail( function (response) {

            });

        }

        // Clear the interval and reset seconds played
        clearInterval( automatorwp_vimeo_videos[id].interval );

        // Remove the video from the array to let the script start again
        delete automatorwp_vimeo_videos[id];

    }

}