<?php
/**
 * Plugin Name:           AutomatorWP - Tutor LMS
 * Plugin URI:            https://automatorwp.com/add-ons/tutor/
 * Description:           Connect AutomatorWP with Tutor LMS.
 * Version:               1.1.5
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-tutor
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.7
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\Tutor_LMS
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_Tutor_LMS {

    /**
     * @var         AutomatorWP_Tutor_LMS $instance The one true AutomatorWP_Tutor_LMS
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_Tutor_LMS self::$instance The one true AutomatorWP_Tutor_LMS
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_Tutor_LMS();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_TUTOR_VER', '1.1.5' );

        // Plugin file
        define( 'AUTOMATORWP_TUTOR_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_TUTOR_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_TUTOR_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Triggers
            require_once AUTOMATORWP_TUTOR_DIR . 'includes/triggers/complete-quiz.php';
            require_once AUTOMATORWP_TUTOR_DIR . 'includes/triggers/complete-quiz-percentage.php';
            require_once AUTOMATORWP_TUTOR_DIR . 'includes/triggers/complete-lesson.php';
            require_once AUTOMATORWP_TUTOR_DIR . 'includes/triggers/enroll-course.php';
            require_once AUTOMATORWP_TUTOR_DIR . 'includes/triggers/complete-course.php';
            require_once AUTOMATORWP_TUTOR_DIR . 'includes/triggers/complete-quiz-category.php';
            require_once AUTOMATORWP_TUTOR_DIR . 'includes/triggers/complete-quiz-percentage-category.php';
            require_once AUTOMATORWP_TUTOR_DIR . 'includes/triggers/complete-lesson-category.php';
            require_once AUTOMATORWP_TUTOR_DIR . 'includes/triggers/enroll-course-category.php';
            require_once AUTOMATORWP_TUTOR_DIR . 'includes/triggers/complete-course-category.php';
            require_once AUTOMATORWP_TUTOR_DIR . 'includes/triggers/review-course.php';
            

            // Actions
            require_once AUTOMATORWP_TUTOR_DIR . 'includes/actions/user-course.php';
            require_once AUTOMATORWP_TUTOR_DIR . 'includes/actions/mark-lesson.php';
            require_once AUTOMATORWP_TUTOR_DIR . 'includes/actions/mark-course.php';
            require_once AUTOMATORWP_TUTOR_DIR . 'includes/actions/reset-course-progress.php';

            // Filters
            require_once AUTOMATORWP_TUTOR_DIR . 'includes/filters/user-is-enrolled-course.php';
            require_once AUTOMATORWP_TUTOR_DIR . 'includes/filters/user-is-not-enrolled-course.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        // Setup our activation and deactivation hooks
        register_activation_hook( __FILE__, array( $this, 'activate' ) );
        register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'tutor', array(
            'label' => 'Tutor LMS',
            'icon'  => AUTOMATORWP_TUTOR_URL . 'assets/tutor.svg',
        ) );

    }

    /**
     * Activation hook for the plugin.
     *
     * @since  1.0.0
     */
    function activate() {

        if( $this->meets_requirements() ) {

        }

    }

    /**
     * Deactivation hook for the plugin.
     *
     * @since  1.0.0
     */
    function deactivate() {

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! function_exists( 'tutor' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_Tutor_LMS instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_Tutor_LMS The one true AutomatorWP_Tutor_LMS
 */
function AutomatorWP_Tutor_LMS() {
    return AutomatorWP_Tutor_LMS::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_Tutor_LMS' );
