<?php
/**
 * Reset Course Progress
 *
 * @package     AutomatorWP\Integrations\Tutor_LMS\Actions\Reset_Course_Progress
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Tutor_LMS_Reset_Course_Progress extends AutomatorWP_Integration_Action {

    public $integration = 'tutor';
    public $action = 'tutor_reset_course_progress';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Reset the user\'s progress in a course', 'automatorwp-pro' ),
            'select_option'     => __( 'Reset the user\'s progress in a <strong>course</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Post title. %2$s: Operation (completed or not completed). */
            'edit_label'        => sprintf( __( 'Reset the user\'s progress in %1$s', 'automatorwp-pro' ), '{post}' ),
            /* translators: %1$s: Post title. %2$s: Operation (completed or not completed). */
            'log_label'         => sprintf( __( 'Reset the user\'s progress in %1$s', 'automatorwp-pro' ), '{post}' ),
            'options'           => array(
                'post' => automatorwp_utilities_post_option( array(
                    'name'              => __( 'Course:', 'automatorwp-pro' ),
                    'option_default'    => __( 'a course', 'automatorwp-pro' ),
                    'placeholder'       => __( 'Select a course', 'automatorwp-pro' ),
                    'option_none'       => false,
                    'option_custom'         => true,
                    'option_custom_desc'    => __( 'Course ID', 'automatorwp-pro' ),
                    'post_type'         => apply_filters( 'tutor_course_post_type', 'courses' ),
                ) ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        global $wpdb;

        // Shorthand
        $course_id = absint( $action_options['post'] );

        // Bail if not course provided
        if( $course_id === 0 ) {
            return;
        }

        tutor_utils()->delete_course_progress( $course_id );
        
    }

}

new AutomatorWP_Tutor_LMS_Reset_Course_Progress();