(function ( $ ) {

    // To get course's lessons
    $('body').on('change', '.automatorwp-action-thrive-apprentice-mark-lesson .cmb2-id-course select', function(e) {
        var row = $(this).closest('.cmb-row');
        var lesson_row = row.next('.cmb2-id-lesson');

        var course_id = $(this).val();
        var first_change = row.hasClass('is-option-change');

        if( course_id === 'any' || course_id === '' ) {
            // Hide the ticket selector
            if( first_change ) {
                lesson_row.hide();
            } else {
                lesson_row.slideUp('fast');
            }
        } else {
            var lesson_selector = lesson_row.find('select.select2-hidden-accessible');

            // Remove Select2 element
            lesson_selector.next('.select2').remove();

            // Update the course (since we do not use the table attribute, lets to use it as course)
            lesson_selector.data( 'table', course_id );

            // Reset the selector
            lesson_selector.removeAttr('data-select2-id');

            // Init it again
            automatorwp_ajax_selector( lesson_selector );

            // Show the ticket selector
            if( first_change ) {
                lesson_row.show();
            } else {
                lesson_row.slideDown('fast');
            }
        }

        row.removeClass('is-option-change');
    });

    // To get course's modules
    $('body').on('change', '.automatorwp-action-thrive-apprentice-mark-module .cmb2-id-course select', function(e) {
        var row = $(this).closest('.cmb-row');
        var module_row = row.next('.cmb2-id-module');

        var course_id = $(this).val();
        var first_change = row.hasClass('is-option-change');

        if( course_id === 'any' || course_id === '' ) {
            // Hide the ticket selector
            if( first_change ) {
                module_row.hide();
            } else {
                module_row.slideUp('fast');
            }
        } else {
            var module_selector = module_row.find('select.select2-hidden-accessible');

            // Remove Select2 element
            module_selector.next('.select2').remove();

            // Update the course (since we do not use the table attribute, lets to use it as course)
            module_selector.data( 'table', course_id );

            // Reset the selector
            module_selector.removeAttr('data-select2-id');

            // Init it again
            automatorwp_ajax_selector( module_selector );

            // Show the ticket selector
            if( first_change ) {
                module_row.show();
            } else {
                module_row.slideDown('fast');
            }
        }

        row.removeClass('is-option-change');
    });    

    // On click on an option, check if form contains the list selector
    $('body').on('click', '.automatorwp-automation-item-label > .automatorwp-option', function(e) {

        var item = $(this).closest('.automatorwp-automation-item');
        var option = $(this).data('option');
        var option_form = item.find('.automatorwp-option-form-container[data-option="' + option + '"]');
        var lesson_selector = option_form.find('.cmb2-id-course');

        if( lesson_selector !== undefined ) {
            lesson_selector.addClass('is-option-change');
            lesson_selector.find('select.select2-hidden-accessible').trigger('change');
        }

    });

})( jQuery );