<?php
/**
 * Mark Lesson
 *
 * @package     AutomatorWP\Integrations\LearnPress\Actions\Mark_Lesson
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_LearnPress_Mark_Lesson extends AutomatorWP_Integration_Action {

    public $integration = 'learnpress';
    public $action = 'learnpress_mark_lesson';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Mark lesson as completed for the user', 'automatorwp-pro' ),
            'select_option'     => __( 'Mark <strong>lesson as completed</strong> for the user', 'automatorwp-pro' ),
            /* translators: %1$s: Post title. */
            'edit_label'        => sprintf( __( 'Mark %1$s as completed for the user', 'automatorwp-pro' ), '{post}' ),
            /* translators: %1$s: Post title. */
            'log_label'         => sprintf( __( 'Mark %1$s as completed for the user', 'automatorwp-pro' ), '{post}' ),
            'options'           => array(
                'post' => array(
                    'from' => 'post',
                    'default' => __( 'lesson', 'automatorwp-pro' ),
                    'fields' => array(
                        'course' => automatorwp_utilities_post_field( array(
                            'name'              => __( 'Course:', 'automatorwp-pro' ),
                            'placeholder'       => __( 'Select a course', 'automatorwp-pro' ),
                            'option_none'       => false,
                            'option_custom'         => true,
                            'option_custom_desc'    => __( 'Course ID', 'automatorwp-pro' ),
                            'post_type'         => LP_COURSE_CPT,
                        ) ),
                        'course_custom' => automatorwp_utilities_custom_field( array(
                            'option_custom_desc'    => __( 'Course ID', 'automatorwp-pro' ),
                        ) ),
                        'post' => automatorwp_utilities_post_field( array(
                            'name'              => __( 'Lesson:', 'automatorwp-pro' ),
                            'placeholder'       => __( 'Select a lesson', 'automatorwp-pro' ),
                            'option_none'       => false,
                            'option_custom'         => true,
                            'option_custom_desc'    => __( 'Lesson ID', 'automatorwp-pro' ),
                            'post_type'         => LP_LESSON_CPT,
                        ) ),
                        'post_custom' => automatorwp_utilities_custom_field( array(
                            'option_custom_desc'    => __( 'Lesson ID', 'automatorwp-pro' ),
                        ) ),
                    )
                ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $lesson_id = absint( $action_options['post'] );
        $course_id = absint( $action_options['course'] );

        // Bail if not lesson provided
        if( $lesson_id === 0 ) {
            return;
        }

        // Bail if not course provided
        if( $course_id === 0 ) {
            return;
        }

        $user = learn_press_get_user( $user_id );

        // Bail if can't find the user
        if( ! $user ) {
            return;
        }

        // Get LP_Course object
        $course    = learn_press_get_course( $course_id );
       
        // Get lesson item related to course
        $item = $course->get_item( $lesson_id );

        // Bail if empty item
        if (empty ( $item ) ) {
            return;
        }
        
        // Create view in database
        $created_view = $user->set_viewing_item( $item );
    
        // Bail if empty view
        if (empty ( $created_view ) ) {
            return;
        }
       
        // Mark lesson as completed
        $user->complete_lesson( $lesson_id, $course_id );
       

    }

}

new AutomatorWP_LearnPress_Mark_Lesson();