<?php
/**
 * Company Tag
 *
 * @package     AutomatorWP\Integrations\Jetpack_CRM\Actions\Company_Tag
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly

if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Jetpack_CRM_Company_Tag extends AutomatorWP_Integration_Action {

    public $integration = 'jetpack_crm';
    public $action = 'jetpack_crm_company_tag';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Add or remove tag to company', 'automatorwp-pro' ),
            'select_option'     => __( 'Add or remove <strong>tag</strong> to company', 'automatorwp-pro' ),
            /* translators: %1$s: Operation (add or remove). %2$s: Tag. %3$s: Company ID. */
            'edit_label'        => sprintf( __( '%1$s tag %2$s to %3$s', 'automatorwp-pro' ), '{operation}', '{tag}', '{company}' ),
            /* translators: %1$s: Operation (add or remove). %2$s: Tag. %3$s: Company ID. */
            'log_label'         => sprintf( __( '%1$s tag %2$s to %3$s', 'automatorwp-pro' ), '{operation}', '{tag}', '{company}' ),
            'options'           => array(
                'operation' => array(
                    'from' => 'operation',
                    'fields' => array(
                        'operation' => array(
                            'name' => __( 'Operation:', 'automatorwp-pro' ),
                            'type' => 'select',
                            'options' => array(
                                'add'       => __( 'Add', 'automatorwp-pro' ),
                                'remove'    => __( 'Remove', 'automatorwp-pro' ),
                            ),
                            'default' => 'add'
                        ),
                    )
                ),
                'tag' => automatorwp_utilities_ajax_selector_option( array(
                    'field'             => 'tag',
                    'option_default'    => __( 'Select a tag', 'automatorwp-pro' ),
                    'name'              => __( 'Tag:', 'automatorwp-pro' ),
                    'action_cb'         => 'automatorwp_jetpack_crm_get_company_tags',
                    'options_cb'        => 'automatorwp_jetpack_crm_options_cb_tag',
                    'default'           => ''
                ) ),
                'company' => array(
                    'from' => 'company',
                    'default' => __( 'company', 'automatorwp-pro' ),
                    'fields' => array(
                        'company' => array(
                            'name' => __( 'Company ID:', 'automatorwp-pro' ),
                            'type' => 'text',
                        ),
                    )
                ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        global $wpdb;

        // Shorthand
        $operation = $action_options['operation'];
        $tag_id = $action_options['tag'];
        $company = $action_options['company'];

        // Ensure operation default value
        if( empty( $operation ) ) {
            $operation = 'add';
        }

        // Bail if empty tag to assign
        if( empty( $tag_id ) ) {
            return;
        }

       // Bail if empty company
       if( empty( $company ) ) {
        return;
        }

        $obj_company = new zbsDAL_companies;

        switch ( $operation ) {
            case 'add':
                 // Add tag to the company
                 $company_data = array(
                    'id'    => $company,
                    'tag_input'  => array( $tag_id ),
                );
        
                $tag_id = $obj_company->addUpdateCompanyTags( $company_data );
                
                break;
            case 'remove':
                // Remove tag from the company
                $company_data = array(
                    'id'    => $company,
                    'tag_input'  => array( $tag_id ),
                    'mode' => 'remove'
                );
        
                $tag_id = $obj_company->addUpdateCompanyTags( $company_data );
                break;
        }


    }

}

new AutomatorWP_Jetpack_CRM_Company_Tag();