<?php
/**
 * Tags
 *
 * @package     AutomatorWP\CSV\Tags
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * CSV tags
 *
 * @since 1.0.0
 *
 * @return array
 */
function automatorwp_import_file_get_csv_tags() {

    $csv_tags = array(
        'csv_column_value:COLUMN' => array(
            'label'     => __( 'Column value', 'automatorwp' ),
            'type'      => 'text',
            'preview'   => __( 'The CSV column value, replace "COLUMN" by the column index. Supports letters (A, B, C, etc) and numbers (0, 1, 2, etc).', 'automatorwp' ),
        ),
        'csv_row_number' => array(
            'label'     => __( 'Row number', 'automatorwp' ),
            'type'      => 'integer',
            'preview'   => __( '1', 'automatorwp' ),
        ),
    );

    return $csv_tags;

}

/**
 * Order meta tag replacement
 *
 * @since 1.0.0
 *
 * @param string    $replacement    The tag replacement
 * @param string    $tag_name       The tag name (without "{}")
 * @param stdClass  $trigger        The trigger object
 * @param int       $user_id        The user ID
 * @param string    $content        The content to parse
 * @param stdClass  $log            The last trigger log object
 *
 * @return string
 */
function automatorwp_csv_get_column_value_tag_replacement( $replacement, $tag_name, $trigger, $user_id, $content, $log ) {
  
    global $automatorwp_event, $automatorwp_csv_data;

    $trigger_args = automatorwp_get_trigger( $trigger->type );

    // Bail if no order ID attached
    if( ! $trigger_args ) {
        return $replacement;
    }

    // Bail if trigger is not from this integration
    if( $trigger_args['integration'] !== 'csv' ) {
        return $replacement;
    }

    $line_id = $automatorwp_event['line_id'];
    $data = $automatorwp_csv_data[$line_id];

    if( automatorwp_starts_with( $tag_name, 'csv_column_value' ) ) {
        // csv_column_value:COLUMN
        $column = explode( ':', $tag_name );

        if( isset( $column[1] ) ) {
            $column = $column[1];

            if( $column === 'COLUMN' ) {
                $column = 0;
            }
        } else {
            $column = 0;
        }

        if( ! is_numeric($column) ) {
            // Turns a to 0, b to 1, c to 2, etc
            $column = automatorwp_csv_get_column_index( $column );
        } else {
            $column = absint( $column );
        }

        if( isset( $data[$column] ) ) {
            $replacement = $data[$column];
        }

    } else if( $tag_name === 'csv_row_number' ) {
        // csv_row_number
        $replacement = absint( $line_id ) + 1;
    }
    
    return $replacement;
    
}
add_filter( 'automatorwp_get_trigger_tag_replacement', 'automatorwp_csv_get_column_value_tag_replacement', 10, 6 );

function automatorwp_csv_get_column_index( $column ) {

    if( empty( $column ) ) {
        return 0;
    }

    // TODO: Support for multiple letters like AA, AB, AC, AD, etc

    return ord( strtolower( $column ) ) - 97;
}
