<?php
/**
 * Plugin Name:           AutomatorWP - Amelia
 * Plugin URI:            https://automatorwp.com/add-ons/ameliabooking/
 * Description:           Connect AutomatorWP with Amelia.
 * Version:               1.0.3
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-ameliabooking
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.6
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\Amelia
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_AmeliaBooking {

    /**
     * @var         AutomatorWP_AmeliaBooking $instance The one true AutomatorWP_AmeliaBooking
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_AmeliaBooking self::$instance The one true AutomatorWP_AmeliaBooking
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_AmeliaBooking();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_AMELIABOOKING_VER', '1.0.3' );

        // Plugin file
        define( 'AUTOMATORWP_AMELIABOOKING_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_AMELIABOOKING_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_AMELIABOOKING_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_AMELIABOOKING_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_AMELIABOOKING_DIR . 'includes/ajax-functions.php';
            require_once AUTOMATORWP_AMELIABOOKING_DIR . 'includes/tags.php';

            // Triggers
            require_once AUTOMATORWP_AMELIABOOKING_DIR . 'includes/triggers/user-books-appointment.php';
            require_once AUTOMATORWP_AMELIABOOKING_DIR . 'includes/triggers/user-books-appointment-service.php';
            require_once AUTOMATORWP_AMELIABOOKING_DIR . 'includes/triggers/user-books-event.php';
            require_once AUTOMATORWP_AMELIABOOKING_DIR . 'includes/triggers/user-cancels-appointment.php';
            require_once AUTOMATORWP_AMELIABOOKING_DIR . 'includes/triggers/user-cancels-appointment-service.php';
            require_once AUTOMATORWP_AMELIABOOKING_DIR . 'includes/triggers/user-cancels-event.php';

            // Anonymous Triggers
            require_once AUTOMATORWP_AMELIABOOKING_DIR . 'includes/triggers/anonymous-books-appointment.php';
            require_once AUTOMATORWP_AMELIABOOKING_DIR . 'includes/triggers/anonymous-books-appointment-service.php';
            require_once AUTOMATORWP_AMELIABOOKING_DIR . 'includes/triggers/anonymous-books-event.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        // Setup our activation and deactivation hooks
        register_activation_hook( __FILE__, array( $this, 'activate' ) );
        register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'ameliabooking', array(
            'label' => 'Amelia',
            'icon'  => AUTOMATORWP_AMELIABOOKING_URL . 'assets/ameliabooking.svg',
        ) );

    }

    /**
     * Activation hook for the plugin.
     *
     * @since  1.0.0
     */
    function activate() {

        if( $this->meets_requirements() ) {

        }

    }

    /**
     * Deactivation hook for the plugin.
     *
     * @since  1.0.0
     */
    function deactivate() {

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! class_exists( 'AmeliaBooking\Plugin' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_AmeliaBooking instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_AmeliaBooking The one true AutomatorWP_AmeliaBooking
 */
function AutomatorWP_AmeliaBooking() {
    return AutomatorWP_AmeliaBooking::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_AmeliaBooking' );
