<?php
/**
 * Plugin Name:           AutomatorWP - AffiliateWP
 * Plugin URI:            https://automatorwp.com/add-ons/affiliatewp/
 * Description:           Connect AutomatorWP with AffiliateWP.
 * Version:               1.0.4
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-affiliatewp
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.1
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\AffiliateWP
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_AffiliateWP {

    /**
     * @var         AutomatorWP_AffiliateWP $instance The one true AutomatorWP_AffiliateWP
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_AffiliateWP self::$instance The one true AutomatorWP_AffiliateWP
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_AffiliateWP();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_AFFILIATEWP_VER', '1.0.4' );

        // Plugin file
        define( 'AUTOMATORWP_AFFILIATEWP_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_AFFILIATEWP_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_AFFILIATEWP_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_AFFILIATEWP_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_AFFILIATEWP_DIR . 'includes/tags.php';

            // Triggers
            require_once AUTOMATORWP_AFFILIATEWP_DIR . 'includes/triggers/become-affiliate.php';
            require_once AUTOMATORWP_AFFILIATEWP_DIR . 'includes/triggers/earn-referral.php';
            require_once AUTOMATORWP_AFFILIATEWP_DIR . 'includes/triggers/referral.php';

            // Actions
            require_once AUTOMATORWP_AFFILIATEWP_DIR . 'includes/actions/add-referral.php';
            require_once AUTOMATORWP_AFFILIATEWP_DIR . 'includes/actions/add-referral-to-affiliate.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        // Setup our activation and deactivation hooks
        register_activation_hook( __FILE__, array( $this, 'activate' ) );
        register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'affiliatewp', array(
            'label' => 'AffiliateWP',
            'icon'  => AUTOMATORWP_AFFILIATEWP_URL . 'assets/affiliatewp.svg',
        ) );

    }

    /**
     * Activation hook for the plugin.
     *
     * @since  1.0.0
     */
    function activate() {

        if( $this->meets_requirements() ) {

        }

    }

    /**
     * Deactivation hook for the plugin.
     *
     * @since  1.0.0
     */
    function deactivate() {

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! class_exists( 'Affiliate_WP' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_AffiliateWP instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_AffiliateWP The one true AutomatorWP_AffiliateWP
 */
function AutomatorWP_AffiliateWP() {
    return AutomatorWP_AffiliateWP::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_AffiliateWP' );
