/*
 * Astero WordPress Weather Plugin
 * http://archtheme.com/astero
 *
 * A WordPress plugin using openweathermap.org to display
 * current weather conditions and weather forecasts
 */
(function(f,i,j,c){var h="astero_fc",e={current:"https://api.darksky.net/forecast/"+astero_fc_vars.fc_api+"/",loading_class:"astero-loading",more_class:"astero-more",close_class:"astero-close",closeform_class:"astero-closeform",search_class:"astero-search",more_placeholder_class:"astero-more-placeholder",temp_class:"astero-temperature",icon_class:"astero-code",unit_class:"astero-unit",condition_class:"astero-condition",location_class:"astero-location",hi_temp_class:"astero-hi-temp",lo_temp_class:"astero-lo-temp",humidity_class:"astero-humidity-text",wind_class:"astero-wind-text",cloudiness_class:"astero-cloud-text",sunrise_class:"astero-sunrise-text",sunset_class:"astero-sunset-text",fc_hi_temp_class:"astero-fc-hi-temp",fc_lo_temp_class:"astero-fc-lo-temp",fc_icon_class:"astero-fc-icon",fc_condition_class:"astero-fc-condition",fc_cloud_class:"astero-fc-cloud",fc_humidity_class:"astero-fc-humidity",iframe_ratio:16/9,type:"geolocation",},g={lat:"",lon:"",units:"",exclude:"minutely,alerts,flags",},b={cnt:"7"},d={"clear-day":"astero-i-sun","clear-night":"astero-i-night",rain:"astero-i-rain",snow:"astero-i-snow",sleet:"astero-i-snow",wind:"astero-i-fog",fog:"astero-i-fog",cloudy:"astero-i-clouds","partly-cloudy-day":"astero-i-clouds","partly-cloudy-night":"astero-i-night",hail:"astero-i-snow",thunderstorm:"astero-i-thunderstorm",tornado:"astero-i-thunderstorm"},a={"clear-day":"B","clear-night":"C",rain:"R",snow:"W",sleet:"X",wind:"F",fog:"M",cloudy:"Y","partly-cloudy-day":"N","partly-cloudy-night":"I",hail:"U",thunderstorm:"P",tornado:"M"};function k(q,o,m){var r=this;this.element=q;this.$element=f(q);this.weather_options=f.extend({},g,o,m);this.forecast_options=f.extend({},this.weather_options,b);this._settings=f.extend({},e,m);this.codes=a;this._default_imgs=d;this._hasVideo=this.$element.find("video").length>0;this._hasIframe=this.$element.find(".astero-yt").length>0;this._hasImage=this.$element.hasClass("astero-img");this.$form=this.$element.find("form");this._isFull=this.$element.find(".astero-full").length>0;this.$background=this.$element.find(".astero-background");this.$large=this.$element.find(".astero-large");this._startInit=false;if(this.weather_options.location=="ip"){p()}else{if((this.weather_options.lat).length==0||(this.weather_options.lon).length==0){if(navigator.geolocation){var n=setTimeout(p,5000);navigator.geolocation.getCurrentPosition(function(s){clearTimeout(n);r.weather_options.lat=s.coords.latitude;r.weather_options.lon=s.coords.longitude;r.init(r,"first")},p,{enableHighAccuracy:false,timeout:5000,maximumAge:10000})}else{p()}}else{this._settings.type="location";this._startInit=true}}function p(){clearTimeout(n);f.ajax({type:"post",url:astero_fc_vars.ajaxurl,dataType:"json",data:{action:"astero_fc_geoip"},error:function(s,u,t){r.error()},success:function(s){if(s.success){r.weather_options.city=s.success.city;r.weather_options.lat=s.success.lat;r.weather_options.lon=s.success.lon}else{r.error()}r.init(r,"first")}})}this.$element.find("."+this._settings.more_class).click(function(){r.enlarge(r)});this.$element.find("."+this._settings.close_class).click(function(){r.close(r)});this.$element.find("."+this._settings.search_class).click(function(){r.openform(r)});this.$element.find("."+this._settings.closeform_class).click(function(){r.closeform(r)});if(this._hasIframe){this.resizeVideo(r);var l;f(i).resize(function(){clearTimeout(l);l=setTimeout(function(){r.resizeVideo(r)},200)})}if(this._isFull){r.setEQ(r);var l;f(i).resize(function(){clearTimeout(l);l=setTimeout(function(){r.setEQ(r)},200)})}this.$form.submit(function(u){u.preventDefault();var v=f('input:text[name="location"]',f(this)),s=f('select[name="units"]',f(this));if(v.val().length>0){var t=new google.maps.Geocoder();if(t){t.geocode({address:v.val()},function(x,w){if(w=="OK"&&typeof(x[0].geometry.location.lat())!="undefined"&&typeof(x[0].geometry.location.lng())!="undefined"){if(x[0].formatted_address.length>0){r.weather_options.city=x[0].formatted_address}r.weather_options.lat=x[0].geometry.location.lat();r.weather_options.lon=x[0].geometry.location.lng();r.weather_options.units=s.val()=="imperial"?"us":"si";r._settings.type="search";r.loading;r.init(r);r._newCall=true}else{r.error()}})}else{r.error()}}r.closeform(r)});if(this._startInit){this.init(r,"first")}}k.prototype={init:function(p,n){var r=(typeof(sessionStorage)==c)?(typeof(localStorage)==c)?{getItem:function(s){return this.store[s]},setItem:function(s,t){this.store[s]=t},removeItem:function(s){delete this.store[s]},clear:function(){for(var s in this.store){if(this.store.hasOwnProperty(s)){delete this.store[s]}}},store:{}}:localStorage:sessionStorage,m=this._settings.current+this.weather_options.lat+","+this.weather_options.lon+"?"+f.param(this.weather_options);var l=r.getItem(m+"cachettl");if(l&&l<+new Date()){r.removeItem(m);r.removeItem(m+"cachettl");l="expired"}var q=r.getItem(m);if(q){o(JSON.parse(q))}else{f.ajax({url:m,type:"GET",dataType:"jsonp",crossDomain:true,cache:true,success:function(s){strdata=JSON.stringify(s);if(s.error){p.error()}else{try{r.setItem(m,strdata);r.setItem(m+"cachettl",+new Date()+1000*60*60)}catch(t){r.removeItem(m);r.removeItem(m+"cachettl");console.log("Cache Error:"+t,m,strdata)}o(s)}},error:function(s,u,t){p.error()}})}function o(s){if(p._newCall!=true||n!="first"){p.success(s,function(){if(p._hasIframe){p.resizeVideo(p)}},n)}}},success:function(l,r,o){var p=this,q=this.weather_options.units=="us"?"f":"c",n=l.currently.hasOwnProperty("temperature")?l.currently.temperature:"";icon=l.currently.hasOwnProperty("icon")?l.currently.icon:"clear-day",condition=l.currently.hasOwnProperty("summary")?l.currently.summary:"",hi_temp=l.daily.data[0].hasOwnProperty("temperatureMax")?Math.round(l.daily.data[0].temperatureMax+0.00001)*100/100:"",lo_temp=l.daily.data[0].hasOwnProperty("temperatureMin")?Math.round(l.daily.data[0].temperatureMin+0.00001)*100/100:"",humidity=l.currently.hasOwnProperty("humidity")?Math.round(l.currently.humidity*100):"",wind=l.currently.hasOwnProperty("windSpeed")?this._getWind(l.currently.windBearing)+" "+Math.round((l.daily.data[0].windSpeed+0.00001)*100)/100:"",cloudiness=l.currently.hasOwnProperty("cloudCover")?Math.round(l.currently.cloudCover*100):"0",sunrise=l.daily.data[0].hasOwnProperty("sunriseTime")?this._getTime(l.daily.data[0].sunriseTime):"",sunset=l.daily.data[0].hasOwnProperty("sunsetTime")?this._getTime(l.daily.data[0].sunsetTime):"";if(o=="first"&&p._settings.type=="location"&&typeof(p._settings.heading)!="undefined"){var m=p._settings.heading}else{if(typeof(p.weather_options.city)!="undefined"&&(p.weather_options.city).length>0){var m=p.weather_options.city}else{p._geocode(function(t){var s=t=="error"?"":t;p._loadCurrent({location_class:s})})}}if(typeof(m)!="undefined"){p._loadCurrent({location_class:m})}this._loadCurrent({temp_class:Math.round(n),icon_class:this._getCode(icon),condition_class:condition,hi_temp_class:hi_temp,lo_temp_class:lo_temp,humidity_class:humidity,wind_class:wind,cloudiness_class:cloudiness,sunrise_class:sunrise,sunset_class:sunset,unit_class:this.weather_options["unit_"+q]});this._loadForecast(l.daily.data,{fc_hi_temp_class:"temperatureMax",fc_lo_temp_class:"temperatureMin",fc_condition_class:"summary",fc_cloud_class:"cloudCover",fc_humidity_class:"humidity"});this.$element.find("."+this._settings.loading_class+", ."+this._settings.more_placeholder_class).hide();this.$element.find("."+this._settings.more_class).removeClass("hide");this.$element.find("."+this._settings.icon_class).addClass("asterofont");if(this._hasImage){this.$background.removeClass(function(s,t){return(t.match(/(^|\s)astero-i-\S+/g)||[]).join(" ")}).addClass(this._getImage(icon))}if(typeof r=="function"){r.call(this)}},error:function(){this._loadCurrent({temp_class:"",icon_class:astero_fc_vars.na,condition_class:"___",location_class:"______",hi_temp_class:"___",lo_temp_class:"___",humidity_class:"",wind_class:"",cloudiness_class:"",sunrise_class:"",sunset_class:""});this.$element.find("."+this._settings.loading_class).hide();this.$element.find("."+this._settings.more_placeholder_class).show();this.$element.find("."+this._settings.more_class).addClass("hide");this.$element.find("."+this._settings.icon_class).removeClass("asterofont")},loading:function(){this._loadCurrent({temp_class:"",icon_class:"",condition_class:"___",location_class:"______",hi_temp_class:"___",lo_temp_class:"___",humidity_class:"",wind_class:"",cloudiness_class:"",sunrise_class:"",sunset_class:"",unit_class:"&deg;"});var m={fc_hi_temp_class:"",fc_lo_temp_class:"",fc_condition_class:"",fc_cloud_class:"",fc_humidity_class:"",};for(var l=0;l<this.forecast_options.cnt;l++){for(cl in m){this.$element.find("."+this._settings[cl]+l).html(m[cl])}}this.$element.find("."+this._settings.loading_class).show();this.$element.find("."+this._settings.more_placeholder_class).show();this.$element.find("."+this._settings.more_class).addClass("hide");this.$element.find("."+this._settings.icon_class).removeClass("asterofont")},enlarge:function(l){l.$element.addClass("open");l.$element.parents().css("z-index","999");if(l._hasIframe){l.resizeVideo(l)}l._disableScroll()},close:function(l){l.$element.removeClass("open");l.$element.parents().css("z-index","");if(l._hasIframe){l.resizeVideo(l)}l._enableScroll()},openform:function(l){l.$element.addClass("astero-openform")},closeform:function(l){l.$element.removeClass("astero-openform")},resizeVideo:function(p){p.$background.css("height","100%");var o=p.$element.find(".astero-yt"),n=p.$element.outerWidth(),m=parseFloat(p._settings.iframe_ratio);if(p.$element.hasClass("open")){n=p.$large.outerWidth();l=p.$large.outerHeight();p.$background.css("height",l)}else{var l=p.$element.outerHeight()}if(n/l<=m){o.css({height:l,width:l*m})}else{o.css({width:n,height:n/m})}},setEQ:function(m){var l=m.$element.outerWidth()/parseFloat(m.$element.css("font-size"));m.$large.removeClass("astero-eq-large astero-eq-small astero-eq-medium astero-eq-xsmall");if(l>=59.077){m.$large.addClass("astero-eq-large")}else{if(l<59.077&&l>=34.615){m.$large.addClass("astero-eq-medium")}else{if(l<34.615&&l>=15.385){m.$large.addClass("astero-eq-small")}else{if(l<15.385){m.$large.addClass("astero-eq-xsmall")}}}}},_disableScroll:function(){f("html").addClass("astero-open");if(f(j).height()>f(i).height()){f("html").css("top",-f(i).scrollTop()).addClass("astero-noscroll")}},_enableScroll:function(){var l=parseInt(f("html").css("top"));f("html").removeClass("astero-noscroll astero-open");f("html,body").scrollTop(-l)},_getCode:function(l){if(this.codes.hasOwnProperty(l)){return this.codes[l]}return this.codes["clear-day"]},_getImage:function(l){if(this._default_imgs.hasOwnProperty(l)){return this._default_imgs[l]}return this._default_imgs["clear-day"]},_loadCurrent:function(m){for(var l in m){this.$element.find("."+this._settings[l]).html(m[l])}},_loadForecast:function(n,p){var l=0;for(var m=1;m<this.forecast_options.cnt;m++){for(var o in p){var q=n[m][p[o]];if(o=="fc_cloud_class"||o=="fc_humidity_class"){q=q*100}if(typeof q=="number"){q=Math.round((q+0.00001))*100/100}this.$element.find("."+this._settings[o]+l).html(q)}this.$element.find("."+this._settings.fc_icon_class+l).html(this._getCode(n[m]["icon"]));l++}},_getWind:function(m){var l=[astero_fc_vars.n,astero_fc_vars.nne,astero_fc_vars.ne,astero_fc_vars.ene,astero_fc_vars.e,astero_fc_vars.ese,astero_fc_vars.se,astero_fc_vars.sse,astero_fc_vars.s,astero_fc_vars.ssw,astero_fc_vars.sw,astero_fc_vars.wsw,astero_fc_vars.w,astero_fc_vars.wnw,astero_fc_vars.nw,astero_fc_vars.nnw];return l[parseInt((m/22.5)+0.5)%16]},_getTime:function(n){var q=new Date(n*1000);var p=q.getHours(),l=("0"+q.getMinutes()).slice(-2),o=astero_fc_vars.am;if(p>12){p=p-12;o=astero_fc_vars.pm}else{if(p==0){p=12}}return p+":"+l+o},_geocode:function(n){var l=new google.maps.Geocoder(),m=new google.maps.LatLng(this.weather_options.lat,this.weather_options.lon);if(l){l.geocode({location:m},function(p,o){if(o=="OK"){if(p.length>1){result=p[1]}else{result=p[0]}n(result.formatted_address)}else{n("error")}})}else{n("error")}}};f.fn[h]=function(l){return this.each(function(){if(!f.data(this,"plugin_"+h)){var m=f(this).data(h);f.data(this,"plugin_"+h,new k(this,l,m))}})};f(j).ready(function(){f(".astero-forecast").astero_fc()})})(jQuery,window,document);var playerlist=document.querySelectorAll(".astero-yt");if(playerlist.length>0){var tag=document.createElement("script");tag.src="//www.youtube.com/iframe_api";var firstScriptTag=document.getElementsByTagName("script")[0];firstScriptTag.parentNode.insertBefore(tag,firstScriptTag)}function onYouTubeIframeAPIReady(){for(var a=0;a<playerlist.length;a++){var b=createPlayer(playerlist[a].getAttribute("id"),playerlist[a].getAttribute("data-videoid"))}}function createPlayer(b,a){return new YT.Player(b,{playerVars:{autoplay:1,showinfo:0,controls:0,modestbranding:1,rel:0,loop:1,div_load_policy:3,playlist:a,wmode:"transparent",origin:document.location.origin},allowfullscreen:0,videoId:a,events:{onReady:onPlayerReady}})}function onPlayerReady(a){a.target.mute();a.target.playVideo()};