( function( $ ) {
	'use strict';

	!function(e){var t,n,r,s=e.event,i={_:0},h=0;t=s.special.throttledresize={setup:function(){e(this).on("resize",t.handler)},teardown:function(){e(this).off("resize",t.handler)},handler:function(o,a){var l=this,d=arguments;n=!0,r||(setInterval(function(){h++,(h>t.threshold&&n||a)&&(o.type="throttledresize",s.dispatch.apply(l,d),n=!1,h=0),h>9&&(e(i).stop(),r=!1,h=0)},30),r=!0)},threshold:0}}(jQuery);

	function aBarUpdate() {
		$( 'body' ).trigger( 'announcementBarUpdate' );
	}
	
	function aBarDirection( reverse ) {
		var direction = ['top', 'bottom'];

		reverse !== undefined && direction.reverse();
		return direction[ + $( '.themify_announcement.bar' ).hasClass( 'announcement_bottom' ) ];
	}
	
	function aBarOffset() {
		$( '.themify_announcement.bar' ).each( function() {
			var $this = $( this ),
				h = $this.outerHeight( true ),
				$aBarOffsetEl = $( announcementBar.margin_top_to_bar_height );
			
			$this.find('.announcement_list').length && $aBarOffsetEl.css( 'margin-' + aBarDirection(), h );
			$( 'body' )
				.addClass( 'announcement-' + aBarDirection() )
				.trigger( 'announcement_bar_position', [ $this ] )
				.toggleClass( 'fixed-announcement-on', $this.hasClass( 'fixed' ) )
				.toggleClass( 'announcement-bar-showing', $this.is( ':visible' ) );
			
			aBarUpdate();
		});
	}

	function aBarToggleOffset( state, step ) {
		var h = $( '.themify_announcement.bar' ).outerHeight( true ),
			$aBarOffsetEl = $( announcementBar.margin_top_to_bar_height ),
			style = {};

		$aBarOffsetEl.toggleClass( 'announcement-bar-collapsed', state == 'close' );

		if( step !== undefined ) {
			style[ 'margin-' + aBarDirection() ] = step;
			$aBarOffsetEl.css( style );

			if ( ( step === 0 && state == 'close' ) || ( step === h && state !== 'close' ) ) {
				$aBarOffsetEl.toggleClass( 'announcement-bar-showing', state !== 'close' );
			}
		} else {
			style[ 'margin-' + aBarDirection() ] = state !== 'close' ? h : '';
			
			$aBarOffsetEl.animate( style, {
				duration: 400,
				step: aBarUpdate,
				complete: function() {
					$aBarOffsetEl.toggleClass( 'announcement-bar-showing', state !== 'close' );
				}
			} );
		}

		aBarUpdate();
	}

	function aBarSetCookie( name, value ) {
		document.cookie = name + "=" + value + "; path=/";
	}

	function aBarGetCookie( name ) {
		name = name + "=";
		var ca = document.cookie.split( ';' );

		for( var i = 0; i < ca.length; i++ ) {
			var c = ca[i];
			while ( ' ' == c.charAt(0) ) c = c.substring( 1, c.length );
			if ( 0 == c.indexOf( name ) ) return c.substring( name.length, c.length );
		}

		return null;
	}

	// Remember State Close Btn
	function aBarStateClose( element_id ) {
		var $this = $( '#' + element_id ).find( '.announcement_list' ),
			$container = $( '#' + element_id ),
			anime = {};

		if( ! $this.data( 'remember-close' ) || $this.data( 'remember-close' ) == 0 ) return;

		if( typeof( aBarGetCookie(' announ-toggle-close' ) ) != 'undefined'
			&& aBarGetCookie( 'announ-toggle-close' ) !== null 
			&& aBarGetCookie( 'announ-toggle-close' ) == 'collapsed' ) {
			aBarToggleOffset( 'close' );
			$container.addClass( 'collapsed' )
				.find( '.announcement_container:not(.close-container)' ).hide();

			// Toggle Button
			var closeBtnHeight = $container.find( '.toggle-close' ).height();
			anime[ aBarDirection( true ) ] = '-' + closeBtnHeight + 'px';
			$container.find( '.toggle-close' ).show().animate( anime, 400 );
		}
	}

	// Create Carousel function
	function aBarCreateCarousel( $context ) {
		$context = $context || $('body');

		$( '.announcement_list', $context ).each( function() {
			var $this = $( this ),
				$container = $this.closest( '.announcement_container' );

			// Dont initialize when it already init
			if ( $container.find( '.announCarouFredSel_wrapper' ).length ) return;

			// Remove announcement bar if the items doesn't founded
			if ( ! $this.find( 'li' ).length ) {
				$this.closest( '.themify_announcement' ).remove();
				return;
			}

			var id = $this.data( 'id' ),
				autoScroll = ( "" == $this.data( 'auto-scroll' ) ) ? 0 : $this.data( 'auto-scroll' ) ,
				effect = $this.data( 'effect' ),
				effect_speed = $this.data( 'effect_speed' ),
				timer = $this.data( 'timer' ),
				secondOpts = {},
				opts = {
					responsive: true,
					circular: true,
					infinite: true,
					items: {
						visible: { min: 1, max: $this.data( 'visible' ) },
						width: 222
					},
					swipe: true,
					onCreate: function( items ) {
						$this.closest( '.themify_announcement' )
							.fadeIn().end()
							.trigger( 'updateSizes' )
							.trigger( 'configuration', ['reInit', true] );
						aBarOffset();
						aBarStateClose( id );

						new MutationObserver( aBarOffset )
							.observe( $this.get(0), { attributes: true } );
					}
				};

			// Auto
			if( parseInt( autoScroll ) > 0 ) {
				opts.auto = {
					play: true,
					timeoutDuration: parseInt( autoScroll * 1000 ),
					pauseOnHover: 'resume'
				};
			} else if( effect !== 'continuously' && parseInt( autoScroll ) == 0 ) {
				opts.auto = false;
			}

			// Scroll
			if( effect == 'continuously' ) {
				typeof opts.auto !== 'undefined' && delete opts.auto;
				opts.align = false;
				opts.scroll = {
					delay: 1000,
					easing: 'linear',
					items: $this.data( 'scroll' ),
					duration: 0.07,
					timeoutDuration: 0,
					pauseOnHover: 'immediate'
				};
				if ( effect_speed == 'slow' ){
					opts.scroll.duration = 0.03;
				} else if (effect_speed == 'fast') {
					opts.scroll.duration = 0.11;
				}
			} else {
				opts.scroll = {
					items: $this.data( 'scroll' ),
					pauseOnHover: 'resume',
					duration: parseInt( $this.data( 'speed' ) * 1000 ),
					fx: effect
				};
			}

			if( $this.data( 'arrow' ) == 'yes' ) {
				opts.prev = '#' + id + ' .carousel-prev';
				opts.next = '#' + id + ' .carousel-next';
			}

			if( $this.data( 'pagination' ) == 'yes' ) {
				opts.pagination = { container: '#' + id + ' .carousel-pager' };
			}

			if( $this.data('wrap') == 'no' ) secondOpts.wrapper = 'parent';

			opts.scroll.onAfter = function(){
				aBarOffset();
				$( 'body' ).trigger( 'announcement_bar_scroll_on_after' );
			}

			// Timer
			if( ( timer > 0 || timer == 'on' ) && typeof opts.auto !== 'undefined' ) {
				opts.auto.progress = { bar: '#' + id + ' .timer .timer-bar' };
			}

			$this.announCarouFredSel( opts, secondOpts );
		});
	}

	$( 'body' ).on( 'click', '.announcement_content .more-link', function( e ) {
		e.preventDefault();

		var $this = $( this );

		$this.toggleClass( 'active' )
			.closest( '.announcement_post' )
			.find( '.more_wrap' )
			.slideToggle( {
				step: function() {
					$( window ).trigger( 'resize' );
				},
				complete: function() {
					var $list = $( this ).closest( '.announcement_list' );

					if( parseInt( $list.data( 'auto-scroll' ) ) > 0 )
						$this.hasClass( 'active' ) ? $list.trigger( 'stop' ) : $list.trigger( 'play', true );

					$list
						.trigger( 'updateSizes')
						.trigger( 'configuration', ['reInit', true] );
				}
			} );
	});

	$( 'body' ).on( 'click', '.carousel-nav-wrap a', function() {
		var $list = $(this).closest('.announcement_container').find( '.announcement_list' );
		
		parseInt( $list.data( 'auto-scroll' ) ) > 0 && $list.trigger( 'play', true );
	} );

	$( '.themify_announcement .close' ).on( 'click', function( e ) {
		e.preventDefault();

		var type = $( this ).data( 'type' ),
			$aBar = $( this ).closest( '.themify_announcement' );

		if( type == 'close' ){
			$aBar.slideUp( 'slow' );
			aBarSetCookie( 'announ-toggle-close', 'collapsed' );
			$aBar.hasClass( 'bar' ) && aBarToggleOffset( 'close' );
		} else if( type == 'toggleable' ) {
			var closeBtnHeight = $aBar.find( '.toggle-close' ).height();
			
			$(this).closest('.announcement_container').animate( {
				height: 'toggle'
			}, {
				duration: 400,
				step: function( step ) {
					$aBar.hasClass( 'bar' ) && aBarToggleOffset( 'close', step );
				},
				complete: function() {
					var anime = {};

					$aBar.toggleClass( 'collapsed' );
					aBarSetCookie( 'announ-toggle-close', $aBar.hasClass( 'collapsed' ) ? 'collapsed' : 'expanded' );
					anime[ aBarDirection( true ) ] = '-' + closeBtnHeight + 'px';
					$aBar.find( '.toggle-close' ).show().animate( anime, 400 );
				}
			} );
		}

	});

	$( '.themify_announcement .toggle-close' ).on( 'click', function( e ) {
		e.preventDefault();

		var style = {},
			$aBar = $( this ).closest( '.themify_announcement' );

		style[ aBarDirection( true ) ] = 'toggle';

		// Hide the close toggle
		$( this ).animate( style, 400, function() {
			$(this).removeAttr( 'style' );
			$aBar.toggleClass( 'collapsed' ).find( '.announcement_container:not(.close-container)' )
				.animate( {
					height: 'toggle'
				}, {
					duration: 400,
					step: function( step ) {
						$aBar.hasClass( 'bar' ) && aBarToggleOffset( 'expand', step );
					},
					complete: function() {
						aBarSetCookie( 'announ-toggle-close', $aBar.hasClass( 'collapsed' ) ? 'collapsed' : 'expanded' );
						$( this ).find( '.announcement_list' )
							.trigger( 'updateSizes' )
							.trigger( 'configuration', ['reInit', true] );
					}
				} );
		});
	});

	function barHeaderRelation() {
		var $aBarOffsetEl = $( announcementBar.margin_top_to_bar_height ),
			$aBar = $( '.themify_announcement.bar' );

		if( $aBarOffsetEl.length && $aBar.length ) {
			var aBarPosition = $aBar.get( 0 ).getBoundingClientRect();

			$aBar
				.addClass( 'themify-header-is-' + $aBarOffsetEl.css( 'position' ) )
				.toggleClass( 'themify-abar-hidden', aBarPosition.bottom < 0 )
				.toggleClass( 'themify-abar-visible', aBarPosition.bottom > 0 );
		}
	}

	$( window )
		.on( 'resize throttledresize', aBarOffset )
		.load( function() {
			aBarCreateCarousel();

			$('body')
				.on( 'builder_load_module_partial', function( e, $newElemn ) { aBarCreateCarousel( $newElemn ); } )
				.on( 'builder_toggle_frontend', function() { aBarCreateCarousel(); } );

			barHeaderRelation();
		} )
		.on( 'scroll', barHeaderRelation );

} )( jQuery );