<?php
/*
Plugin Name: LambertGroup - AllInOne - Banner with Thumbnails
Description: This plugin will allow you to administrate an advanced banner with thumbnails and animated text from any direction: top, bottom, left and right.
Version: 3.7.2
Author: پرشین اسکریپت
Author URI: http://www.persianscript.ir
*/

ini_set('display_errors', 0);
//$wpdb->show_errors();
$all_in_one_thumbnailsBanner_path = trailingslashit(dirname(__FILE__));  //empty

//all the messages
$all_in_one_thumbnailsBanner_messages = array(
		'version' => '<div class="error">LambertGroup - AllInOne Thumbnails Banner plugin requires WordPress 3.0 or newer. <a href="https://codex.wordpress.org/Upgrading_WordPress">Please update!</a></div>',
		'empty_img' => 'Image - required',
		'invalid_request' => 'Invalid Request!',
		'generate_for_this_banner' => 'You can start customizing this slider.',
		'data_saved' => 'Data Saved!'
	);


	global $general_param; // for activation_hook only
	$general_param = array(
		'css_styles_const' => '/*textWhiteBgBlack*/
	.all_in_one_thumbnailsBanner_textWhiteBgBlack_small {
		font-family: Arial;
		font-size:12px;
		line-height:12px;
		font-weight:bold;
		color:#FFF;
		background:#000;
		padding:5px 6px;
		margin:0;
	}
	.all_in_one_thumbnailsBanner_textWhiteBgBlack_small a {
		color:#FFF;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textWhiteBgBlack_small a:hover {
		color:#F00;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textWhiteBgBlack_medium {
		font-family: Arial;
		font-size:22px;
		line-height:22px;
		font-weight:normal;
		color:#FFF;
		background:#000;
		padding:6px 7px;
		margin:0;
	}
	.all_in_one_thumbnailsBanner_textWhiteBgBlack_medium a {
		color:#FFF;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textWhiteBgBlack_medium a:hover {
		color:#F00;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textWhiteBgBlack_large {
		font-family: Arial;
		font-size:36px;
		line-height:36px;
		font-weight:normal;
		color:#FFF;
		background:#000;
		padding:7px 10px;
		margin:0;
	}
	.all_in_one_thumbnailsBanner_textWhiteBgBlack_large a {
		color:#FFF;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textWhiteBgBlack_large a:hover {
		color:#F00;
		text-decoration:underline;
	}
	/*textBlackBgWhite*/
	.all_in_one_thumbnailsBanner_textBlackBgWhite_small {
		font-family: Arial;
		font-size:12px;
		line-height:12px;
		font-weight:bold;
		color:#000;
		background:#FFF;
		padding:5px 6px;
		margin:0;
	}
	.all_in_one_thumbnailsBanner_textBlackBgWhite_small a {
		color:#000;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textBlackBgWhite_small a:hover {
		color:#F00;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textBlackBgWhite_medium {
		font-family: Arial;
		font-size:22px;
		line-height:22px;
		font-weight:normal;
		color:#000;
		background:#FFF;
		padding:6px 7px;
		margin:0;
	}
	.all_in_one_thumbnailsBanner_textBlackBgWhite_medium a {
		color:#000;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textBlackBgWhite_medium a:hover {
		color:#F00;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textBlackBgWhite_large {
		font-family: Arial;
		font-size:36px;
		line-height:36px;
		font-weight:normal;
		color:#000;
		background:#FFF;
		padding:7px 10px;
		margin:0;
	}
	.all_in_one_thumbnailsBanner_textBlackBgWhite_large a {
		color:#000;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textBlackBgWhite_large a:hover {
		color:#F00;
		text-decoration:underline;
	}
	/*textRedBgWhite*/
	.all_in_one_thumbnailsBanner_textRedBgWhite_small {
		font-family: Arial;
		font-size:12px;
		line-height:12px;
		font-weight:bold;
		color:#F00;
		background:#FFF;
		padding:5px 6px;
		margin:0;
	}
	.all_in_one_thumbnailsBanner_textRedBgWhite_small a {
		color:#F00;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textRedBgWhite_small a:hover {
		color:#000;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textRedBgWhite_medium {
		font-family: Arial;
		font-size:22px;
		line-height:22px;
		font-weight:normal;
		color:#F00;
		background:#FFF;
		padding:6px 7px;
		margin:0;
	}
	.all_in_one_thumbnailsBanner_textRedBgWhite_medium a {
		color:#F00;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textRedBgWhite_medium a:hover {
		color:#000;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textRedBgWhite_large {
		font-family: Arial;
		font-size:36px;
		line-height:36px;
		font-weight:normal;
		color:#F00;
		background:#FFF;
		padding:7px 10px;
		margin:0;
	}
	.all_in_one_thumbnailsBanner_textRedBgWhite_large a {
		color:#F00;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textRedBgWhite_large a:hover {
		color:#000;
		text-decoration:underline;
	}
	/*textBlueBgWhite*/
	.all_in_one_thumbnailsBanner_textBlueBgWhite_small {
		font-family: Arial;
		font-size:12px;
		line-height:12px;
		font-weight:bold;
		color:#00F;
		background:#FFF;
		padding:5px 6px;
		margin:0;
	}
	.all_in_one_thumbnailsBanner_textBlueBgWhite_small a {
		color:#00F;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textBlueBgWhite_small a:hover {
		color:#F00;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textBlueBgWhite_medium {
		font-family: Arial;
		font-size:22px;
		line-height:22px;
		font-weight:normal;
		color:#00F;
		background:#FFF;
		padding:6px 7px;
		margin:0;
	}
	.all_in_one_thumbnailsBanner_textBlueBgWhite_medium a {
		color:#00F;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textBlueBgWhite_medium a:hover {
		color:#F00;
		text-decoration:underline;
	}

	.all_in_one_thumbnailsBanner_textBlueBgWhite_large {
		font-family: Arial;
		font-size:36px;
		line-height:36px;
		font-weight:normal;
		color:#00F;
		background:#FFF;
		padding:7px 10px;
		margin:0;
	}
	.all_in_one_thumbnailsBanner_textBlueBgWhite_large a {
		color:#00F;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textBlueBgWhite_large a:hover {
		color:#F00;
		text-decoration:underline;
	}
	/*textWhiteBgTransparent*/
	.all_in_one_thumbnailsBanner_textWhiteBgTransparent_small {
		font-family: Arial;
		font-size:12px;
		line-height:12px;
		font-weight:bold;
		color:#FFF;
		background:none;
		padding:0;
		margin:0;
	}
	.all_in_one_thumbnailsBanner_textWhiteBgTransparent_small a {
		color:#FFF;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textWhiteBgTransparent_small a:hover {
		color:#F00;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textWhiteBgTransparent_medium {
		font-family: Arial;
		font-size:22px;
		line-height:22px;
		font-weight:normal;
		color:#FFF;
		background:none;
		padding:0;
		margin:0;
	}
	.all_in_one_thumbnailsBanner_textWhiteBgTransparent_medium a {
		color:#FFF;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textWhiteBgTransparent_medium a:hover {
		color:#F00;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textWhiteBgTransparent_large {
		font-family: Arial;
		font-size:36px;
		line-height:36px;
		font-weight:normal;
		color:#FFF;
		background:none;
		padding:0;
		margin:0;
	}
	.all_in_one_thumbnailsBanner_textWhiteBgTransparent_large a {
		color:#FFF;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textWhiteBgTransparent_large a:hover {
		color:#F00;
		text-decoration:underline;
	}
	/*textBlackBgTransparent*/
	.all_in_one_thumbnailsBanner_textBlackBgTransparent_small {
		font-family: Arial;
		font-size:12px;
		line-height:12px;
		font-weight:bold;
		color:#000;
		background:none;
		padding:0;
		margin:0;
	}
	.all_in_one_thumbnailsBanner_textBlackBgTransparent_small a {
		color:#000;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textBlackBgTransparent_small a:hover {
		color:#F00;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textBlackBgTransparent_medium {
		font-family: Arial;
		font-size:22px;
		line-height:22px;
		font-weight:normal;
		color:#000;
		background:none;
		padding:0;
		margin:0;
	}
	.all_in_one_thumbnailsBanner_textBlackBgTransparent_medium a {
		color:#000;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textBlackBgTransparent_medium a:hover {
		color:#F00;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textBlackBgTransparent_large {
		font-family: Arial;
		font-size:36px;
		line-height:36px;
		font-weight:normal;
		color:#000;
		background:none;
		padding:0;
		margin:0;
	}
	.all_in_one_thumbnailsBanner_textBlackBgTransparent_large a {
		color:#000;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textBlackBgTransparent_large a:hover {
		color:#F00;
		text-decoration:underline;
	}
	/*textRedBgTransparent*/
	.all_in_one_thumbnailsBanner_textRedBgTransparent_small {
		font-family: Arial;
		font-size:12px;
		line-height:12px;
		font-weight:bold;
		color:#F00;
		background:none;
		padding:0;
		margin:0;
	}
	.all_in_one_thumbnailsBanner_textRedBgTransparent_small a {
		color:#F00;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textRedBgTransparent_small a:hover {
		color:#000;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textRedBgTransparent_medium {
		font-family: Arial;
		font-size:22px;
		line-height:22px;
		font-weight:normal;
		color:#F00;
		background:none;
		padding:0;
		margin:0;
	}
	.all_in_one_thumbnailsBanner_textRedBgTransparent_medium a {
		color:#F00;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textRedBgTransparent_medium a:hover {
		color:#000;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textRedBgTransparent_large {
		font-family: Arial;
		font-size:36px;
		line-height:36px;
		font-weight:normal;
		color:#F00;
		background:none;
		padding:0;
		margin:0;
	}
	.all_in_one_thumbnailsBanner_textRedBgTransparent_large a {
		color:#F00;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textRedBgTransparent_large a:hover {
		color:#000;
		text-decoration:underline;
	}
	/*textBlueBgTransparent*/
	.all_in_one_thumbnailsBanner_textBlueBgTransparent_small {
		font-family: Arial;
		font-size:12px;
		line-height:12px;
		font-weight:bold;
		color:#00F;
		background:none;
		padding:0;
		margin:0;
	}
	.all_in_one_thumbnailsBanner_textBlueBgTransparent_small a {
		color:#00F;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textBlueBgTransparent_small a:hover {
		color:#F00;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textBlueBgTransparent_medium {
		font-family: Arial;
		font-size:22px;
		line-height:22px;
		font-weight:normal;
		color:#00F;
		background:none;
		padding:0;
		margin:0;
	}
	.all_in_one_thumbnailsBanner_textBlueBgTransparent_medium a {
		color:#00F;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textBlueBgTransparent_medium a:hover {
		color:#F00;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textBlueBgTransparent_large {
		font-family: Arial;
		font-size:36px;
		line-height:36px;
		font-weight:normal;
		color:#00F;
		background:none;
		padding:0;
		margin:0;
	}
	.all_in_one_thumbnailsBanner_textBlueBgTransparent_large a {
		color:#00F;
		text-decoration:underline;
	}
	.all_in_one_thumbnailsBanner_textBlueBgTransparent_large a:hover {
		color:#F00;
		text-decoration:underline;
	}'
	);


global $wp_version;

if ( !version_compare($wp_version,"3.0",">=")) {
	die ($all_in_one_thumbnailsBanner_messages['version']);
}




function all_in_one_thumbnailsBanner_activate() {
	//db creation, create admin options etc.
	global $wpdb;
	global $general_param;
	//$wpdb->show_errors();

	$all_in_one_thumbnailsBanner_collate = ' COLLATE utf8_general_ci';

	$sql0 = "CREATE TABLE `" . $wpdb->prefix . "all_in_one_thumbnailsBanner_banners` (
			`id` INT UNSIGNED NOT NULL AUTO_INCREMENT ,
			`name` VARCHAR( 255 ) NOT NULL ,
			PRIMARY KEY ( `id` )
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8";

	$sql1 = "CREATE TABLE `" . $wpdb->prefix . "all_in_one_thumbnailsBanner_settings` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `skin` varchar(255) NOT NULL DEFAULT 'classic',
  `width` smallint(5) unsigned NOT NULL DEFAULT '960',
  `height` smallint(5) unsigned NOT NULL DEFAULT '384',
  `width100Proc` varchar(8) NOT NULL DEFAULT 'false',
  `height100Proc` varchar(8) NOT NULL DEFAULT 'false',
  `randomizeImages` varchar(8) NOT NULL DEFAULT 'false',
  `firstImg` smallint(5) unsigned NOT NULL DEFAULT '0',
  `numberOfStripes` smallint(5) unsigned NOT NULL DEFAULT '20',
  `numberOfRows` smallint(5) unsigned NOT NULL DEFAULT '5',
  `numberOfColumns` smallint(5) unsigned NOT NULL DEFAULT '10',
  `defaultEffect` varchar(255) NOT NULL DEFAULT 'random',
  `effectDuration` float unsigned NOT NULL DEFAULT '0.5',
  `autoPlay` smallint(5) unsigned NOT NULL DEFAULT '4',
  `loop` varchar(8) NOT NULL DEFAULT 'true',
  `target` varchar(8) NOT NULL DEFAULT '_blank',
  `showAllControllers` varchar(8) NOT NULL DEFAULT 'true',
  `showNavArrows` varchar(8) NOT NULL DEFAULT 'true',
  `showOnInitNavArrows` varchar(8) NOT NULL DEFAULT 'true',
  `autoHideNavArrows` varchar(8) NOT NULL DEFAULT 'true',
  `showThumbs` varchar(8) NOT NULL DEFAULT 'true',
  `showOnInitThumbs` varchar(8) NOT NULL DEFAULT 'true',
  `autoHideThumbs` varchar(8) NOT NULL DEFAULT 'false',
  `numberOfThumbsPerScreen` smallint(5) unsigned NOT NULL DEFAULT '0',
  `thumbsReflection` smallint(5) unsigned NOT NULL DEFAULT '50',
  `enableTouchScreen` varchar(8) NOT NULL DEFAULT 'true',
  `showCircleTimer` varchar(8) NOT NULL DEFAULT 'true',
  `showCircleTimerIE8IE7` varchar(8) NOT NULL DEFAULT 'false',
  `circleRadius` smallint(5) unsigned NOT NULL DEFAULT '10',
  `circleLineWidth` smallint(5) unsigned NOT NULL DEFAULT '4',
  `circleColor` varchar(8) NOT NULL DEFAULT 'ff0000',
  `circleAlpha` smallint(5) unsigned NOT NULL DEFAULT '100',
  `behindCircleColor` varchar(8) NOT NULL DEFAULT '000000',
  `behindCircleAlpha` smallint(5) unsigned NOT NULL DEFAULT '50',
  `responsive` varchar(8) NOT NULL DEFAULT 'true',
  `responsiveRelativeToBrowser` varchar(8) NOT NULL DEFAULT 'false',
  `thumbsOnMarginTop` smallint(5) NOT NULL DEFAULT '0',
  `thumbsWrapperMarginTop` smallint(5) NOT NULL DEFAULT '0',
	  PRIMARY KEY  (`id`)
	) ENGINE=MyISAM  DEFAULT CHARSET=utf8";

	$sql2 = "CREATE TABLE `". $wpdb->prefix . "all_in_one_thumbnailsBanner_playlist` (
	  `id` int(10) unsigned NOT NULL auto_increment,
	  `bannerid` int(10) unsigned NOT NULL,
	  `img` text,
	  `thumbnail` text,
	  `alt_text` text,
	  `data-transition` varchar(255),
	  `data-target` varchar(8) NOT NULL DEFAULT '_blank',
	  `data-link` text,
	  `ord` int(10) unsigned NOT NULL,
	  PRIMARY KEY  (`id`)
	) ENGINE=MyISAM  DEFAULT CHARSET=utf8";

	$sql3 = "CREATE TABLE `". $wpdb->prefix . "all_in_one_thumbnailsBanner_texts` (
	  `id` int(10) unsigned NOT NULL auto_increment,
	  `photoid` int(10) unsigned NOT NULL,
		`img_src` text,
	  `content` text,
	  `data-initial-left` smallint(5),
	  `data-initial-top` smallint(5),
	  `data-final-left` smallint(5),
	  `data-final-top` smallint(5),
	  `data-duration` float unsigned,
	  `data-fade-start` smallint(5) unsigned,
	  `data-delay` float unsigned,
	  `css` text,
		`ord` int(10) unsigned NOT NULL,
	  PRIMARY KEY  (`id`)
	) ENGINE=MyISAM  DEFAULT CHARSET=utf8";

	$sql4 = "CREATE TABLE `". $wpdb->prefix . "all_in_one_thumbnailsBanner_css_definitions` (
		`id` int(2) unsigned NOT NULL auto_increment,
		`css_styles` text,
		`css_styles_orig` text,
		PRIMARY KEY  (`id`)
	) ENGINE=MyISAM  DEFAULT CHARSET=utf8";

	require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
	dbDelta($sql0.$all_in_one_thumbnailsBanner_collate);
	dbDelta($sql1.$all_in_one_thumbnailsBanner_collate);
	dbDelta($sql2.$all_in_one_thumbnailsBanner_collate);
	dbDelta($sql3.$all_in_one_thumbnailsBanner_collate);
	dbDelta($sql4.$all_in_one_thumbnailsBanner_collate);

	//initialize the banners table with the first banner type
	$rows_count = $wpdb->get_var( "SELECT COUNT(*) FROM ". $wpdb->prefix ."all_in_one_thumbnailsBanner_banners;" );
	if (!$rows_count) {
		$wpdb->insert(
			$wpdb->prefix . "all_in_one_thumbnailsBanner_banners",
			array(
				'name' => 'First Banner'
			),
			array(
				'%s'
			)
		);
	}

	// initialize the settings
	$rows_count = $wpdb->get_var( "SELECT COUNT(*) FROM ". $wpdb->prefix ."all_in_one_thumbnailsBanner_settings;" );
	if (!$rows_count) {
		all_in_one_thumbnailsBanner_insert_settings_record(1);
	}


	//initialize the css styles
	$rows_count = $wpdb->get_var( "SELECT COUNT(*) FROM ". $wpdb->prefix ."all_in_one_thumbnailsBanner_css_definitions;" );
	if (!$rows_count) {
		$wpdb->insert(
			$wpdb->prefix . "all_in_one_thumbnailsBanner_css_definitions",
			array(
				'css_styles' => $general_param['css_styles_const'],
				'css_styles_orig' => $general_param['css_styles_const']
			),
			array(
				'%s',
				'%s'
			)
		);
	}


}


function all_in_one_thumbnailsBanner_uninstall() {
	global $wpdb;
	/*mysql_query("DROP TABLE `" . $wpdb->prefix . "all_in_one_thumbnailsBanner_settings`" );
	mysql_query("DROP TABLE `" . $wpdb->prefix . "all_in_one_thumbnailsBanner_playlist`" );
	mysql_query("DROP TABLE `" . $wpdb->prefix . "all_in_one_thumbnailsBanner_banners`" );
	mysql_query("DROP TABLE `" . $wpdb->prefix . "all_in_one_thumbnailsBanner_texts`" );*/

	$sql = "DROP TABLE IF EXISTS `" . $wpdb->prefix . "all_in_one_thumbnailsBanner_settings`";
	$wpdb->query($sql);

	$sql = "DROP TABLE IF EXISTS `" . $wpdb->prefix . "all_in_one_thumbnailsBanner_playlist`";
	$wpdb->query($sql);

	$sql = "DROP TABLE IF EXISTS `" . $wpdb->prefix . "all_in_one_thumbnailsBanner_banners`";
	$wpdb->query($sql);

	$sql = "DROP TABLE IF EXISTS `" . $wpdb->prefix . "all_in_one_thumbnailsBanner_texts`";
	$wpdb->query($sql);

	$sql = "DROP TABLE IF EXISTS `" . $wpdb->prefix . "all_in_one_thumbnailsBanner_css_definitions`";
	$wpdb->query($sql);
}

function all_in_one_thumbnailsBanner_insert_settings_record($banner_id) {
	global $wpdb;
	$wpdb->insert(
			$wpdb->prefix . "all_in_one_thumbnailsBanner_settings",
			array(
				'width' => 960,
				'height' => 384,
				'skin' => 'cool',
				'randomizeImages' => 'false',
				'firstImg' => 0,
				'numberOfStripes' => 20,
				'numberOfRows' => 5,
				'numberOfColumns' => 10,
				'defaultEffect' => 'random',
			    'effectDuration' => 0.50,
				'autoPlay' => 4,
				'loop' => 'true',
				'showAllControllers' => 'true',
				'showNavArrows' => 'true',
				'showOnInitNavArrows' => 'true',
				'autoHideNavArrows' => 'true',
				'showThumbs' => 'true',
				'showOnInitThumbs' => 'true',
				'autoHideThumbs' => 'false',
				'numberOfThumbsPerScreen' => 0,
				'thumbsReflection' => 50,
				'enableTouchScreen' => 'true'
			),
			array(
				'%d',
				'%d',
				'%s',
				'%s',
				'%d',
				'%d',
				'%d',
				'%d',
				'%s',
				'%f',
				'%d',
				'%s',
				'%s',
				'%s',
				'%s',
				'%s',
				'%s',
				'%s',
				'%s',
				'%d',
				'%d',
				'%s'
			)
		);
}


function all_in_one_thumbnailsBanner_init_sessions() {
	global $wpdb;
	if (is_admin()) {
		if (!session_id()) {
			session_start();

			//initialize the session
			if (!isset($_SESSION['xid'])) {
				$safe_sql="SELECT * FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_banners) LIMIT 0, 1";
				$row = $wpdb->get_row($safe_sql,ARRAY_A);
				//$row=all_in_one_thumbnailsBanner_unstrip_array($row);
				$_SESSION['xid'] = $row['id'];
				$_SESSION['xname'] = $row['name'];
			}
		}
	}
}


function all_in_one_thumbnailsBanner_load_styles() {
	if(strpos($_SERVER['PHP_SELF'], 'wp-admin') !== false) {
		$page = (isset($_GET['page'])) ? $_GET['page'] : '';
		if(preg_match('/all_in_one_thumbnailsBanner/i', $page)) {
			//wp_enqueue_style('all_in_one_thumbnailsBanner_jquery-custom_css', plugins_url('css/custom-theme/jquery-ui-1.8.10.custom.css', __FILE__));
			//wp_enqueue_style('lbg-jquery-ui-custom_css', 'https://ajax.googleapis.com/ajax/libs/jqueryui/1.10.3/themes/pepper-grinder/jquery-ui.min.css');
			wp_enqueue_style('lbg-jquery-ui-custom_css', plugins_url('css/jquery-ui.min.css', __FILE__));
			wp_enqueue_style('all_in_one_thumbnailsBanner_css', plugins_url('css/styles.css', __FILE__));
			wp_enqueue_style('all_in_one_thumbnailsBanner_colorpicker_css', plugins_url('css/colorpicker/colorpicker.css', __FILE__));


			wp_enqueue_style('thickbox');
		}
	} else if (!is_admin()) { //loads css in front-end
		wp_enqueue_style('all_in_one_thumbnailsBanner_site_css', plugins_url('thumbnailsBanner/allinone_thumbnailsBanner.css', __FILE__));
		wp_enqueue_style('all_in_one_thumbnailsBanner_text_classes', plugins_url('thumbnailsBanner/text_classes.css', __FILE__));
	}
}

function all_in_one_thumbnailsBanner_load_scripts() {
	global $is_IE;
	$page = (isset($_GET['page'])) ? $_GET['page'] : '';
	if(preg_match('/all_in_one_thumbnailsBanner/i', $page)) {
		//loads scripts in admin
		//if (is_admin()) {
			//wp_deregister_script('jquery');
			wp_enqueue_script('jquery');

			wp_enqueue_script('jquery-ui-core');
			wp_enqueue_script('jquery-ui-widget');
			wp_enqueue_script('jquery-ui-mouse');
			wp_enqueue_script('jquery-ui-accordion');
			wp_enqueue_script('jquery-ui-autocomplete');
			wp_enqueue_script('jquery-ui-slider');
			wp_enqueue_script('jquery-ui-tabs');
			wp_enqueue_script('jquery-ui-sortable');
			wp_enqueue_script('jquery-ui-draggable');
			wp_enqueue_script('jquery-ui-droppable');
			wp_enqueue_script('jquery-ui-selectable');
			wp_enqueue_script('jquery-ui-position');
			wp_enqueue_script('jquery-ui-datepicker');
			wp_enqueue_script('jquery-ui-resizable');
			wp_enqueue_script('jquery-ui-dialog');
			wp_enqueue_script('jquery-ui-button');

			wp_enqueue_script('jquery-form');
			wp_enqueue_script('jquery-color');
			wp_enqueue_script('jquery-masonry');
			wp_enqueue_script('jquery-ui-progressbar');
			wp_enqueue_script('jquery-ui-tooltip');

			wp_enqueue_script('jquery-effects-core');
			wp_enqueue_script('jquery-effects-blind');
			wp_enqueue_script('jquery-effects-bounce');
			wp_enqueue_script('jquery-effects-clip');
			wp_enqueue_script('jquery-effects-drop');
			wp_enqueue_script('jquery-effects-explode');
			wp_enqueue_script('jquery-effects-fade');
			wp_enqueue_script('jquery-effects-fold');
			wp_enqueue_script('jquery-effects-highlight');
			wp_enqueue_script('jquery-effects-pulsate');
			wp_enqueue_script('jquery-effects-scale');
			wp_enqueue_script('jquery-effects-shake');
			wp_enqueue_script('jquery-effects-slide');
			wp_enqueue_script('jquery-effects-transfer');

			//wp_register_script('lbg-admin-jquery-ui-min', plugins_url('js/jquery-ui-1.8.10.custom.min.js', __FILE__));
			//wp_register_script('lbg-admin-jquery-ui-min', 'http://ajax.googleapis.com/ajax/libs/jqueryui/1.8.23/jquery-ui.min.js');
			/*wp_register_script('lbg-admin-jquery-ui-min', 'http://ajax.googleapis.com/ajax/libs/jqueryui/1.9.2/jquery-ui.min.js');
			wp_enqueue_script('lbg-admin-jquery-ui-min');*/

			wp_register_script('lbg-admin-jquery-ui-core', includes_url().'js/jquery/ui/core.min.js');
			wp_enqueue_script('lbg-admin-jquery-ui-core');

			wp_register_script('lbg-admin-jquery-ui-widget', includes_url().'js/jquery/ui/widget.min.js');
			wp_enqueue_script('lbg-admin-jquery-ui-widget');

			wp_register_script('lbg-admin-jquery-ui-mouse', includes_url().'js/jquery/ui/mouse.min.js');
			wp_enqueue_script('lbg-admin-jquery-ui-mouse');

			wp_register_script('lbg-admin-jquery-ui-draggable', includes_url().'js/jquery/ui/draggable.min.js');
			wp_enqueue_script('lbg-admin-jquery-ui-draggable');

			wp_register_script('lbg-admin-colorpicker', plugins_url('js/colorpicker/colorpicker.js', __FILE__));
			wp_enqueue_script('lbg-admin-colorpicker');

			wp_register_script('lbg-admin-toggle', plugins_url('js/myToggle.js', __FILE__));
			wp_enqueue_script('lbg-admin-toggle');


			wp_enqueue_script('media-upload'); // before w.p 3.5
			wp_enqueue_media();// from w.p 3.5
			wp_enqueue_script('thickbox');


		//}

		//wp_enqueue_script('jquery');
		//wp_enqueue_script('jquery-ui-core');
		//wp_enqueue_script('jquery-ui-sortable');
		//wp_enqueue_script('thickbox');
		//wp_enqueue_script('media-upload');
		//wp_enqueue_script('farbtastic');
	} else if (!is_admin()) { //loads scripts in front-end
			/*wp_deregister_script('jquery-ui-core');
			wp_deregister_script('jquery-ui-widget');
			wp_deregister_script('jquery-ui-mouse');
			wp_deregister_script('jquery-ui-accordion');
			wp_deregister_script('jquery-ui-autocomplete');
			wp_deregister_script('jquery-ui-slider');
			wp_deregister_script('jquery-ui-tabs');
			wp_deregister_script('jquery-ui-sortable');
			wp_deregister_script('jquery-ui-draggable');
			wp_deregister_script('jquery-ui-droppable');
			wp_deregister_script('jquery-ui-selectable');
			wp_deregister_script('jquery-ui-position');
			wp_deregister_script('jquery-ui-datepicker');
			wp_deregister_script('jquery-ui-resizable');
			wp_deregister_script('jquery-ui-dialog');
			wp_deregister_script('jquery-ui-button');	*/

		wp_enqueue_script('jquery');

		//wp_enqueue_script('jquery-ui-core');

		//wp_register_script('lbg-jquery-ui-min', plugins_url('thumbnailsBanner/js/jquery-ui-1.8.16.custom.min.js', __FILE__));
		//wp_register_script('lbg-jquery-ui-min', 'https://ajax.googleapis.com/ajax/libs/jqueryui/1.8.23/jquery-ui.min.js');
		/*wp_register_script('lbg-jquery-ui-min', 'https://ajax.googleapis.com/ajax/libs/jqueryui/1.9.2/jquery-ui.min.js');
		wp_enqueue_script('lbg-jquery-ui-min');*/
			wp_enqueue_script('jquery-ui-core');
			/*wp_enqueue_script('jquery-ui-widget');
			wp_enqueue_script('jquery-ui-mouse');
			wp_enqueue_script('jquery-ui-accordion');
			wp_enqueue_script('jquery-ui-autocomplete');*/
			wp_enqueue_script('jquery-ui-slider');
			/*wp_enqueue_script('jquery-ui-tabs');
			wp_enqueue_script('jquery-ui-sortable');
			wp_enqueue_script('jquery-ui-draggable');
			wp_enqueue_script('jquery-ui-droppable');
			wp_enqueue_script('jquery-ui-selectable');
			wp_enqueue_script('jquery-ui-position');
			wp_enqueue_script('jquery-ui-datepicker');
			wp_enqueue_script('jquery-ui-resizable');
			wp_enqueue_script('jquery-ui-dialog');
			wp_enqueue_script('jquery-ui-button');

			wp_enqueue_script('jquery-form');
			wp_enqueue_script('jquery-color');
			wp_enqueue_script('jquery-masonry');
			wp_enqueue_script('jquery-ui-progressbar');
			wp_enqueue_script('jquery-ui-tooltip');*/

			/*wp_enqueue_script('jquery-effects-core');
			wp_enqueue_script('jquery-effects-blind');
			wp_enqueue_script('jquery-effects-bounce');
			wp_enqueue_script('jquery-effects-clip');
			wp_enqueue_script('jquery-effects-drop');
			wp_enqueue_script('jquery-effects-explode');
			wp_enqueue_script('jquery-effects-fade');
			wp_enqueue_script('jquery-effects-fold');
			wp_enqueue_script('jquery-effects-highlight');
			wp_enqueue_script('jquery-effects-pulsate');
			wp_enqueue_script('jquery-effects-scale');
			wp_enqueue_script('jquery-effects-shake');
			wp_enqueue_script('jquery-effects-slide');*/
			wp_enqueue_script('jquery-effects-transfer');

		wp_register_script('lbg-touchSwipe', plugins_url('thumbnailsBanner/js/jquery.touchSwipe.min.js', __FILE__));
		wp_enqueue_script('lbg-touchSwipe');

		wp_register_script('lbg-all_in_one_thumbnailsBanner', plugins_url('thumbnailsBanner/js/allinone_thumbnailsBanner.js', __FILE__));
		wp_enqueue_script('lbg-all_in_one_thumbnailsBanner');

		wp_register_script('lbg-reflection', plugins_url('thumbnailsBanner/js/reflection.js', __FILE__));
		wp_enqueue_script('lbg-reflection');

		/*if ($is_IE) {
			wp_register_script('lbg-excanvas', plugins_url('thumbnailsBanner/js/excanvas.compiled.js', __FILE__));
			wp_enqueue_script('lbg-excanvas');
		}*/
	}
}



// adds the menu pages
function all_in_one_thumbnailsBanner_plugin_menu() {
	add_menu_page('ALLINONE-THUMBNAILS Admin Interface', 'ALLINONE-THUMBNAILS', 'edit_posts', 'all_in_one_thumbnailsBanner', 'all_in_one_thumbnailsBanner_overview_page',
	plugins_url('images/plg_icon.png', __FILE__));
	add_submenu_page( 'all_in_one_thumbnailsBanner', 'ALLINONE-THUMBNAILS Overview', 'Overview', 'edit_posts', 'all_in_one_thumbnailsBanner', 'all_in_one_thumbnailsBanner_overview_page');
	add_submenu_page( 'all_in_one_thumbnailsBanner', 'ALLINONE-THUMBNAILS Manage Banners', 'Manage Banners', 'edit_posts', 'all_in_one_thumbnailsBanner_Manage_Banners', 'all_in_one_thumbnailsBanner_manage_banners_page');
	add_submenu_page( 'all_in_one_thumbnailsBanner', 'ALLINONE-THUMBNAILS Manage Banners Add New', 'Add New', 'edit_posts', 'all_in_one_thumbnailsBanner_Add_New', 'all_in_one_thumbnailsBanner_manage_banners_add_new_page');
	add_submenu_page( 'ALLINONE-THUMBNAILS Manage Banners', 'ALLINONE-THUMBNAILS Banner Settings', 'Banner Settings', 'edit_posts', 'all_in_one_thumbnailsBanner_Settings', 'all_in_one_thumbnailsBanner_settings_page');
	add_submenu_page( 'ALLINONE-THUMBNAILS Manage Banners', 'ALLINONE-THUMBNAILS Banner Playlist', 'Playlist', 'edit_posts', 'all_in_one_thumbnailsBanner_Playlist', 'all_in_one_thumbnailsBanner_playlist_page');
	add_submenu_page( 'ALLINONE-THUMBNAILS Manage Banners', 'ALLINONE-THUMBNAILS Edit Elements', 'Edit Elements', 'edit_posts', 'all_in_one_thumbnailsBanner_Edit_Elements', 'all_in_one_thumbnailsBanner_editElements_page');
	add_submenu_page( 'all_in_one_thumbnailsBanner', 'ALLINONE-THUMBNAILS Help', 'Help', 'edit_posts', 'all_in_one_thumbnailsBanner_Help', 'all_in_one_thumbnailsBanner_help_page');
}


//HTML content for overview page
function all_in_one_thumbnailsBanner_overview_page()
{
	global $all_in_one_thumbnailsBanner_path;
	include_once($all_in_one_thumbnailsBanner_path . 'tpl/overview.php');
}

//HTML content for Manage Banners
function all_in_one_thumbnailsBanner_manage_banners_page()
{
	global $wpdb;
	global $all_in_one_thumbnailsBanner_messages;
	global $all_in_one_thumbnailsBanner_path;

	//delete banner
	if (isset($_GET['id'])) {




		//delete from wp_all_in_one_thumbnailsBanner_banners
		$wpdb->query($wpdb->prepare("DELETE FROM ".$wpdb->prefix."all_in_one_thumbnailsBanner_banners WHERE id = %d",$_GET['id']));

		//delete from wp_all_in_one_thumbnailsBanner_settings
		$wpdb->query($wpdb->prepare("DELETE FROM ".$wpdb->prefix."all_in_one_thumbnailsBanner_settings WHERE id = %d",$_GET['id']));

		//delete all_in_one_thumbnailsBanner_texts
		$safe_sql=$wpdb->prepare("SELECT id FROM ".$wpdb->prefix."all_in_one_thumbnailsBanner_playlist WHERE bannerid = %d",$_GET['id']);
		$result = $wpdb->get_results($safe_sql,ARRAY_A);
		if ($wpdb->num_rows) {
			foreach ( $result as $row ) {
				$wpdb->query($wpdb->prepare("DELETE FROM ".$wpdb->prefix."all_in_one_thumbnailsBanner_texts WHERE photoid = %d",$row['id']));
			}
		}

		//delete from wp_all_in_one_thumbnailsBanner_playlist
		$wpdb->query($wpdb->prepare("DELETE FROM ".$wpdb->prefix."all_in_one_thumbnailsBanner_playlist WHERE bannerid = %d",$_GET['id']));

		//initialize the session
		$safe_sql="SELECT * FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_banners) ORDER BY id";
		$row = $wpdb->get_row($safe_sql,ARRAY_A);
		$row=all_in_one_thumbnailsBanner_unstrip_array($row);
		if ($row['id']) {
			$_SESSION['xid']=$row['id'];
			$_SESSION['xname']=$row['name'];
		}
	}


	//if ($_GET['duplicate_id']!='') {
	if (array_key_exists('duplicate_id', $_GET) && $_GET['duplicate_id']!='') {
			//banners
			$safe_sql=$wpdb->prepare( "INSERT INTO ".$wpdb->prefix ."all_in_one_thumbnailsBanner_banners ( `name` ) SELECT `name` FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_banners) WHERE id = %d",$_GET['duplicate_id'] );
			$wpdb->query($safe_sql);
			$bannerid=$wpdb->insert_id;

			//settings
			$safe_sql=$wpdb->prepare( "INSERT INTO ".$wpdb->prefix ."all_in_one_thumbnailsBanner_settings (`skin`, `width`, `height`, `width100Proc`, `height100Proc`, `randomizeImages`, `firstImg`, `numberOfStripes`, `numberOfRows`, `numberOfColumns`, `defaultEffect`, `effectDuration`, `autoPlay`, `loop`, `target`, `showAllControllers`, `showNavArrows`, `showOnInitNavArrows`, `autoHideNavArrows`, `showThumbs`, `showOnInitThumbs`, `autoHideThumbs`, `numberOfThumbsPerScreen`, `thumbsReflection`, `enableTouchScreen`, `showCircleTimer`, `showCircleTimerIE8IE7`, `circleRadius`, `circleLineWidth`, `circleColor`, `circleAlpha`, `behindCircleColor`, `behindCircleAlpha`, `responsive`, `responsiveRelativeToBrowser`, `thumbsOnMarginTop`, `thumbsWrapperMarginTop` ) SELECT `skin`, `width`, `height`, `width100Proc`, `height100Proc`, `randomizeImages`, `firstImg`, `numberOfStripes`, `numberOfRows`, `numberOfColumns`, `defaultEffect`, `effectDuration`, `autoPlay`, `loop`, `target`, `showAllControllers`, `showNavArrows`, `showOnInitNavArrows`, `autoHideNavArrows`, `showThumbs`, `showOnInitThumbs`, `autoHideThumbs`, `numberOfThumbsPerScreen`, `thumbsReflection`, `enableTouchScreen`, `showCircleTimer`, `showCircleTimerIE8IE7`, `circleRadius`, `circleLineWidth`, `circleColor`, `circleAlpha`, `behindCircleColor`, `behindCircleAlpha`, `responsive`, `responsiveRelativeToBrowser`, `thumbsOnMarginTop`, `thumbsWrapperMarginTop` FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_settings) WHERE id = %d",$_GET['duplicate_id'] );
			$wpdb->query($safe_sql);

			//playlist
			$safe_sql=$wpdb->prepare( "SELECT * FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_playlist) WHERE bannerid = %d",$_GET['duplicate_id'] );
			$result = $wpdb->get_results($safe_sql,ARRAY_A);
			foreach ( $result as $row_playlist ) {
				$row_playlist=all_in_one_thumbnailsBanner_unstrip_array($row_playlist);

				$safe_sql=$wpdb->prepare( "INSERT INTO ".$wpdb->prefix ."all_in_one_thumbnailsBanner_playlist ( `bannerid`, `img`, `thumbnail`, `alt_text`, `data-transition`, `data-target`, `data-link`, `ord` ) SELECT ".$bannerid." , `img`, `thumbnail`, `alt_text`, `data-transition`, `data-target`, `data-link`,`ord` FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_playlist) WHERE id = %d",$row_playlist['id'] );
				$wpdb->query($safe_sql);
				$photoid=$wpdb->insert_id;
				//echo $wpdb->last_query;

				//layers/texts
				$safe_sql=$wpdb->prepare( "SELECT * FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_texts) WHERE photoid = %d",$row_playlist['id'] );
				$result_texts = $wpdb->get_results($safe_sql,ARRAY_A);
				foreach ( $result_texts as $row_texts ) {
					$row_texts=all_in_one_thumbnailsBanner_unstrip_array($row_texts);

					$safe_sql=$wpdb->prepare( "INSERT INTO ".$wpdb->prefix ."all_in_one_thumbnailsBanner_texts (`photoid`, `img_src`, `content`,  `data-initial-left`, `data-initial-top`, `data-final-left`, `data-final-top`, `data-duration`, `data-fade-start`, `data-delay`, `css`, `ord`) SELECT ".$photoid.", `img_src`, `content`,  `data-initial-left`, `data-initial-top`, `data-final-left`, `data-final-top`, `data-duration`, `data-fade-start`, `data-delay`, `css`, `ord` FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_texts) WHERE id = %d",$row_texts['id'] );
					$wpdb->query($safe_sql);
					//echo $wpdb->last_query;
				}
			}

	}


	$safe_sql="SELECT * FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_banners) ORDER BY id";
	$result = $wpdb->get_results($safe_sql,ARRAY_A);
	include_once($all_in_one_thumbnailsBanner_path . 'tpl/banners.php');

}


//HTML content for Manage Banners - Add New
function all_in_one_thumbnailsBanner_manage_banners_add_new_page()
{
	global $wpdb;
	global $all_in_one_thumbnailsBanner_messages;
	global $all_in_one_thumbnailsBanner_path;

	if(array_key_exists('Submit', $_POST) && $_POST['Submit'] == 'Add New') {
		$errors_arr=array();
		if (empty($_POST['name']))
			$errors_arr[]=$all_in_one_thumbnailsBanner_messages['empty_name'];

		if (count($errors_arr)) {
				include_once($all_in_one_thumbnailsBanner_path . 'tpl/add_banner.php'); ?>
				<div id="error" class="error"><p><?php echo implode("<br>", $errors_arr);?></p></div>
		  	<?php } else { // no errors
					$wpdb->insert(
						$wpdb->prefix . "all_in_one_thumbnailsBanner_banners",
						array(
							'name' => $_POST['name']
						),
						array(
							'%s'
						)
					);
					//insert default Banner Settings for this new banner
					all_in_one_thumbnailsBanner_insert_settings_record($wpdb->insert_id);
					?>
						<div class="wrap">
							<div id="lbg_logo">
								<h2>Manage Banners - Add New Banner</h2>
				 			</div>
							<div id="message" class="updated"><p><?php echo $all_in_one_thumbnailsBanner_messages['data_saved'];?></p><p><?php echo $all_in_one_thumbnailsBanner_messages['generate_for_this_banner'];?></p></div>
							<div>
								<p>&raquo; <a href="?page=all_in_one_thumbnailsBanner_Add_New">Add New (banner)</a></p>
								<p>&raquo; <a href="?page=all_in_one_thumbnailsBanner_Manage_Banners">Back to Manage Banners</a></p>
							</div>
						</div>
		  	<?php }
	} else {
		include_once($all_in_one_thumbnailsBanner_path . 'tpl/add_banner.php');
	}

}


//HTML content for bannersettings
function all_in_one_thumbnailsBanner_settings_page()
{
	global $wpdb;
	global $all_in_one_thumbnailsBanner_messages;
	global $all_in_one_thumbnailsBanner_path;

	if (isset($_GET['id']) && isset($_GET['name'])) {
		$_SESSION['xid']=$_GET['id'];
		$_SESSION['xname']=$_GET['name'];
	}

	//$wpdb->show_errors();
	/*if (check_admin_referer('all_in_one_thumbnailsBanner_settings_update')) {
		echo "update";
	}*/


	if(array_key_exists('Submit', $_POST) && $_POST['Submit'] == 'Update Banner Settings') {
		$_GET['xmlf']='';
		$except_arr=array('Submit','name','pll_ajax_backend','page_scroll_to_id_instances');

			$wpdb->update(
				$wpdb->prefix .'all_in_one_thumbnailsBanner_banners',
				array(
				'name' => $_POST['name']
				),
				array( 'id' => $_SESSION['xid'] )
			);
			$_SESSION['xname']=stripslashes($_POST['name']);


			foreach ($_POST as $key=>$val){
				if (in_array($key,$except_arr)) {
					unset($_POST[$key]);
				}
			}

			$wpdb->update(
				$wpdb->prefix .'all_in_one_thumbnailsBanner_settings',
				$_POST,
				array( 'id' => $_SESSION['xid'] )
			);

			?>
			<div id="message" class="updated"><p><?php echo $all_in_one_thumbnailsBanner_messages['data_saved'];?></p></div>
	<?php

	}

	/*if (array_key_exists('xmlf', $_GET) && $_GET['xmlf']=='bannersettings') {
		all_in_one_thumbnailsBanner_generate_videoSettings();
	}*/

	//echo "WP_PLUGIN_URL: ".WP_PLUGIN_URL;
	$safe_sql=$wpdb->prepare( "SELECT * FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_settings) WHERE id = %d",$_SESSION['xid'] );
	$row = $wpdb->get_row($safe_sql,ARRAY_A);
	$row=all_in_one_thumbnailsBanner_unstrip_array($row);
	$_POST = $row;
	//$_POST['existingWatermarkPath']=$_POST['watermarkPath'];
	$_POST=all_in_one_thumbnailsBanner_unstrip_array($_POST);

	//echo "width: ".$row['width'];
	include_once($all_in_one_thumbnailsBanner_path . 'tpl/settings_form.php');

}

function all_in_one_thumbnailsBanner_playlist_page()
{
	global $wpdb;
	global $all_in_one_thumbnailsBanner_messages;
	global $all_in_one_thumbnailsBanner_path;
	//$wpdb->show_errors();

	if (isset($_GET['id']) && isset($_GET['name'])) {
		$_SESSION['xid']=$_GET['id'];
		$_SESSION['xname']=$_GET['name'];
	}


	if (array_key_exists('xmlf', $_GET) && $_GET['xmlf']=='add_playlist_record') {
		if(array_key_exists('Submit', $_POST) && $_POST['Submit'] == 'Add Record') {
			$errors_arr=array();
			if (empty($_POST['img']))
				 $errors_arr[]=$all_in_one_thumbnailsBanner_messages['empty_img'];


		if (count($errors_arr)) {
			include_once($all_in_one_thumbnailsBanner_path . 'tpl/add_playlist_record.php'); ?>
			<div id="error" class="error"><p><?php echo implode("<br>", $errors_arr);?></p></div>
	  	<?php } else { // no upload errors
				$max_ord = 1+$wpdb->get_var( $wpdb->prepare( "SELECT max(ord) FROM ". $wpdb->prefix ."all_in_one_thumbnailsBanner_playlist WHERE bannerid = %d",$_SESSION['xid'] ) );

				$wpdb->insert(
					$wpdb->prefix . "all_in_one_thumbnailsBanner_playlist",
					array(
						'bannerid' => $_POST['bannerid'],
						'img' => $_POST['img'],
						'thumbnail' => $_POST['thumbnail'],
						'alt_text' => $_POST['alt_text'],
						'data-transition' => $_POST['data-transition'],
						'data-link' => $_POST['data-link'],
						'data-target' => $_POST['data-target'],
						'ord' => $max_ord
					),
					array(
						'%d',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%s',
						'%d'
					)
				);

	  			if (isset($_POST['setitfirst'])) {
					$sql_arr=array();
					$ord_start=$max_ord;
					$ord_stop=1;
					$elem_id=$wpdb->insert_id;
					$ord_direction='+1';

					$sql_arr[]="UPDATE ".$wpdb->prefix."all_in_one_thumbnailsBanner_playlist SET ord=ord+1  WHERE bannerid = ".$_SESSION['xid']." and ord>=".$ord_stop." and ord<".$ord_start;
					$sql_arr[]="UPDATE ".$wpdb->prefix."all_in_one_thumbnailsBanner_playlist SET ord=".$ord_stop." WHERE id=".$elem_id;

					//echo "elem_id: ".$elem_id."----ord_start: ".$ord_start."----ord_stop: ".$ord_stop;
					foreach ($sql_arr as $sql)
						$wpdb->query($sql);
				}
				?>
					<div class="wrap">
						<div id="lbg_logo">
							<h2>Playlist for banner: <span style="color:#FF0000; font-weight:bold;"><?php echo $_SESSION['xname']?> - ID #<?php echo $_SESSION['xid']?></span> - Add New</h2>
			 			</div>
						<div id="message" class="updated"><p><?php echo $all_in_one_thumbnailsBanner_messages['data_saved'];?></p></div>
						<div>
							<p>&raquo; <a href="?page=all_in_one_thumbnailsBanner_Playlist&xmlf=add_playlist_record">Add New</a></p>
							<p>&raquo; <a href="?page=all_in_one_thumbnailsBanner_Playlist">Back to Playlist</a></p>
						</div>
					</div>
	  	<?php }
		} else {
			include_once($all_in_one_thumbnailsBanner_path . 'tpl/add_playlist_record.php');
		}

	} else {

		//if ($_GET['duplicate_id']!='') {
		if (array_key_exists('duplicate_id', $_GET) && $_GET['duplicate_id']!='') {
			$max_ord = 1+$wpdb->get_var( $wpdb->prepare( "SELECT max(ord) FROM ". $wpdb->prefix ."all_in_one_thumbnailsBanner_playlist WHERE bannerid = %d",$_SESSION['xid'] ) );
			$safe_sql=$wpdb->prepare( "INSERT INTO ".$wpdb->prefix ."all_in_one_thumbnailsBanner_playlist ( `bannerid`, `img`, `thumbnail`, `alt_text`, `data-transition`, `data-target`, `data-link` ,`ord` ) SELECT `bannerid`, `img`, `thumbnail`, `alt_text`, `data-transition`, `data-target`, `data-link`,".$max_ord." FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_playlist) WHERE id = %d",$_GET['duplicate_id'] );
			$wpdb->query($safe_sql);
			$lastID=$wpdb->insert_id;
			//echo $wpdb->last_query;


			$safe_sql=$wpdb->prepare( "SELECT * FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_texts) WHERE photoid = %d",$_GET['duplicate_id'] );
			$result = $wpdb->get_results($safe_sql,ARRAY_A);
			foreach ( $result as $row_playlist ) {
				$row_playlist=all_in_one_thumbnailsBanner_unstrip_array($row_playlist);

				$safe_sql=$wpdb->prepare( "INSERT INTO ".$wpdb->prefix ."all_in_one_thumbnailsBanner_texts (`photoid`, `img_src`, `content`,  `data-initial-left`, `data-initial-top`, `data-final-left`, `data-final-top`, `data-duration`, `data-fade-start`, `data-delay`, `css`, `ord`) SELECT ".$lastID.", `img_src`, `content`,  `data-initial-left`, `data-initial-top`, `data-final-left`, `data-final-top`, `data-duration`, `data-fade-start`, `data-delay`, `css`, `ord` FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_texts) WHERE id = %d",$row_playlist['id'] );
				$wpdb->query($safe_sql);
				//echo $wpdb->last_query;
			}

			echo "<script>location.href='?page=all_in_one_thumbnailsBanner_Playlist&id=".$_SESSION['xid']."&name=".$_SESSION['xname']."'</script>";

		}

		$safe_sql=$wpdb->prepare( "SELECT * FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_playlist) WHERE bannerid = %d ORDER BY ord",$_SESSION['xid'] );
		$result = $wpdb->get_results($safe_sql,ARRAY_A);

		//$_POST=all_in_one_thumbnailsBanner_unstrip_array($_POST);
		include_once($all_in_one_thumbnailsBanner_path . 'tpl/playlist.php');
	}
}

function all_in_one_thumbnailsBanner_editElements_page()
{
	global $wpdb;
	//global $all_in_one_thumbnailsBanner_messages;
	global $general_param;
	global $all_in_one_thumbnailsBanner_path;

	if (isset($_GET['id']) && isset($_GET['name'])) {
		$_SESSION['xid']=$_GET['id'];
		$_SESSION['xname']=$_GET['name'];
	}

	//if (isset($_GET['deletealllayers']) && ($_POST['Submit'] != 'Save All Changes')) {
	if (isset($_GET['deletealllayers']) && !array_key_exists('Submit', $_POST)) {
		$wpdb->query(
		"
		DELETE FROM ".$wpdb->prefix ."all_in_one_thumbnailsBanner_texts
		WHERE photoid = ".$_GET['deletealllayers']."
		"
		);
	}

	$safe_sql=$wpdb->prepare( "SELECT * FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_playlist) WHERE id = %d",$_GET['playlistID'] );
	$row = $wpdb->get_row($safe_sql, ARRAY_A);

	$safe_sql=$wpdb->prepare( "SELECT * FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_texts) WHERE photoid = %d ORDER BY ord",$_GET['playlistID'] );
	$result_text = $wpdb->get_results($safe_sql,ARRAY_A);

	//$wpdb->show_errors();




	//if($_POST['Submit'] == 'Save All Changes' || $_SESSION['duplicate_layer']!=0) {
	if ((array_key_exists('Submit', $_POST) && $_POST['Submit'] == 'Save All Changes') || (array_key_exists('duplicate_layer', $_SESSION) && $_SESSION['duplicate_layer'] !=0)) {
		foreach ( $result_text as $row_text ) {
			$textid=$row_text['id'];
			$wpdb->update(
				$wpdb->prefix .'all_in_one_thumbnailsBanner_texts',
				array(
					'img_src' => $_POST['img_src'.$textid],
					'content' => $_POST['content'.$textid],
					'css' => $_POST['css'.$textid],
					'data-initial-left' => $_POST['data-initial-left'.$textid],
					'data-initial-top' => $_POST['data-initial-top'.$textid],
					'data-final-left' => $_POST['data-final-left'.$textid],
					'data-final-top' => $_POST['data-final-top'.$textid],
					'data-duration' => $_POST['data-duration'.$textid],
					'data-fade-start' => $_POST['data-fade-start'.$textid],
					'data-delay' => $_POST['data-delay'.$textid]
					),
				array( 'id' => $textid ),
				array(
'%s',
'%s',
'%s',
'%d',
'%d',
'%d',
'%d',
'%f',
'%d',
'%f'
	),
				array( '%d' )
			);
		}

			?>
	<?php
	}

	//if ($_SESSION['duplicate_layer']!=0) {
	if (array_key_exists('duplicate_layer', $_SESSION) && $_SESSION['duplicate_layer'] !=0)	{
		$safe_sql=$wpdb->prepare( "SELECT `photoid` , `data-final-left` , `data-final-top` FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_texts) WHERE id = %d", $_SESSION['duplicate_layer']);
		$row_dupl = $wpdb->get_row($safe_sql,ARRAY_A);


		$new_final_left=$row_dupl['data-final-left']+10;
		$new_final_top=$row_dupl['data-final-top']+10;
		$photoid=$row_dupl['photoid'];
		$max_ord=1;

		$wpdb->query($wpdb->prepare("UPDATE ".$wpdb->prefix."all_in_one_thumbnailsBanner_texts SET ord=ord+1 WHERE photoid = %d",$photoid));

		$safe_sql=$wpdb->prepare( "INSERT INTO ".$wpdb->prefix ."all_in_one_thumbnailsBanner_texts (`photoid`, `img_src`, `content`,  `data-initial-left`, `data-initial-top`, `data-final-left`, `data-final-top`, `data-duration`, `data-fade-start`, `data-delay`, `css`, `ord`) SELECT `photoid`, `img_src`, `content`,  `data-initial-left`, `data-initial-top`, ".$new_final_left.", ".$new_final_top.", `data-duration`, `data-fade-start`, `data-delay`, `css`, ".$max_ord." FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_texts) WHERE id = %d",$_SESSION['duplicate_layer'] );
		$wpdb->query($safe_sql);
		$lastID=$wpdb->insert_id;


		/*$safe_sql=$wpdb->prepare( "SELECT `photoid` , `data-final-left` , `data-final-top` FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_texts) WHERE id = %d", $lastID);
		$row_dupl = $wpdb->get_row($safe_sql,ARRAY_A);


		$new_final_left=$row_dupl['data-final-left']+10;
		$new_final_top=$row_dupl['data-final-top']+10;
		$photoid=$row_dupl['photoid'];

		$wpdb->query($wpdb->prepare("UPDATE ".$wpdb->prefix."all_in_one_thumbnailsBanner_texts SET ord=ord+1 WHERE photoid = %d",$photoid));
		$max_ord=1;

		$wpdb->query(
		"UPDATE ".$wpdb->prefix."all_in_one_thumbnailsBanner_texts SET `ord`='".$max_ord."',`data-final-left`='".$new_final_left."',`data-final-top`='".$new_final_top."'  WHERE id = ".$lastID
		);*/

		$_SESSION['duplicate_layer']=0;
	}

	//get latest text parameters
	//get slider settings
	$safe_sql=$wpdb->prepare( "SELECT width,height FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_settings) WHERE id = %d",$_SESSION['xid'] );
	$row_settings = $wpdb->get_row($safe_sql, ARRAY_A);

	$safe_sql=$wpdb->prepare( "SELECT * FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_texts) WHERE photoid = %d ORDER BY ord",$_GET['playlistID'] );
	$result_text = $wpdb->get_results($safe_sql,ARRAY_A);

	$safe_sql=$wpdb->prepare( "SELECT css_styles FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_css_definitions) WHERE id = %d",1);
	$row_css = $wpdb->get_row($safe_sql, ARRAY_A);

	include_once($all_in_one_thumbnailsBanner_path . 'tpl/playlist_elements_over_image.php');

}


function all_in_one_thumbnailsBanner_help_page()
{
	//include_once(plugins_url('tpl/help.php', __FILE__));
	global $all_in_one_thumbnailsBanner_path;
	include_once($all_in_one_thumbnailsBanner_path . 'tpl/help.php');
}



function all_in_one_thumbnailsBanner_generate_preview_code($sliderID) {
	global $wpdb;

	$safe_sql=$wpdb->prepare( "SELECT * FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_settings) WHERE id = %d",$sliderID );
	$row = $wpdb->get_row($safe_sql,ARRAY_A);
	$row=all_in_one_thumbnailsBanner_unstrip_array($row);

	//$path_to_plugin = WP_PLUGIN_URL.'/'.str_replace(basename( __FILE__),"",plugin_basename(__FILE__));

	$safe_sql=$wpdb->prepare( "SELECT * FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_playlist) WHERE bannerid = %d ORDER BY ord",$sliderID );
	$result = $wpdb->get_results($safe_sql,ARRAY_A);
	$playlist_str='';
	$text_str='';
	foreach ( $result as $row_playlist ) {

		$row_playlist=all_in_one_thumbnailsBanner_unstrip_array($row_playlist);

		//get texts
		$safe_sql=$wpdb->prepare( "SELECT * FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_texts) WHERE photoid = %d ORDER BY id",$row_playlist['id'] );
		$result_text = $wpdb->get_results($safe_sql,ARRAY_A);
		if ($wpdb->num_rows) { // i have texts
			$playlist_str.='<li data-transition="'.$row_playlist['data-transition'].'" data-bottom-thumb="'.$row_playlist['thumbnail'].'" data-link="'.$row_playlist['data-link'].'" data-target="'.$row_playlist['data-target'].'" data-text-id="#allinone_thumbnailsBanner_photoText'.$row_playlist['id'].'"><img src="'.$row_playlist['img'].'" alt="'.$row_playlist['alt_text'].'" /></li>';


			$text_str.='<div id="allinone_thumbnailsBanner_photoText'.$row_playlist['id'].'" class="allinone_thumbnailsBanner_texts">';
			foreach ( $result_text as $row_text ) {
				$row_text=all_in_one_thumbnailsBanner_unstrip_array($row_text);
				$zindex_aux=100-$row_text['ord'];
				//echo $row_text['id']."; ";

				$text_str.='<div class="allinone_thumbnailsBanner_text_line '.$row_text['css'].'" style="z-index:'.$zindex_aux.';" data-initial-left="'.$row_text['data-initial-left'].'" data-initial-top="'.$row_text['data-initial-top'].'" data-final-left="'.$row_text['data-final-left'].'" data-final-top="'.$row_text['data-final-top'].'" data-duration="'.$row_text['data-duration'].'" data-fade-start="'.$row_text['data-fade-start'].'" data-delay="'.$row_text['data-delay'].'">'.$row_text['content'].'</div>';
			}
			$text_str.='</div>';
		} else { // no data-text-id, only image
			$playlist_str.='<li data-text-id="" data-transition="'.$row_playlist['data-transition'].'" data-bottom-thumb="'.$row_playlist['thumbnail'].'" data-link="'.$row_playlist['data-link'].'" data-target="'.$row_playlist['data-target'].'"><img src="'.$row_playlist['img'].'" alt="'.$row_playlist['alt_text'].'" /></li>';

		}

	}




	$content='<script>
		jQuery(function() {
			jQuery("#allinone_thumbnailsBanner_'.$row["id"].'").allinone_thumbnailsBanner({
				skin:"'.$row["skin"].'",
				width:'.$row["width"].',
				height:'.$row["height"].',
				width100Proc:'.$row["width100Proc"].',
				height100Proc:false,
				randomizeImages: '.$row["randomizeImages"].',
				firstImg:'.$row["firstImg"].',
				numberOfStripes:'.$row["numberOfStripes"].',
				numberOfRows:'.$row["numberOfRows"].',
				numberOfColumns:'.$row["numberOfColumns"].',
				defaultEffect:"'.$row["defaultEffect"].'",
				effectDuration:'.$row["effectDuration"].',
				autoPlay:'.$row["autoPlay"].',
				loop:'.$row["loop"].',
				target:"'.$row["target"].'",
				showAllControllers:'.$row["showAllControllers"].',
				showNavArrows:'.$row["showNavArrows"].',
				showOnInitNavArrows:'.$row["showOnInitNavArrows"].',
				autoHideNavArrows:'.$row["autoHideNavArrows"].',
				showThumbs:'.$row["showThumbs"].',
				showOnInitThumbs:'.$row["showOnInitThumbs"].',
				autoHideThumbs:'.$row["autoHideThumbs"].',
				numberOfThumbsPerScreen:'.$row["numberOfThumbsPerScreen"].',
				thumbsReflection:'.$row["thumbsReflection"].',
				enableTouchScreen:'.$row["enableTouchScreen"].',
				absUrl:"'.plugins_url('thumbnailsBanner/', __FILE__).'",
				showCircleTimer:'.$row["showCircleTimer"].',
				showCircleTimerIE8IE7:'.$row["showCircleTimerIE8IE7"].',
				circleRadius:'.$row["circleRadius"].',
				circleLineWidth:'.$row["circleLineWidth"].',
				circleColor:"#'.$row["circleColor"].'",
				circleAlpha:'.$row["circleAlpha"].',
				behindCircleColor:"#'.$row["behindCircleColor"].'",
				behindCircleAlpha:'.$row["behindCircleAlpha"].',
				responsive:'.$row["responsive"].',
				responsiveRelativeToBrowser:'.$row["responsiveRelativeToBrowser"].',
				thumbsOnMarginTop:'.$row["thumbsOnMarginTop"].',
				thumbsWrapperMarginTop:'.$row["thumbsWrapperMarginTop"].'
			});
		});
	</script>
            <div id="allinone_thumbnailsBanner_'.$row["id"].'" style="display:none;"><ul class="allinone_thumbnailsBanner_list">'.$playlist_str.'</ul>'.$text_str.'</div>';


	return str_replace("\r\n", '', $content);
}

function all_in_one_thumbnailsBanner_shortcode($atts, $content=null) {
	global $wpdb;

	shortcode_atts( array('settings_id'=>''), $atts);
	if ($atts['settings_id']=='')
		$atts['settings_id']=1;


	return all_in_one_thumbnailsBanner_generate_preview_code($atts['settings_id']);
}






register_activation_hook(__FILE__,"all_in_one_thumbnailsBanner_activate"); //activate plugin and create the database
register_uninstall_hook(__FILE__, 'all_in_one_thumbnailsBanner_uninstall'); // on unistall delete all databases
add_action('init', 'all_in_one_thumbnailsBanner_init_sessions');	// initialize sessions
add_action('init', 'all_in_one_thumbnailsBanner_load_styles');	// loads required styles
add_action('init', 'all_in_one_thumbnailsBanner_load_scripts');			// loads required scripts
add_action('admin_menu', 'all_in_one_thumbnailsBanner_plugin_menu'); // create menus
add_shortcode('all_in_one_thumbnailsBanner', 'all_in_one_thumbnailsBanner_shortcode');				// ALLINONE-THUMBNAILS shortcode









/** OTHER FUNCTIONS **/

//stripslashes for an entire array
function all_in_one_thumbnailsBanner_unstrip_array($array){
	if (is_array($array)) {
		foreach($array as &$val){
			if(is_array($val)){
				$val = unstrip_array($val);
			} else {
				$val = stripslashes($val);

			}
		}
	}
	return $array;
}



function all_in_one_thumbnailsBanner_getCssStyles($currentCssClass,$id,$div_data){
	global $wpdb;

	$safe_sql="SELECT * FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_css_definitions) LIMIT 0, 1";
	$row = $wpdb->get_row($safe_sql,ARRAY_A);
	$temp_class='';
	$classes_arr=array();
	$startPos=0;
	$endPos=0;
	$endClassContentPos=0;
	//echo $row['css_styles'];


	$startPos=strpos($row['css_styles'],'.',$startPos);
	$endPos=strpos($row['css_styles'],'{',$startPos);
	while ($startPos!==FALSE) {
		$temp_class=trim(substr($row['css_styles'],$startPos+1,$endPos-1-$startPos));
		//$classes_arr[]=trim(substr($row['css_styles'],$startPos+1,$endPos-1-$startPos));
		if (strpos($temp_class,' a')===FALSE)
			$classes_arr[]=$temp_class;
		$endClassContentPos=strpos($row['css_styles'],'}',$endPos);
		$startPos=strpos($row['css_styles'],'.',$endClassContentPos);
		$endPos=strpos($row['css_styles'],'{',$startPos);
	}
	//print_r($classes_arr);

	//echo $startPos.'  ---  '.$endPos ;

	$div_data_end="";
	if ($div_data!='')
		$div_data_end="';";

	?>
    <?php echo $div_data;?><select name="css<?php echo $id;?>" id="css<?php echo $id;?>"  onchange="change_text_div_css_class(<?php echo $id;?>,this)"><?php echo $div_data_end;?>
    <?php
		foreach ($classes_arr as $class_elem) {
	?>
              <?php echo $div_data;?><option value="<?php echo $class_elem;?>" <?php echo (($class_elem==$currentCssClass)?'selected="selected"':'')?>><?php echo $class_elem;?></option><?php echo $div_data_end;?>
    <?php
		}
	?>
            <?php echo $div_data;?></select><?php echo $div_data_end;?>
<?php }







/* ajax update playlist record */

add_action('admin_head', 'all_in_one_thumbnailsBanner_update_playlist_record_javascript');

function all_in_one_thumbnailsBanner_update_playlist_record_javascript() {
	global $wpdb;
	global $general_param;
	//Set Your Nonce
	$all_in_one_thumbnailsBanner_update_playlist_record_ajax_nonce = wp_create_nonce("all_in_one_thumbnailsBanner_update_playlist_record-special-string");
	$all_in_one_thumbnailsBanner_add_text_record_ajax_nonce = wp_create_nonce("all_in_one_thumbnailsBanner_add_text_record-special-string");
	$all_in_one_thumbnailsBanner_delete_text_record_ajax_nonce = wp_create_nonce("all_in_one_thumbnailsBanner_delete_text_record-special-string");
	$all_in_one_thumbnailsBanner_edit_css_classes_record_ajax_nonce = wp_create_nonce("all_in_one_thumbnailsBanner_edit_css_classes_record-special-string");
	$all_in_one_thumbnailsBanner_preview_record_ajax_nonce = wp_create_nonce("all_in_one_thumbnailsBanner_preview_record-special-string");
	$all_in_one_thumbnailsBanner_duplicate_record_ajax_nonce = wp_create_nonce("all_in_one_thumbnailsBanner_duplicate_record-special-string");

	if(strpos($_SERVER['PHP_SELF'], 'wp-admin') !== false) {
			$page = (isset($_GET['page'])) ? $_GET['page'] : '';
			if(preg_match('/all_in_one_thumbnailsBanner/i', $page)) {

?>




<script type="text/javascript" >
//delete the entire record
function all_in_one_thumbnailsBanner_delete_entire_record (delete_id) {
		if (confirm('Are you sure?')) {
				jQuery("#all_in_one_thumbnailsBanner_sortable").sortable('disable');
				jQuery("#"+delete_id).css("display","none");
				//jQuery("#all_in_one_thumbnailsBanner_sortable").sortable('refresh');
				jQuery("#all_in_one_thumbnailsBanner_updating_witness").css("display","block");
				var data = "action=all_in_one_thumbnailsBanner_update_playlist_record&security=<?php echo $all_in_one_thumbnailsBanner_update_playlist_record_ajax_nonce; ?>&updateType=all_in_one_thumbnailsBanner_delete_entire_record&delete_id="+delete_id;
				// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
				jQuery.post(ajaxurl, data, function(response) {
					jQuery("#all_in_one_thumbnailsBanner_sortable").sortable('enable');
					jQuery("#all_in_one_thumbnailsBanner_updating_witness").css("display","none");
					//alert('Got this from the server: ' + response);
				});
		}
}


function all_in_one_thumbnailsBanner_add_text_line_CONTENT(textID,maxORD,photoid,img_src) {

		newZindex=100-maxORD;

		if (img_src=='') {
			content_aux='TEXT HERE '+(jQuery('#all_in_one_thumbnailsBanner_layers_sortable').children().size()+1);
			content_title='HTML Content';
			image_path='';
			draggable_aux=content_aux;
			css_aux="all_in_one_thumbnailsBanner_textWhiteBgBlack_medium";
			img_src_hidden="hidden";
			changeImgBtn_css="none";
		} else {
			content_aux='IMAGE '+(jQuery('#all_in_one_thumbnailsBanner_layers_sortable').children().size()+1);
			content_title='Image Title';
			image_path='Image Path';
			draggable_aux='<img src="'+img_src+'">';
			css_aux="all_in_one_thumbnailsBanner_textWhiteBgTransparent_small";
			img_src_hidden="text";
			changeImgBtn_css="block";
		}

		//jQuery("#lbg_fullscreen_fullwidth_sliderTable"+textID).css('display','none');
		jQuery("#no_layers").css('display','none');
		jQuery("#photo_div"+photoid).append('<div id="draggable'+textID+'" rel="'+textID+'" class="my_draggable '+css_aux+'" style="left:0px;top:0px;z-index:'+newZindex+';" onclick="activate_layer('+textID+');">'+draggable_aux+'</div>');

		jQuery("#all_in_one_thumbnailsBanner_layers_sortable").prepend('<li class="ui-state-default cursor_move" id="'+textID+'" data-photoid="'+photoid+'" onclick="activate_layer('+textID+');"><div id="li_div'+textID+'">'+content_aux+'</div> <input name="ord_input_'+textID+'" type="text" disabled="disabled" id="ord_input_'+textID+'" style="float:right; margin-top:-20px;" value="'+maxORD+'" size="3" readonly="readonly" /></li>');
		activate_layers_order_li(textID);

		//activate delete layer button
		jQuery('input[name=currentTextID]').val(textID);
		jQuery('#deletelayer').removeAttr("disabled");
		jQuery('#duplicatelayer').removeAttr("disabled");

		jQuery("#draggable"+textID).draggable( {
			drag: function(event, ui) {
				jQuery("#data-final-left"+textID).val(all_in_one_thumbnailsBanner_process_val(jQuery(this).css('left'),'left'));
				jQuery("#data-final-top"+textID).val(all_in_one_thumbnailsBanner_process_val(jQuery(this).css('top'),'top'));
			}
		});

		jQuery("[id^='lbg_fullscreen_fullwidth_sliderTable']").css({
			'display':'none'
		});


		jQuery('[id^="draggable"]').removeClass("my_draggable_activated");
		jQuery("#draggable"+textID).addClass("my_draggable_activated");


		var div_data='<div id="lbg_fullscreen_fullwidth_sliderTable'+textID+'">';
		//div_data+='<input name="img_src'+textID+'" id="img_src'+textID+'" type="hidden" value="'+img_src+'" />';
		div_data+='<table width="100%" cellspacing="0" class="widefat">';
		div_data+='<tr>';
		div_data+='<td width="15%" align="left" valign="middle" class="row-title">'+content_title+'</td>';
		div_data+='<td colspan="3" align="left" valign="middle"><textarea name="content'+textID+'" cols="80" rows="5" id="content'+textID+'" onkeyup="change_text_div_content('+textID+',this);">'+content_aux+'</textarea></td>';
		div_data+='</tr>';
		div_data+='<tr>';
		div_data+='<td align="left" valign="middle" class="row-title">'+image_path+'</td>';
		div_data+='<td colspan="3" align="left" valign="middle"><input name="img_src'+textID+'" id="img_src'+textID+'" value="'+img_src+'" size="60" type="'+img_src_hidden+'" /> <input name="changeImage'+textID+'" id="changeImage'+textID+'" type="button" class="button-primary" value="Change Image" style="float:right; display:'+changeImgBtn_css+';" onClick="change_layer_image()"></td>';
		div_data+='</tr>';
		div_data+='<tr>';
		div_data+='<td align="left" valign="middle" class="row-title">CSS Style</td>';
		div_data+='<td colspan="3" align="left" valign="middle"><div id="lbg_fullscreen_fullwidth_sliderCSS_div'+textID+'">';
		<?php all_in_one_thumbnailsBanner_getCssStyles('all_in_one_thumbnailsBanner_textWhiteBgBlack_medium','unique_xyz','div_data+=\'');?>
		div_data+='</div> <input name="EditCssClasses'+textID+'" id="EditCssClasses'+textID+'" type="button" class="button-primary" value="Edit CSS Clases" style="float:right; margin-top:-25px;" onclick="all_in_one_thumbnailsBanner_edit_css_classes(\'open\',\'\',\'\')"></td>';
		div_data+='</tr>';
		div_data+='<tr>';
		div_data+='<td align="left" valign="middle">&nbsp;</td>';
		div_data+='<td width="35%" align="left" valign="middle">&nbsp;</td>';
		div_data+='<td width="15%" align="left" valign="middle">&nbsp;</td>';
		div_data+='<td width="35%" align="left" valign="middle">&nbsp;</td>';
		div_data+='</tr>';
		div_data+='<tr>';
		div_data+='<td colspan="4" align="left" valign="middle" class="lbg_regGrayWithBg">Enter Values</td>';
		div_data+='</tr>';
		div_data+='<tr>';
		div_data+='<td align="left" valign="middle" class="row-title">Initial Left</td>';
		div_data+='<td align="left" valign="middle"><input name="data-initial-left'+textID+'" type="text" id="data-initial-left'+textID+'" size="10" value="0" /> px</td>';
		div_data+='<td align="left" valign="middle" class="row-title">Inital Top</td>';
		div_data+='<td align="left" valign="middle"><input name="data-initial-top'+textID+'" type="text" id="data-initial-top'+textID+'" size="10" value="0" /> px</td>';
		div_data+='</tr>';
		div_data+='<tr>';
		div_data+='<td align="left" valign="middle" class="row-title">Final Left</td>';
		div_data+='<td align="left" valign="middle"><input name="data-final-left'+textID+'" type="text" id="data-final-left'+textID+'" size="10" value="0" /> px</td>';
		div_data+='<td align="left" valign="middle" class="row-title">Final Top</td>';
		div_data+='<td align="left" valign="middle"><input name="data-final-top'+textID+'" type="text" id="data-final-top'+textID+'" size="10" value="0" /> px</td>';
		div_data+='</tr>';
		div_data+='<tr>';
		div_data+='<td align="left" valign="middle" class="row-title">Duration</td>';
		div_data+='<td align="left" valign="middle"><input name="data-duration'+textID+'" type="text" id="data-duration'+textID+'" size="10" value="0" /> seconds</td>';
		div_data+='<td align="left" valign="middle" class="row-title">Delay</td>';
		div_data+='<td align="left" valign="middle"><input name="data-delay'+textID+'" type="text" id="data-delay'+textID+'" size="10" value="0" /> seconds</td>';
		div_data+='</tr>';
		div_data+='<tr>';
		div_data+='<td align="left" valign="middle" class="row-title">Initial Fade</td>';
		div_data+='<td align="left" valign="middle"><input name="data-fade-start'+textID+'" type="text" id="data-fade-start'+textID+'" size="10" value="0" /> (0-100)</td>';
		div_data+='</table>';
		div_data+='</div>';

		jQuery("#all_texts_settings").append(div_data.replace(/unique_xyz/g,textID));

		jQuery("#css"+textID).val(css_aux);


		var lis = jQuery('#all_in_one_thumbnailsBanner_layers_sortable').children();

		var i=0;
		lis.each(function() {
			i++;
		   currentLi = jQuery(this);
		   //new order
		   jQuery('input[name=ord_input_'+currentLi.attr('id')+']').val(i);

		   //new z-index
			jQuery('#draggable'+currentLi.attr('id')).css({
				'zIndex':100-i
			});
			//alert (currentLi.attr('id')+'  ---  '+jQuery('#draggable'+currentLi.attr('id')).css('zIndex'));
		});
}


function all_in_one_thumbnailsBanner_add_text_line(photoid,img_src) {
	var data ="action=all_in_one_thumbnailsBanner_add_text_record&security=<?php echo $all_in_one_thumbnailsBanner_add_text_record_ajax_nonce; ?>&photoid="+photoid+"&img_src="+img_src;

	// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
	jQuery.post(ajaxurl, data, function(response) {
		//alert('Got this from the server: ' + response);

		//var randNo=Math.floor(Math.random()*10000);
		//var textID=response;
		response_arr=response.split("####");
		//var textID=parseInt(response,10);
		textID=response_arr[0];
		maxORD=response_arr[1];

		all_in_one_thumbnailsBanner_add_text_line_CONTENT(textID,maxORD,photoid,img_src);

	});


}


function all_in_one_thumbnailsBanner_delete_text_line(textid) {
	var data ="action=all_in_one_thumbnailsBanner_delete_text_record&security=<?php echo $all_in_one_thumbnailsBanner_delete_text_record_ajax_nonce; ?>&textid="+textid;

	// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
	jQuery.post(ajaxurl, data, function(response) {
		//alert ("ok");
			var deleted_ord=response;

			jQuery('#'+textid).remove();
			var lis = jQuery('#all_in_one_thumbnailsBanner_layers_sortable').children();
			lis.each(function() {
			   currentLi = jQuery(this);
			   old_ord=jQuery('input[name=ord_input_'+currentLi.attr('id')+']').val();
			   if (parseInt(old_ord,10)>parseInt(deleted_ord,10)) {
			   		jQuery('input[name=ord_input_'+currentLi.attr('id')+']').val(old_ord-1);
			   }
			});


			jQuery('#draggable'+textid).remove();

			jQuery('[id^="lbg_fullscreen_fullwidth_sliderTable"]').css({
					'display':'none'
			});

			//disable delete button
			jQuery('#deletelayer').attr("disabled", "disabled");
			jQuery('#duplicatelayer').attr("disabled", "disabled");

			/*jQuery('#text_line_settings'+textid).remove();
			jQuery('#draggable'+textid).draggable( "destroy" );
			jQuery('#draggable'+textid).remove();*/
	});
}



function change_text_div_css_class(theID,sel) {
	//alert (sel.options[sel.selectedIndex].value);
	//alert (jQuery("#draggable"+theID).attr('class'));
	jQuery("#draggable"+theID).removeClass(jQuery("#draggable"+theID).attr('class'));
	/*jQuery("#draggable"+theID).removeAttr('class');
	jQuery("#draggable"+theID).attr('class', '');	*/

	jQuery("#draggable"+theID).addClass('my_draggable');
	jQuery("#draggable"+theID).addClass(sel.options[sel.selectedIndex].value);
	jQuery("#draggable"+theID).addClass("my_draggable_activated");
}

function change_text_div_content(theID,textareaID) {
	var theTEXT=jQuery(textareaID).val();
	//theTEXT=theTEXT.replace(/(<([^>]+)>)/ig,"");
	theTEXT=theTEXT.replace(/<\/?[^>]+>/gi, '');
	if (jQuery('input[name=img_src'+theID+']').val()=='')
		jQuery('#draggable'+theID).html(theTEXT);
	if (theTEXT.length>50) {
		theTEXT=theTEXT.substring(0,50);
		theTEXT+='...';
	}
	jQuery('#li_div'+theID).html(theTEXT);
}

function change_layer_image() {
	 //formfield = jQuery('#img').attr('name');
	 formfield = 'img_src';
	 tb_show('', 'media-upload.php?type=image&amp;TB_iframe=true');
	 return false;
}

function all_in_one_thumbnailsBanner_process_val(val,cssprop) {
	retVal=parseInt(val.substring(0, val.length-2));
	if (cssprop=="top")
		retVal=retVal-0;
	return retVal;
}

function deactivate_all_layers() {
	jQuery('[id^="draggable"]').removeClass('my_draggable_activated');

	//order div
	activate_layers_order_li(0);

	//disable settings table
	jQuery("[id^='lbg_fullscreen_fullwidth_sliderTable']").css({
		'display':'none'
	});

	//disable delete button
	jQuery('#deletelayer').attr("disabled", "disabled");
	jQuery('#duplicatelayer').attr("disabled", "disabled");
}

function activate_layer(theID) {
		//activate delete layer button
		jQuery('input[name=currentTextID]').val(theID);
		jQuery('#deletelayer').removeAttr("disabled");
		jQuery('#duplicatelayer').removeAttr("disabled");

		jQuery('[id^="lbg_fullscreen_fullwidth_sliderTable"]').css({
			'display':'none'
		});

		jQuery('#lbg_fullscreen_fullwidth_sliderTable'+theID).css({
			'display':'block'
		});

		jQuery('[id^="draggable"]').removeClass("my_draggable_activated");
		jQuery("#draggable"+theID).addClass("my_draggable_activated");

		//order div
		activate_layers_order_li(theID);
}


function activate_layers_order_li(theID) {
	var list = jQuery("#all_in_one_thumbnailsBanner_layers_sortable").children();
	list.each(function() {
		//jQuery(this).addClass('selectedLayer');
		if (jQuery(this).attr('id')==theID)
			jQuery(this).css({'border':'1px solid #000000'});
		else
			jQuery(this).css({'border':'1px solid #dfdfdf'});
	});
}



function all_in_one_thumbnailsBanner_duplicate(action_type,recordID) {
	var data ="action=all_in_one_thumbnailsBanner_duplicate_record&security=<?php echo $all_in_one_thumbnailsBanner_duplicate_record_ajax_nonce; ?>&action_type="+action_type+"&recordID="+recordID;

	// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
	jQuery.post(ajaxurl, data, function(response) {
		//alert ("ok");
		jQuery('#form-elements-lbg_fullscreen_fullwidth_slider').submit();
	});
}



function all_in_one_thumbnailsBanner_edit_css_classes(action_type,theVal,playlistID) {
	//alert (action_type+'   ---   '+theVal);
	if (action_type=='open') {
		jQuery( "#dialogEditCSSClasses" ).dialog( "open" );
	} else {
		var data ="action=all_in_one_thumbnailsBanner_edit_css_classes_record&security=<?php echo $all_in_one_thumbnailsBanner_edit_css_classes_record_ajax_nonce; ?>&action_type="+action_type+"&theVal="+theVal+"&playlistID="+playlistID;

		// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
		jQuery.post(ajaxurl, data, function(response) {
			//alert (response);
			response_arr=response.split("#*#*");
			for(i=0;i<response_arr.length ;i++) {
				//class_and_id_arr=String(response_arr[i]).split("^&^&");
				if (i==0) {
					new_css_select=response_arr[0];
				} else {
					if (i==response_arr.length-1) {
						//alert (response_arr[response_arr.length-1] );
						jQuery('#css_styles_div').html(response_arr[response_arr.length-1]);
						jQuery('textarea#css_classes').val(response_arr[response_arr.length-1]);
					} else {
						//alert (class_and_id_arr[1]+'  ---   '+class_and_id_arr[0]);
						//alert (jQuery("#css"+class_and_id_arr[1]).val());
						orig_css=jQuery("#css"+response_arr[i]).val();
						jQuery('#lbg_fullscreen_fullwidth_sliderCSS_div'+response_arr[i]).html(new_css_select.replace(/unique_xyz/g,response_arr[i]));
						jQuery("#css"+response_arr[i]).val(orig_css);
					}
				}
			}


			jQuery('#editCSSClasses_message').css('display','block');
			jQuery('#editCSSClasses_message').html('CSS classes updated!');

			setTimeout(function(){
					 jQuery('#editCSSClasses_message').css('display','none');
       				 jQuery('#dialogEditCSSClasses').dialog('close');
    			}, 1000);

		});
	}
}


function showDialogPreview(theSliderID) {  //load content and open dialog
	var data ="action=all_in_one_thumbnailsBanner_preview_record&security=<?php echo $all_in_one_thumbnailsBanner_preview_record_ajax_nonce; ?>&theSliderID="+theSliderID;

	// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
	jQuery.post(ajaxurl, data, function(response) {
		//jQuery("#previewDialog").html(response);
		jQuery('#previewDialogIframe').attr('src','<?php echo plugins_url("tpl/preview.html?d=".time(), __FILE__)?>');
		jQuery("#previewDialog").dialog("open");
	});
}


jQuery(document).ready(function($) {
	/*PREVIEW DIALOG BOX*/
	jQuery( "#previewDialog" ).dialog({
	  minWidth:1200,
	  minHeight:500,
	  title:"Plugin Preview",
	  modal: true,
	  autoOpen:false,
	  hide: "fade",
	  resizable: false,
	  open: function() {
		//jQuery( this ).html();
	  },
	  close: function() {
		//jQuery("#previewDialog").html('');
		jQuery('#previewDialogIframe').attr('src','');
	  }
	});


/* THE PLAYLIST */
	if (jQuery('#all_in_one_thumbnailsBanner_sortable').length) {
		jQuery( '#all_in_one_thumbnailsBanner_sortable' ).sortable({
			placeholder: "ui-state-highlight",
			start: function(event, ui) {
	            ord_start = ui.item.prevAll().length + 1;
	        },
			update: function(event, ui) {
	        	jQuery("#all_in_one_thumbnailsBanner_sortable").sortable('disable');
	        	jQuery("#all_in_one_thumbnailsBanner_updating_witness").css("display","block");
				var ord_stop=ui.item.prevAll().length + 1;
				var elem_id=ui.item.attr("id");
				//alert (ui.item.attr("id"));
				//alert (ord_start+' --- '+ord_stop);
				var data = "action=all_in_one_thumbnailsBanner_update_playlist_record&security=<?php echo $all_in_one_thumbnailsBanner_update_playlist_record_ajax_nonce; ?>&updateType=change_ord&ord_start="+ord_start+"&ord_stop="+ord_stop+"&elem_id="+elem_id;
				// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
				jQuery.post(ajaxurl, data, function(response) {
					jQuery("#all_in_one_thumbnailsBanner_sortable").sortable('enable');
					jQuery("#all_in_one_thumbnailsBanner_updating_witness").css("display","none");
					//alert('Got this from the server: ' + response);
				});
			}
		});
	}


	/* THE LAYERS */
		if (jQuery('#all_in_one_thumbnailsBanner_layers_sortable').length) {
			jQuery( '#all_in_one_thumbnailsBanner_layers_sortable' ).sortable({
				placeholder: "ui-state-highlight",
				start: function(event, ui) {
								ord_start = ui.item.prevAll().length + 1;
						},
				update: function(event, ui) {
							jQuery("#all_in_one_thumbnailsBanner_layers_sortable").sortable('disable');
							jQuery("#all_in_one_thumbnailsBanner_updating_witness").css("display","block");
					var ord_stop=ui.item.prevAll().length + 1;
					var elem_id=ui.item.attr("id");
					var photoid=ui.item.attr("data-photoid");
					//alert (elem_id+' --- '+photoid+' --- '+ord_start+' --- '+ord_stop);

					var lis = jQuery('#all_in_one_thumbnailsBanner_layers_sortable').children();
					var i=0;
					lis.each(function() {
						i++;
						 currentLi = jQuery(this);
						 //new order
						 jQuery('input[name=ord_input_'+currentLi.attr('id')+']').val(i);

						 //new z-index
							jQuery('#draggable'+currentLi.attr('id')).css({
							'zIndex':100-i
						});
						//alert (currentLi.attr('id')+'  ---  '+jQuery('#draggable'+currentLi.attr('id')).css('zIndex'));
					});


					var data = "action=all_in_one_thumbnailsBanner_update_playlist_record&security=<?php echo $all_in_one_thumbnailsBanner_update_playlist_record_ajax_nonce; ?>&updateType=change_layers_ord&ord_start="+ord_start+"&ord_stop="+ord_stop+"&photoid="+photoid+"&elem_id="+elem_id;
					// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
					jQuery.post(ajaxurl, data, function(response) {
						jQuery("#all_in_one_thumbnailsBanner_layers_sortable").sortable('enable');
						jQuery("#all_in_one_thumbnailsBanner_updating_witness").css("display","none");
						//alert('Got this from the server: ' + response);
					});
				}
			});
		}




	<?php
		$rows_count = $wpdb->get_var( "SELECT COUNT(*) FROM ". $wpdb->prefix . "all_in_one_thumbnailsBanner_playlist;" );
		for ($i=1;$i<=$rows_count;$i++) {
	?>

				jQuery('#upload_img_button_thumbnailsBanner_<?php echo $i?>').click(function(event) {
						var file_frame;
						event.preventDefault();
						// If the media frame already exists, reopen it.
						if ( file_frame ) {
							file_frame.open();
							return;
						}
						// Create the media frame.
						file_frame = wp.media.frames.file_frame = wp.media({
							title: jQuery( this ).data( 'uploader_title' ),
							button: {
							text: jQuery( this ).data( 'uploader_button_text' ),
							},
							multiple: false // Set to true to allow multiple files to be selected
						});
						// When an image is selected, run a callback.
						file_frame.on( 'select', function() {
							// We set multiple to false so only get one image from the uploader
							attachment = file_frame.state().get('selection').first().toJSON();
							// Do something with attachment.id and/or attachment.url here
							//alert (attachment.url);
							document.forms["form-playlist-all_in_one_thumbnailsBanner-"+<?php echo $i?>].img.value=attachment.url;
							jQuery('#img_'+<?php echo $i?>).attr('src',attachment.url);
						});
						// Finally, open the modal
						file_frame.open();
				});



				jQuery('#upload_thumbnail_button_thumbnailsBanner_<?php echo $i?>').click(function(event) {
						var file_frame;
						event.preventDefault();
						// If the media frame already exists, reopen it.
						if ( file_frame ) {
							file_frame.open();
							return;
						}
						// Create the media frame.
						file_frame = wp.media.frames.file_frame = wp.media({
							title: jQuery( this ).data( 'uploader_title' ),
							button: {
							text: jQuery( this ).data( 'uploader_button_text' ),
							},
							multiple: false // Set to true to allow multiple files to be selected
						});
						// When an image is selected, run a callback.
						file_frame.on( 'select', function() {
							// We set multiple to false so only get one image from the uploader
							attachment = file_frame.state().get('selection').first().toJSON();
							// Do something with attachment.id and/or attachment.url here
							//alert (attachment.url);
							document.forms["form-playlist-all_in_one_thumbnailsBanner-"+<?php echo $i?>].thumbnail.value=attachment.url;
							jQuery('#thumbnail_'+<?php echo $i?>).attr('src',attachment.url);
						});
						// Finally, open the modal
						file_frame.open();
				});







	jQuery("#form-playlist-all_in_one_thumbnailsBanner-<?php echo $i?>").submit(function(event) {

		/* stop form from submitting normally */
		event.preventDefault();

		//show loading image
		jQuery('#ajax-message-<?php echo $i?>').html('<img src="<?php echo plugins_url('all_in_one_thumbnailsBanner/images/ajax-loader.gif', dirname(__FILE__))?>" />');

		//alert (jQuery('#data-initial-left24').val());
		//var data = {
			//action: 'all_in_one_thumbnailsBanner_update_playlist_record',
			//security: '<?php echo $all_in_one_thumbnailsBanner_update_playlist_record_ajax_nonce; ?>',
			//whatever: 1234
		//};
		var data ="action=all_in_one_thumbnailsBanner_update_playlist_record&security=<?php echo $all_in_one_thumbnailsBanner_update_playlist_record_ajax_nonce; ?>&"+jQuery("#form-playlist-all_in_one_thumbnailsBanner-<?php echo $i?>").serialize();

		// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
		jQuery.post(ajaxurl, data, function(response) {
			//alert('Got this from the server: ' + response);
			//alert(jQuery("#form-playlist-all_in_one_thumbnailsBanner-<?php echo $i?>").serialize());
			var new_img = '';
			if (document.forms["form-playlist-all_in_one_thumbnailsBanner-<?php echo $i?>"].img.value!='')
				new_img=document.forms["form-playlist-all_in_one_thumbnailsBanner-<?php echo $i?>"].img.value;
			jQuery('#top_image_'+document.forms["form-playlist-all_in_one_thumbnailsBanner-<?php echo $i?>"].id.value).attr('src',new_img);
			jQuery('#ajax-message-<?php echo $i?>').html(response);
		});
	});
	<?php } ?>

});
</script>
<?php
	$safe_sql="SELECT * FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_css_definitions) LIMIT 0, 1";
	$row = $wpdb->get_row($safe_sql,ARRAY_A);
	echo '<style id="css_styles_div">'.$row['css_styles'].'</style>';
		}
	}
}

//all_in_one_thumbnailsBanner_update_playlist_record is the action=all_in_one_thumbnailsBanner_update_playlist_record

add_action('wp_ajax_all_in_one_thumbnailsBanner_update_playlist_record', 'all_in_one_thumbnailsBanner_update_playlist_record_callback');

function all_in_one_thumbnailsBanner_update_playlist_record_callback() {

	check_ajax_referer( 'all_in_one_thumbnailsBanner_update_playlist_record-special-string', 'security' ); //security=<?php echo $all_in_one_thumbnailsBanner_update_playlist_record_ajax_nonce;
	global $wpdb;
	global $all_in_one_thumbnailsBanner_messages;
	$errors_arr=array();
	//$wpdb->show_errors();

	//delete entire record
	if (array_key_exists('updateType', $_POST) && $_POST['updateType']=='all_in_one_thumbnailsBanner_delete_entire_record') {
		$delete_id=$_POST['delete_id'];
		$safe_sql=$wpdb->prepare("SELECT * FROM ".$wpdb->prefix."all_in_one_thumbnailsBanner_playlist WHERE id = %d",$delete_id);
		$row = $wpdb->get_row($safe_sql, ARRAY_A);
		$row=all_in_one_thumbnailsBanner_unstrip_array($row);

		//delete the entire record
		$wpdb->query($wpdb->prepare("DELETE FROM ".$wpdb->prefix."all_in_one_thumbnailsBanner_playlist WHERE id = %d",$delete_id));
		//delete texts
		$wpdb->query($wpdb->prepare("DELETE FROM ".$wpdb->prefix."all_in_one_thumbnailsBanner_texts WHERE photoid = %d",$delete_id));
		//update the order for the rest ord=ord-1 for > ord
		$wpdb->query($wpdb->prepare("UPDATE ".$wpdb->prefix."all_in_one_thumbnailsBanner_playlist SET ord=ord-1 WHERE bannerid = %d and  ord>".$row['ord'],$_SESSION['xid']));
	}

	//update elements order
	if (array_key_exists('updateType', $_POST) && $_POST['updateType']=='change_ord') {
		$sql_arr=array();
		$ord_start=$_POST['ord_start'];
		$ord_stop=$_POST['ord_stop'];
		$elem_id=(int)$_POST['elem_id'];
		$ord_direction='+1';
		if ($ord_start<$ord_stop)
			$sql_arr[]="UPDATE ".$wpdb->prefix."all_in_one_thumbnailsBanner_playlist SET ord=ord-1  WHERE bannerid = ".$_SESSION['xid']." and ord>".$ord_start." and ord<=".$ord_stop;
		else
			$sql_arr[]="UPDATE ".$wpdb->prefix."all_in_one_thumbnailsBanner_playlist SET ord=ord+1  WHERE bannerid = ".$_SESSION['xid']." and ord>=".$ord_stop." and ord<".$ord_start;
		$sql_arr[]="UPDATE ".$wpdb->prefix."all_in_one_thumbnailsBanner_playlist SET ord=".$ord_stop." WHERE id=".$elem_id;

		//echo "elem_id: ".$elem_id."----ord_start: ".$ord_start."----ord_stop: ".$ord_stop;
		foreach ($sql_arr as $sql)
			$wpdb->query($sql);
	}

	//update layers order
	//if ($_POST['updateType']=='change_layers_ord') {
	if (array_key_exists('updateType', $_POST) && $_POST['updateType']=='change_layers_ord') {
		$sql_arr=array();
		$ord_start=$_POST['ord_start'];
		$ord_stop=$_POST['ord_stop'];
		$elem_id=(int)$_POST['elem_id'];
		$photoid=(int)$_POST['photoid'];
		$ord_direction='+1';
		if ($ord_start<$ord_stop)
			$sql_arr[]="UPDATE ".$wpdb->prefix."all_in_one_thumbnailsBanner_texts SET ord=ord-1  WHERE photoid = ".$photoid." and ord>".$ord_start." and ord<=".$ord_stop;
		else
			$sql_arr[]="UPDATE ".$wpdb->prefix."all_in_one_thumbnailsBanner_texts SET ord=ord+1  WHERE photoid = ".$photoid." and ord>=".$ord_stop." and ord<".$ord_start;
		$sql_arr[]="UPDATE ".$wpdb->prefix."all_in_one_thumbnailsBanner_texts SET ord=".$ord_stop." WHERE id=".$elem_id;

		//echo "elem_id: ".$elem_id."----ord_start: ".$ord_start."----ord_stop: ".$ord_stop;
		foreach ($sql_arr as $sql)
			$wpdb->query($sql);
	}


	//submit update
	if (empty($_POST['img']))
			 $errors_arr[]=$all_in_one_thumbnailsBanner_messages['empty_img'];

	$theid=isset($_POST['id'])?$_POST['id']:0;
	if($theid>0 && !count($errors_arr)) {
		/*$except_arr=array('Submit'.$theid,'id','ord','action','security','updateType','uniqueUploadifyID');
		foreach ($_POST as $key=>$val){
			if (in_array($key,$except_arr)) {
				unset($_POST[$key]);
			}
		}*/
		//update playlist
		$wpdb->update(
			$wpdb->prefix .'all_in_one_thumbnailsBanner_playlist',
				array(
				'img' => $_POST['img'],
				'thumbnail' => $_POST['thumbnail'],
				'alt_text' => $_POST['alt_text'],
				'data-link' => $_POST['data-link'],
				'data-target' => $_POST['data-target'],
				'data-transition' => $_POST['data-transition']
				),
			array( 'id' => $theid )
		);

		//update texts
		/*$safe_sql=$wpdb->prepare( "SELECT * FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_texts) WHERE photoid = %d ORDER BY id",$theid );
		$result_text = $wpdb->get_results($safe_sql,ARRAY_A);

		foreach ( $result_text as $row_text ) {
			$textid=$row_text['id'];
			$wpdb->update(
				$wpdb->prefix .'all_in_one_thumbnailsBanner_texts',
					array(
					'content' => $_POST['content'.$textid],
					'data-initial-left' => $_POST['data-initial-left'.$textid],
					'data-initial-top' => $_POST['data-initial-top'.$textid],
					'data-final-left' => $_POST['data-final-left'.$textid],
					'data-final-top' => $_POST['data-final-top'.$textid],
					'data-duration' => $_POST['data-duration'.$textid],
					'data-fade-start' => $_POST['data-fade-start'.$textid],
					'data-delay' => $_POST['data-delay'.$textid],
					'css' => $_POST['css'.$textid]
					),
				array( 'id' => $textid )
			);
		}*/

		?>
			<div id="message" class="updated"><p><?php echo $all_in_one_thumbnailsBanner_messages['data_saved'];?></p></div>
	<?php
	} else if (!isset($_POST['updateType'])) {
		$errors_arr[]=$all_in_one_thumbnailsBanner_messages['invalid_request'];
	}
    //echo $theid;

	if (count($errors_arr)) { ?>
		<div id="error" class="error"><p><?php echo implode("<br>", $errors_arr);?></p></div>
	<?php }

	die(); // this is required to return a proper result
}




add_action('wp_ajax_all_in_one_thumbnailsBanner_add_text_record', 'all_in_one_thumbnailsBanner_add_text_record_callback');

function all_in_one_thumbnailsBanner_add_text_record_callback() {

	check_ajax_referer( 'all_in_one_thumbnailsBanner_add_text_record-special-string', 'security' );
	global $wpdb;
	//$wpdb->show_errors();

	$wpdb->query($wpdb->prepare("UPDATE ".$wpdb->prefix."all_in_one_thumbnailsBanner_texts SET ord=ord+1 WHERE photoid = %d",$_POST['photoid']));

	//if ($_POST['img_src']=='') {
	if(array_key_exists('img_src', $_POST) && $_POST['img_src'] != '') {
			$css_aux="all_in_one_thumbnailsBanner_textWhiteBgTransparent_small";
	} else {
			$css_aux="all_in_one_thumbnailsBanner_textWhiteBgBlack_medium";
	}

	$new_max_ord = 1+$wpdb->get_var( $wpdb->prepare( "SELECT max(ord) FROM ". $wpdb->prefix ."all_in_one_thumbnailsBanner_texts WHERE photoid = %d",$_POST['photoid'] ) );
	$max_ord=1;
	//if ($_POST['img_src']=='') {
	if(array_key_exists('img_src', $_POST) && $_POST['img_src'] != '') {
		$content_aux='IMAGE '.$new_max_ord;
	} else {
		$content_aux='TEXT HERE '.$new_max_ord;
	}
$wpdb->insert(
			$wpdb->prefix . "all_in_one_thumbnailsBanner_texts",
			array(
				'photoid' => $_POST['photoid'],
				'img_src' => $_POST['img_src'],
				'content' => $content_aux,
				'data-initial-left' => 0,
				'data-initial-top' => 0,
				'data-final-left' => 0,
				'data-final-top' => 0,
				'data-duration' => 0,
				'data-fade-start' => 0,
				'data-delay' => 0,
				'css' => $css_aux,
				'ord' => 1

			),
			array(
'%d',
'%s',
'%s',
'%s',
'%s',
'%d',
'%d',
'%d',
'%d',
'%f',
'%d',
'%f',
'%s',
'%d'
			)
		);

		echo $wpdb->insert_id.'####'.$max_ord;

		die(); // this is required to return a proper result
}




add_action('wp_ajax_all_in_one_thumbnailsBanner_delete_text_record', 'all_in_one_thumbnailsBanner_delete_text_record_callback');

function all_in_one_thumbnailsBanner_delete_text_record_callback() {

	check_ajax_referer( 'all_in_one_thumbnailsBanner_delete_text_record-special-string', 'security' );
	global $wpdb;
	//$wpdb->show_errors();

	$safe_sql=$wpdb->prepare( "SELECT * FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_texts) WHERE id = %d",$_POST['textid'] );
	$row = $wpdb->get_row($safe_sql,ARRAY_A);

	$wpdb->query(
	"
	DELETE FROM ".$wpdb->prefix ."all_in_one_thumbnailsBanner_texts
	WHERE id = ".$_POST['textid']."
	"
	);

	$wpdb->query(
	"UPDATE ".$wpdb->prefix."all_in_one_thumbnailsBanner_texts SET ord=ord-1  WHERE photoid = ".$row['photoid']." and ord>".$row['ord']
	);

	/*$max_ord=$wpdb->get_var( $wpdb->prepare( "SELECT max(ord) FROM ". $wpdb->prefix ."all_in_one_thumbnailsBanner_texts WHERE photoid = %d",$row['photoid'] ) );
	echo $max_ord;*/

	echo $row['ord'];

	die(); // this is required to return a proper result
}


add_action('wp_ajax_all_in_one_thumbnailsBanner_duplicate_record', 'all_in_one_thumbnailsBanner_duplicate_record_callback');

function all_in_one_thumbnailsBanner_duplicate_record_callback() {

	check_ajax_referer( 'all_in_one_thumbnailsBanner_duplicate_record-special-string', 'security' );
	global $wpdb;

	$return_str='';

	if ($_POST['action_type']='duplicate layer') {
		$_SESSION['duplicate_layer'] = $_POST['recordID'];
	}

	//$max_ord = 1+$wpdb->get_var( $wpdb->prepare( "SELECT max(ord) FROM ". $wpdb->prefix ."all_in_one_thumbnailsBanner_texts WHERE photoid = %d",$_POST['photoid'] ) );

	//echo $_POST['action_type'].'   ---  '.$_POST['recordID'];
	//echo $wpdb->last_query;
	echo $return_str;

	die(); // this is required to return a proper result
}



add_action('wp_ajax_all_in_one_thumbnailsBanner_edit_css_classes_record', 'all_in_one_thumbnailsBanner_edit_css_classes_record_callback');

function all_in_one_thumbnailsBanner_edit_css_classes_record_callback() {

	check_ajax_referer( 'all_in_one_thumbnailsBanner_edit_css_classes_record-special-string', 'security' );
	global $wpdb;

	//$wpdb->show_errors();
	if ($_POST['action_type']=='update_css') {
		$wpdb->query(
		"UPDATE ".$wpdb->prefix."all_in_one_thumbnailsBanner_css_definitions SET css_styles='".$_POST['theVal']."'  WHERE id = 1"
		);
	} else {
		$safe_sql=$wpdb->prepare( "SELECT * FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_css_definitions) WHERE id = %d", 1);
		$row_css = $wpdb->get_row($safe_sql,ARRAY_A);
		$wpdb->query(
		"UPDATE ".$wpdb->prefix."all_in_one_thumbnailsBanner_css_definitions SET css_styles='".$row_css['css_styles_orig']."' WHERE id = 1"
		);
	}

	$safe_sql="SELECT * FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_css_definitions) LIMIT 0, 1";
	$row2 = $wpdb->get_row($safe_sql,ARRAY_A);

	if ($_POST['action_type']!='open') {
		$filename=plugin_dir_path(__FILE__) . 'thumbnailsBanner/text_classes.css';
		$fp = fopen($filename, 'w+');
		$fwrite = fwrite($fp, $row2['css_styles']);
	}


	$safe_sql=$wpdb->prepare( "SELECT * FROM (".$wpdb->prefix ."all_in_one_thumbnailsBanner_texts) WHERE photoid = %d ORDER BY ord",$_POST['playlistID'] );
	$result_text2 = $wpdb->get_results($safe_sql,ARRAY_A);

	$return_arr=array();
	$return_str='';
	foreach ( $result_text2 as $row_text2 ) {
		//$return_arr[]=$row_text2['css']."^&^&".$row_text2['id'];
		$return_arr[]=$row_text2['id'];
	}
	$return_str=all_in_one_thumbnailsBanner_getCssStyles('all_in_one_thumbnailsBanner_textWhiteBgBlack_medium','unique_xyz','')."#*#*".implode("#*#*", $return_arr)."#*#*".$row2['css_styles'];
	echo $return_str;
	//echo $fwrite;
	//echo $wpdb->last_query;
	//echo json_encode($return_arr);

	die(); // this is required to return a proper result
}



add_action('wp_ajax_all_in_one_thumbnailsBanner_preview_record', 'all_in_one_thumbnailsBanner_preview_record_callback');

function all_in_one_thumbnailsBanner_preview_record_callback() {
	check_ajax_referer( 'all_in_one_thumbnailsBanner_preview_record-special-string', 'security' );

	//echo all_in_one_thumbnailsBanner_generate_preview_code($_POST['theSliderID']);
	$aux_val='<html>
					<head>
					  <link href="'.plugins_url('css/droid_sans.css', __FILE__).'" rel="stylesheet" type="text/css">
						<link href="'.plugins_url('css/cabin.css', __FILE__).'" rel="stylesheet" type="text/css">
						<link href="'.plugins_url('thumbnailsBanner/allinone_thumbnailsBanner.css', __FILE__).'" rel="stylesheet" type="text/css">
						<link href="'.plugins_url('thumbnailsBanner/text_classes.css', __FILE__).'?'.time().'" rel="stylesheet" type="text/css">

						<script src="'.plugins_url('js/jquery.min.js', __FILE__).'" type="text/javascript"></script>
						<script src="'.plugins_url('js/jquery-ui.min.js', __FILE__).'" type="text/javascript"></script>
						<script src="'.plugins_url('thumbnailsBanner/js/jquery.touchSwipe.min.js', __FILE__).'" type="text/javascript"></script>
						<script src="'.plugins_url('thumbnailsBanner/js/allinone_thumbnailsBanner.js', __FILE__).'" type="text/javascript"></script>
						<script src="'.plugins_url('thumbnailsBanner/js/reflection.js', __FILE__).'" type="text/javascript"></script>

					</head>
					<body style="padding:0px;margin:0px;">';

	$aux_val.=all_in_one_thumbnailsBanner_generate_preview_code($_POST['theSliderID']);
	$aux_val.="</body>
				</html>";
	$filename=plugin_dir_path(__FILE__) . 'tpl/preview.html';
	$fp = fopen($filename, 'w+');
	$fwrite = fwrite($fp, $aux_val);

	echo $fwrite;

	die(); // this is required to return a proper result
}


?>
