<?php
namespace AIOSEO\Plugin\Pro\ImportExport\RankMath;

// phpcs:disable WordPress.Arrays.ArrayDeclarationSpacing.AssociativeArrayFound

/**
 * Migrates the General Settings.
 *
 * @since 4.0.0
 */
class GeneralSettings {

	/**
	 * Class constructor.
	 *
	 * @since 4.0.0
	 */
	public function __construct() {
		$this->options = get_option( 'rank-math-options-general' );
		if ( empty( $this->options ) ) {
			return;
		}

		$this->migrateImageSeoSettings();
	}

	/**
	 * Migrates the image attribute formats.
	 *
	 * @since 4.0.0
	 *
	 * @return void
	 */
	private function migrateImageSeoSettings() {
		if ( isset( $this->options['img_title_format'] ) ) {
			$title = preg_replace( '/%title%/', '#post_seo_title', $this->options['img_title_format'] );
			aioseo()->options->image->format->title =
				aioseo()->helpers->sanitizeOption( aioseo()->importExport->rankMath->helpers->macrosToSmartTags( $title ) );
		}

		if ( isset( $this->options['img_alt_format'] ) ) {
			$alt = preg_replace( '/%title%/', '#post_seo_title', $this->options['img_alt_format'] );
			aioseo()->options->image->format->alt =
				aioseo()->helpers->sanitizeOption( aioseo()->importExport->rankMath->helpers->macrosToSmartTags( $alt ) );
		}
	}
}