Issue #

## Proposed changes

Describe the big picture of your changes here to communicate why the PR should be accepted. If it fixes a bug or resolves a feature request, be sure to link to that issue.

## Types of changes

What types of changes does your code introduce?
_Delete those that don't apply_

- Bugfix (non-breaking change which fixes an issue)
- New feature (non-breaking change which adds functionality)
- Breaking change (fix or feature that would cause existing functionality to not work as expected)
- Adds new API hooks
- Removing old code/functionality
- Improves existing functionality
- Improves existing code

## Checklist

_Put an `x` in the boxes that apply. You can also fill these out after creating the PR. If you're unsure about any of them, don't hesitate to ask. We're here to help! This is simply a reminder of what we are going to look for before merging your code. If creating a separate issue for an item, link to the issue # at the end of the line._

- [ ] I've selected the appropriate branch (ie x.y rather than master).
- [ ] I've created an appropriate title, descriptive of what the PR does.
- [ ] Travis-ci runs with no errors.
- [ ] I have added tests that prove my fix is effective/my feature works or have created an issue for it (if appropriate).
- [ ] I have added necessary documentation, or have created an issue for docs (if appropriate).

## Testing instructions
- Don't assume the tester knows the entire backstory of the issue, and don't force him/her to decipher the code to try and figure out what -it's doing or how to test it.
- Do provide step by step instructions on how to test. 
- Do note things to watch out for.
- Do note what aspects the tester should try and break.

## Further comments

If this is a relatively large or complex change, kick off the discussion by explaining why you chose the solution you did and what alternatives you considered, etc...
