<?php
/**
 * Fields: Username
 *
 * @package     AffiliateWP Affiliate Forms for Gravity Forms
 * @subpackage  Fields
 * @copyright   Copyright (c) 2021, Sandhills Development, LLC
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       1.1
 */
namespace AffiliateWP_AFGF\Fields;

use AffiliateWP_AFGF\Traits\AffiliateWP_Grouped_Field;

/**
 * Implements an (affiliate) username field.
 *
 * @since 1.1
 *
 * @see \GF_Field_Text
 */
class Username_Field extends \GF_Field_Text {

	use AffiliateWP_Grouped_Field;

	/**
	 * Field type.
	 *
	 * @since 1.1
	 * @var   string
	 */
	public $type = 'username';

	/**
	 * Retrieves the form editor field title.
	 *
	 * @since 1.1
	 *
	 * @return string Field title.
	 */
	public function get_form_editor_field_title() {
		return esc_attr__( 'Username', 'affiliatewp-afgf' );
	}

	/**
	 * Retrieves the form editor field description.
	 *
	 * @since 1.1
	 *
	 * @return string Field description.
	 */
	public function get_form_editor_field_description() {
		return esc_attr__( 'Allows affiliates to define a username during registration.', 'affiliatewp-afgf' );
	}

	/**
	 * Retrieves the field's form editor icon.
	 *
	 * @since 1.1
	 *
	 * @return string Icon class name.
	 */
	public function get_form_editor_field_icon() {
		return 'gform-icon--how-to-reg';
	}

}
