<?php
/**
 * Fields
 *
 * @since 1.0
 */

if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Configures field settings in the form editor.
 *
 * @since 1.0
 * @since 1.1 Refactored to shift field settings to the new Fields class.
 */
function affwp_afgf_gform_editor_js() {
	?>
	<script type='text/javascript'>

		jQuery( document ).ready( function( $ ) {

			// Standard field settings.
			fieldSettings["text"]              += ", .affwp_email_tag_setting";
			fieldSettings["textarea"]          += ", .affwp_email_tag_setting";
			fieldSettings["phone"]             += ", .affwp_email_tag_setting";
			fieldSettings["number"]            += ", .affwp_email_tag_setting";
			fieldSettings["date"]              += ", .affwp_email_tag_setting";
			fieldSettings["time"]              += ", .affwp_email_tag_setting";
			fieldSettings["select"]            += ", .affwp_email_tag_setting";
			fieldSettings["multiselect"]       += ", .affwp_email_tag_setting";
			fieldSettings["checkbox"]          += ", .affwp_email_tag_setting";
			fieldSettings["radio"]             += ", .affwp_email_tag_setting";
			fieldSettings["address"]           += ", .affwp_email_tag_setting";
			fieldSettings["list"]              += ", .affwp_email_tag_setting";
			fieldSettings["fileupload"]        += ", .affwp_email_tag_setting";

			// Post field settings.
			fieldSettings["post_title"]        += ", .affwp_email_tag_setting";
			fieldSettings["post_content"]      += ", .affwp_email_tag_setting";
			fieldSettings["post_excerpt"]      += ", .affwp_email_tag_setting";
			fieldSettings["post_tags"]         += ", .affwp_email_tag_setting";
			fieldSettings["post_category"]     += ", .affwp_email_tag_setting";
			fieldSettings["post_image"]        += ", .affwp_email_tag_setting";
			fieldSettings["post_custom_field"] += ", .affwp_email_tag_setting";

			// Product field settings.
			fieldSettings["product"]           += ", .affwp_email_tag_setting";
			fieldSettings["singleproduct"]     += ", .affwp_email_tag_setting";
			fieldSettings["price"]             += ", .affwp_email_tag_setting";
			fieldSettings["shipping"]          += ", .affwp_email_tag_setting";
			fieldSettings["singleshipping"]    += ", .affwp_email_tag_setting";
			fieldSettings["option"]            += ", .affwp_email_tag_setting";
			fieldSettings["quantity"]          += ", .affwp_email_tag_setting";
			fieldSettings["donation"]          += ", .affwp_email_tag_setting";
			fieldSettings["total"]             += ", .affwp_email_tag_setting";

			// Handle the checked state for fields with the email tag setting enabled.
			$( document ).bind( 'gform_load_field_settings', function( event, field, form ) {

				jQuery("#affwp_email_tag").attr("checked", true == field["affwp_email_tag"]);

			} );

		} );

	</script>
	<?php
}
add_action( "gform_editor_js", "affwp_afgf_gform_editor_js" );


/**
 * Field validation
 *
 * @since 1.0
 */
function affwp_afgf_gform_field_validation( $result, $value, $form, $field ) {

	$form_id = affwp_afgf_get_registration_form_id();

	// only validate affiliate registration form
	if ( $form['id'] !== $form_id ) {
		return $result;
	}

	// email field is always required
	if ( 'email' === $field['type'] ) {

		if ( is_user_logged_in() ) {

			// Skip validation by setting it to true when user is logged in. This field is only required when the user is logged out
			$result['is_valid'] = true;

		} else {
			// user is not already logged in
			if ( rgblank( $value ) ) {
				$result['is_valid'] = false;
				$result['message'] = empty( $result['errorMessage'] ) ? __( 'You must enter an email address.', 'gravityforms' ): $result['errorMessage'];
			}

			if ( ! rgblank( $value ) ) {
				// email already in use

				if ( $field['emailConfirmEnabled'] ) {
					// email confirmation so check first value of array
					if ( email_exists( $value[0] ) ) {
						$result['is_valid'] = false;
						$result['message'] = empty( $result['errorMessage'] ) ? __( 'This email address is already in use.', 'gravityforms' ): $result['errorMessage'];
					}
				} else {
					if ( email_exists( $value ) ) {
						$result['is_valid'] = false;
						$result['message'] = empty( $result['errorMessage'] ) ? __( 'This email address is already in use.', 'gravityforms' ): $result['errorMessage'];
					}
				}


			}

		}

	}

	// password field
	if ( 'password' === $field['type'] ) {

		// Skip validation by setting it to true when user is logged in. This field is only required when the user is logged out
		if ( is_user_logged_in() ) {
			$result['is_valid'] = true;
		}
	}

	// valid payment email as an email fields
	if ( 'payment_email' === $field['type'] ) {

		if ( ! rgblank( $value ) && ! GFCommon::is_valid_email( $value ) ) {
			$result['is_valid'] = false;
			$result['message'] = empty( $result['errorMessage'] ) ? __( 'Please enter a valid email address.', 'gravityforms' ): $result['errorMessage'];
		}

	}

	// username
	if ( 'username' === $field['type'] ) {

		if ( is_user_logged_in() ) {
			// Skip validation by setting it to true when user is logged in. This field is only required when the user is logged out
			$result['is_valid'] = true;

		} elseif ( username_exists( $value ) ) {
			$result['is_valid'] = false;
			$result['message'] = empty( $result['errorMessage'] ) ? __( 'This username is already in use.', 'gravityforms' ): $result['errorMessage'];
		}

	}

	return $result;
}
add_filter( 'gform_field_validation', 'affwp_afgf_gform_field_validation', 10, 4 );

/**
 * Output a message just inside the form tag if the form does not contain an email field
 *
 * @since 1.0
 */
function affwp_afgf_gform_form_tag( $form ) {

	if ( ! affwp_afgf_get_field_id( 'email' ) ) {
		$missing_email = '<div class="validation_error">' . __( 'This form must have an email field.', 'gravityforms' ) . '</div>';

		return $form . $missing_email;
	}

	return $form;

}
add_filter( 'gform_form_tag_' . affwp_afgf_get_registration_form_id() , 'affwp_afgf_gform_form_tag', 10, 1 );

/**
 * Field validation
 *
 * @since 1.0
 */
function affwp_afgf_setting_email_tag( $position, $form_id ) {

	if ( $position == 25 ) {
		?>
		<li class="affwp_email_tag_setting field_setting">
			<input type="checkbox" id="affwp_email_tag" onclick="SetFieldProperty( 'affwp_email_tag', this.checked );" />
			<label for="affwp_email_tag" class="inline">
				<?php _e( 'Create AffiliateWP email tag', 'gravityforms' ); ?>
				<?php gform_tooltip( 'form_field_affwp_email_tag' ) ?>
			</label>
		</li>
		<?php
	}
}
add_action( 'gform_field_standard_settings', 'affwp_afgf_setting_email_tag', 10, 2 );


/**
 * Field validation
 *
 * @since 1.0
 */
function affwp_afgf_setting_email_tag_tooltips( $tooltips ) {

   $tooltips['form_field_affwp_email_tag'] = '<h6>' . __( 'Create Email Tag', 'affiliatewp-afgf' ) . '</h6>' . __( 'Creates an email tag for use in AffiliateWP emails.', 'affiliatewp-afgf' );

   return $tooltips;

}
add_filter( 'gform_tooltips', 'affwp_afgf_setting_email_tag_tooltips' );

/**
 * Hides registration fields for logged in users.
 *
 * @since 1.0
 * @since 1.0.16 Set default values for the username and email fields.
 */
function affwp_afgf_form_remove_fields( $form, $ajax, $field_values ) {

	if ( ! is_user_logged_in() ) {
		return $form;
	}

	$current_user = wp_get_current_user();

	if ( ! $current_user instanceof \WP_User ) {
		return $form;
	}

	$user_login = $current_user->user_login;
	$user_email = $current_user->user_email;

	$fields_to_hide = array(
		affwp_afgf_get_field_id( 'password' )
	);

	foreach ( $form['fields'] as $key => $field ) {

		// Hide fields
		if ( in_array( $field['id'], $fields_to_hide ) ) {
			unset( $form['fields'][ $key ] );
		}

		// Set default value for the username field.
		if ( 'username' === $field->type ) {
			$field->defaultValue = $user_login;
		}

		// Set default value for the email field.
		if ( 'email' === $field->type ) {
			$field->defaultValue = $user_email;
		}

	}

	return $form;

}
add_filter( 'gform_pre_render_' . affwp_afgf_get_registration_form_id(), 'affwp_afgf_form_remove_fields', 10, 3 );

/**
 * Disable username and email fields.
 *
 * @since 1.0.16
 *
 * @param string $field_content The field content to be filtered.
 * @param object $field The field that this input tag applies to.
 * @param string $value The default/initial value that the field should be pre-populated with.
 * @param int    $entry_id When executed from the entry detail screen, $entry_id will be populated with the Entry ID. Otherwise, it will be 0.
 * @param int    $form_id The current Form ID.
 *
 * @return $field_content
 */
function affwp_afgf_disable_fields( $field_content, $field, $value, $entry_id, $form_id ) {

	if ( ! is_user_logged_in() ) {
		return $field_content;
	}

	if ( 'username' === $field->type || 'email' === $field->type ) {
		$field_content = str_replace( '/>', 'disabled />', $field_content );
	}

	return $field_content;

}
add_filter( 'gform_field_content_' . affwp_afgf_get_registration_form_id(), 'affwp_afgf_disable_fields', 10, 5 );

/**
 * Force KSES sanitization on the affiliate registration form.
 *
 * @since 1.0.22
 *
 * @param string   $allowable_tags List of tags that can be used in GF field sanitization.
 * @param GF_Field $field          The field being sanitized.
 * @param int      $form_id        The form ID.
 * @return string Allowable tags.
 */
function affwp_afgf_sanitize_fields( $allowable_tags, $field, $form_id ) {

	// Force sanitization on the registration form.
	if ( $form_id === affwp_afgf_get_registration_form_id() ) {
		return '';
	}

	return $allowable_tags;
}

/**
 * Only force KSES sanitization when forms are submitted.
 */
add_action( 'gform_pre_submission', function() {
	add_filter( 'gform_allowable_tags', 'affwp_afgf_sanitize_fields', 10, 3 );
} );
