<?php
/**
 * Fields Component
 *
 * @package     AffiliateWP Affiliate Forms for Gravity Forms
 * @subpackage  Core
 * @copyright   Copyright (c) 2021, Sandhills Development, LLC
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       1.1
 */
namespace AffiliateWP_AFGF;

use AffiliateWP_AFGF\Fields\Payment_Email_Field;
use AffiliateWP_AFGF\Fields\Promotion_Method_Field;
use AffiliateWP_AFGF\Fields\Username_Field;

/**
 * Sets up the new fields component.
 *
 * @since 1.1
 */
class Fields {

	/**
	 * Bootstraps fields-related functionality.
	 *
	 * @since 1.1
	 */
	public function __construct() {
		$this->register_fields();
	}

	/**
	 * Registers custom fields.
	 *
	 * @since 1.1
	 */
	public function register_fields() {
		try {
			if ( ! class_exists( 'GF_Field_Username' ) ) {
				\GF_Fields::register( new Username_Field );
			}

			\GF_Fields::register( new Promotion_Method_Field );
			\GF_Fields::register( new Payment_Email_Field );
		} catch ( \Exception $exception ) {
			affiliate_wp()->utils->log( 'afgf: ' . $exception->getMessage() );
		}
	}

}
