<?php
class PAP_WC_POINTS_REWARDS {

	public $settings;
	public $count_referrals_processed;
	public $pending_admin_notice;

	public function __construct($settings) {
		$this->settings = $settings;
		$this->setup();
		
	}
	
	public function setup() {
		
		$this->context = 'edd';

		// Make sure Wallet is installed
		/*if( ! class_exists( 'EDD_Wallet' ) ) {
			add_action( 'admin_notices', array( $this, 'missing_edd_wallet' ) );
			return;
		}*/

		add_filter( 'edd_wallet_activity_type', array( $this, 'setup_wallet_type' ), 10, 2 );
		add_filter( 'edd_wallet_activity_actions', array( $this, 'setup_wallet_actions' ), 10, 2 );
		
	}
	
		// Add admin settings if required.
	public function admin_settings($settings) {
		
		/*$settings['pap']['pap_wcpr_convert_ratio_override_enable'] = array(
			'name' => __( 'Override the conversion ratio', 'affiliate-wp-pay-as-points' ),
			'desc' => __( 'Check this box to use a different redemption conversion rate to that which in the Point & rewards settings. Woocommerce > Settings > Points & Rewards', 'affiliate-wp-pay-as-points' ),
			'type' => 'checkbox'
		);
						
		$settings['pap']['pap_wcpr_convert_ratio_override_ratio'] = array(
			'name' => __( '</br>Conversion rate override', 'woocommerce-points-rewards' ),
			'desc' => __( '</br>If enabled above, enter the redemption rate to use.</br>Format points:dollars. Example 100:1 equals 100 points for every referral dollar.', 'affiliate-wp-pay-as-points' ),
			'type' => 'text'
		);*/
		
		return $settings;
		
	}
	
	// Calculate the points to allocate. Required Method
	public function calculate_points($referral_amount) {
	
		$conversion_ratio_parts = explode(":", $this->conversion_ratio);
		$conversion_ratio_multiplier = ($conversion_ratio_parts[0]/$conversion_ratio_parts[1]);
		$points = ($referral_amount*$conversion_ratio_multiplier);
		
		if($this->conversion_rounding == 'round') $points = round($points);
		if($this->conversion_rounding == 'floor') $points = floor($points);
		if($this->conversion_rounding == 'ceil') $points = ceil($points);
		
		return $points;
		
	}
	
	// Log the points. Required Method
	public function process_points($referral_id, $points, $user_id, $debit_credit) {
		
		// Deposit the funds into the users' wallet
		//edd_wallet()->wallet->deposit( $user_id, $referral->amount, 'referral-payout', $referral_id );
		
		// Withdraw. Get the users' balance
		//$balance = edd_wallet()->wallet->balance( $user_id );

		//if( (float) $balance >= (float) $referral->amount ) {
			// Withdraw the funds from the users' wallet
			//edd_wallet()->wallet->withdraw( $user_id, $referral->amount, 'referral-cancel', $referral_id );
		//}
	
		if(!isset($this->count_referrals_processed)) $this->count_referrals_processed = 0;
		
		if ( ! empty( $points ) ) {
				 
			if($debit_credit=='credit')  {
				if(WC_Points_Rewards_Manager::increase_points($user_id, $points,'converted-affiliate-commission')) {
				
					$this->count_referrals_processed ++;
					if(!isset($this->pending_admin_notice)) $this->pending_admin_notice = 'successfully converted to loyalty points!';
	
				}
				
			} elseif($debit_credit=='debit') {
				if(WC_Points_Rewards_Manager::decrease_points($user_id, $points,'reverted-affiliate-commission')) {
				
					$this->count_referrals_processed ++;
					if(!isset($this->pending_admin_notice)) $this->pending_admin_notice = ' reverted fom loyalty points!';
					
				}
			}

		}
		
	}
	
	public function setup_wallet_type( $item_type, $item ) {
		switch( $item_type ) {
			case 'referral-payout' :
				return __( 'Referral Payout', 'affiliate-wp-pay-as-points' );
				break;
			case 'referral-cancel' :
				return __( 'Referral Cancelled', 'affiliate-wp-pay-as-points' );
				break;
			default :
				return $item_type;
				break;
		}
	}
	
	
	/*public function missing_edd_wallet() {
		echo '<div class="error"><p>' . __( 'AffiliateWP - Store Credit EDD integration requires the EDD Wallet extension!', 'affiliate-wp-pay-as-points' ) . '</p></div>';
	}*/
	
	public function setup_wallet_actions( $item_actions, $item ) {
		switch( $item->type ) {
			case 'referral-payout' :
			case 'referral-cancel' :
				return '<a title="' . __( 'View Details for Referral', 'affiliate-wp-pay-as-points' ) . ' ' . $item->payment_id . '" href="' . admin_url( 'admin.php?page=affiliate-wp-referrals&action=edit_referral&referral_id=' . $item->payment_id ) . '">' . __( 'View Details', 'affiliate-wp-pay-as-points' ) . '</a>';
				break;
			default :
				return $item_actions;
				break;
		}
	}
	
	
} // End of class

?>