<?php
class PAP_Settings {

	public $all_settings;

	public function __construct() {
		
		// New settings tab & settings
		add_filter( 'affwp_settings_tabs', array( $this, 'settings_tab' ) );
		add_filter( 'affwp_settings', array( $this, 'settings' ), 10, 1 );
		
		$this->all_settings = $this->get_all_settings();

	}
	
	public function settings_tab( $tabs ) {
		$tabs['pap'] = __( 'Pay as Points', 'affiliate-wp-pay-as-points' );
		return $tabs;
	}
	
	public function get_all_settings() {
	
		$settings = $this->settings(array());
		//print_r($settings);

		foreach($settings['pap'] as $key => $value) {
			
			if (class_exists( 'Affiliate_WP' ) ) {
				$thesettings[$key] = affiliate_wp()->settings->get($key);
			}
		}
		
		// Add the tier settings
		$rates = AffiliateWP_PAP::get_tiered_rates();
		foreach( $rates as $tiered_rate ) {			
			$setting_key = 'pap_'.'tier_convert'.$tiered_rate['type'].'_'.$tiered_rate['threshold'];	
			$thesettings[$setting_key] = affiliate_wp()->settings->get($setting_key);			
		}
		
		// Add the user role settings. This hanldes groups also
		$roles = AffiliateWP_PAP::get_user_roles();
		foreach( $roles as $key => $name) {
			$setting_key = 'pap_'.'user_role_'.$key;
			$thesettings[$setting_key] = affiliate_wp()->settings->get($setting_key);

		}
		
		
		
		//print_r($thesettings);
		return $thesettings;
	
	}
	
	public function settings( $settings ) {
	
		$pap_settings = array(
			'pap' => apply_filters( 'affwp_settings_pap',
							array(
					/*'woocommerce_points_rewards_enable_integration' => array(
						'name' => __( 'Enable Pay as Points', affiliate-wp-pay-as-points' ),
						'desc' => __( 'Check this box to enable Pay as Points.', 'affiliate-wp-pay-as-points' ),
						'type' => 'checkbox'
					),*/
					
					/*'pap_section_licensing' => array(
						'name' => '<strong>' . __( 'License Settings', 'affiliate-wp-pay-as-points' ) . '</strong>',
						'desc' => '',
						'type' => 'header'
					),*/
					
					'pap_license_key' => array(
						'name' => __( 'License Key', 'affiliate-wp-pay-as-points' ),
						'desc' => $this->license_status_msg() . '<p>Activated license required for automatic updates.</p>',
						'type' => 'text',
					),
					
					'pap_section_general_settings' => array(
						'name' => '<strong>' . __( 'General Settings', 'affiliate-wp-pay-as-points' ) . '</strong>',
						'desc' => '',
						'type' => 'header'
					),
					
					'pap_mark_as_paid' => array(
						'name' => __( 'Mark Referrals as Paid', 'affiliate-wp-pay-as-points' ),
						'desc' => __( 'Check this box to have all converted referrals marked a paid (Recommended)', 'affiliate-wp-pay-as-points' ),
						'type' => 'checkbox'
					),
					
					'pap_manual_convert_user' => array(
						'name' => __( 'Front-end Convert', 'affiliate-wp-pay-as-points' ),
						'desc' => __( "Check this box to allow front end users to manually convert referrals. This may not appear depending on other auto-convert settings.", 'affiliate-wp-pay-as-points' ),
						'type' => 'checkbox'
					),
					
					'pap_section_integrations' => array(
						'name' => '<strong>' . __( 'Points Integration Settings', 'affiliate-wp-pay-as-points' ) . '</strong>',
						'desc' => '',
						'type' => 'header'
					),
					
					'pap_points_rewards_integration' => array(
						'name' => __( 'Points & Rewards Integration', 'affiliate-wp-pay-as-points' ),
						'desc' => __( 'Select your points & rewards integration.', 'affiliate-wp-pay-as-points' ),
						'type' => 'select',
						'options' => array(
							/*'' => __( 'None', 'affiliate-wp-pay-as-points' ),*/
							'WC_Points_Rewards' => __( 'WooCommerce Points & Rewards', 'affiliate-wp-pay-as-points' ),
							/*'disabled' => __( 'Disabled', 'affiliate-wp-pay-as-points' ),	*/
						)
					),
					
				)
			)
		);
		
		
		// Add integration settings
		$pap_settings = $this->add_integration_settings($pap_settings);
		
		// Add more settings
		/////////////////////
		
					$pap_settings['pap']['pap_section_auto_convert'] = array(				
						'name' => '<strong>' . __( 'Auto Convert', 'affiliate-wp-pay-as-points' ) . '</strong>',
						'desc' => '',
						'type' => 'header'
					);
					
					$pap_settings['pap']['pap_enable_auto_convert'] = array(	
						'name' => __( 'Enable Auto Convert', 'affiliate-wp-pay-as-points' ),
						'desc' => __( 'Check this box to have referrals automatically converted to points.', 'affiliate-wp-pay-as-points' ),
						'type' => 'checkbox'
					);
					
					$pap_settings['pap']['pap_auto_convert_user_changeable'] = array(	
						'name' => __( 'Auto Convert - Allow user to disable', 'affiliate-wp-pay-as-points' ),
						'desc' => __( 'Check this box to allow eligible front end users the ability to disable auto conversions.', 'affiliate-wp-pay-as-points' ),
						'type' => 'checkbox'
					);
					
					/*$pap_settings['pap']['pap_section_auto_convert_advanced'] = array(				
						'name' => '<strong>' . __( 'Auto Convert - Advanced', 'affiliate-wp-pay-as-points' ) . '</strong>',
						'desc' => '',
						'type' => 'header'
					);*/
		
		////////////////////
		
		//$pap_settings = array();
		
		// Add tier settings if add-on in installed
		if(class_exists('AffiliateWP_Tiered_Rates')) {
			$pap_settings = $this->add_tier_settings($pap_settings);
		}
		
		// Add affiliate group settings if add-on installed
		if(class_exists('AffiliateWP_Affiliate_Groups')) {
			$pap_settings = $this->add_affiliate_group_settings($pap_settings);
		}
		//echo '<pre>'; print_r($pap_settings); echo '</pre>';
		
		// Add user role settings
		$pap_settings = $this->add_user_role_settings($pap_settings);
		
		// Merge settings
		$settings = array_merge( $settings, $pap_settings );	
		
		//echo '<pre>'; print_r($settings); echo '</pre>';	
		
		return $settings;
	}
	
	// Add integration settings
	public function add_integration_settings($settings) {

	  $integration = (isset($this->all_settings['pap_points_rewards_integration'])) ? $this->all_settings['pap_points_rewards_integration'] : 'WC_Points_Rewards';
		
		switch ($integration){
			case "WC_Points_Rewards":
				if(AffiliateWP_PAP::check_third_party_plugin('WC_Points_Rewards')) {
					$settings = PAP_WC_POINTS_REWARDS::admin_settings($settings);
				}	
			break;	
				
		}
		
		return $settings;
		
	}
	
	// add tier settings
	public function add_tier_settings($settings) {
		
		$rates = AffiliateWP_PAP::get_tiered_rates();
		
		$php_version = phpversion();
		if($php_version>='5.3') {			
			usort($rates, function($a, $b) {
    			return $b['rate'] - $a['rate'];
			});
		}
		
		foreach( $rates as $tiered_rate ) {
			//$tiered_rate['type'] | earnings   or   referrals
			//$tiered_rate['threshold']
			//$tiered_rate['rate']
			
			$settings['pap']['pap_section_auto_convert_tiers'] = array(				
				'name' => '<strong>' . __( 'Auto Convert - Disable tiers', 'affiliate-wp-pay-as-points' ) . '</strong>',
				'desc' => '',
				'type' => 'header'
				);
			
			$setting_key = 'pap_'.'tier_convert'.$tiered_rate['type'].'_'.$tiered_rate['threshold'];
			$setting_name = ucfirst($tiered_rate['type'].' '.$tiered_rate['threshold']);
			$setting_description = __( 'Disable Auto Convert on tier', 'affiliate-wp-pay-as-points' ).' \''.$setting_name.'\'';
			
			if($tiered_rate['type']=='earnings') {
				if(!isset($previous_earnings_tier_th)) $previous_earnings_tier_th = 'infinity';
				$setting_description .= ' (Between '.$tiered_rate['threshold'].' & '.$previous_earnings_tier_th.').';
				$previous_earnings_tier_th = $tiered_rate['threshold'];
			}elseif($tiered_rate['type']=='referrals') {
				if(!isset($previous_referrals_tier_th)) $previous_referrals_tier_th = 'infinity';
				$setting_description .= ' (Between '.$tiered_rate['threshold'].' & '.$previous_referrals_tier_th.').';
				$previous_referrals_tier_th = $tiered_rate['threshold'];
			}
			
			$settings['pap'][$setting_key] = array(
				'name' => __( $setting_name, 'affiliate-wp-pay-as-points' ),
								'desc' => __( $setting_description, 'affiliate-wp-pay-as-points' ),
								'type' => 'checkbox'
				);
			
		}
		
		
				
		return $settings;
		
	}
	
	// Add affiliate group settings
	public function add_affiliate_group_settings($settings) {
		
		//$roles = AffiliateWP_PAP::get_user_roles();
		
		$active_groups = AffiliateWP_PAP::get_active_affiliate_groups();
		//print_r($active_groups);
		if( !empty($active_groups) ) {
			
			$settings['pap']['pap_section_auto_convert_affiliate_groups'] = array(				
				'name' => '<strong>' . __( 'Auto Convert - Disable Affiliate groups', 'affiliate-wp-pay-as-points' ) . '</strong>',
				'desc' => '',
				'type' => 'header'
				);
		
			foreach( $active_groups as $key => $data) {
				
				// Check that the role is an active group
				//if( (array_key_exists($key, $active_groups)) ) {
				
					$setting_key = 'pap_'.'group_'.$key;
					$setting_name = $data['name'];
					$setting_description = __( 'Disable Auto Convert for Affiliate group', 'affiliate-wp-pay-as-points' ).' \''.$data['name'].'\'';
					
					$settings['pap'][$setting_key] = array(
						'name' => __( $setting_name, 'affiliate-wp-pay-as-points' ),
										'desc' => __( $setting_description, 'affiliate-wp-pay-as-points' ),
										'type' => 'checkbox'
						);
					
				//}
			}
		
		}
		
		return $settings;
	}
	
	// Add user role settings
	public function add_user_role_settings($settings) {
		
		$roles = AffiliateWP_PAP::get_user_roles();
		if(class_exists('AffiliateWP_Affiliate_Groups')) {
			$active_groups = AffiliateWP_PAP::get_active_affiliate_groups();
		} else {
			$active_groups = array();
		}
		
		if( !empty($active_groups) ) {
		//print_r($active_groups);
		
		$settings['pap']['pap_section_auto_convert_user_roles'] = array(				
				'name' => '<strong>' . __( 'Auto Convert - Disable user roles', 'affiliate-wp-pay-as-points' ) . '</strong>',
				'desc' => '',
				'type' => 'header'
				);
		
			foreach( $roles as $key => $name) {
				
				// Check that the role is an active group
				if( !(array_key_exists($key, $active_groups)) ) {
				
					$setting_key = 'pap_'.'user_role_'.$key;
					$setting_name = $name;
					$setting_description = __( 'Disable Auto Convert for user role', 'affiliate-wp-pay-as-points' ).' \''.$name.'\'';
					
					$settings['pap'][$setting_key] = array(
						'name' => __( $setting_name, 'affiliate-wp-pay-as-points' ),
										'desc' => __( $setting_description, 'affiliate-wp-pay-as-points' ),
										'type' => 'checkbox'
						);
					
				}
			}
		
		}
		
		return $settings;
	}
	
	// Get the license message
	public function license_status_msg() {
	
		$status_msg = '';

		$updater = new AffiliateWP_PaP_License();
		if(isset($this->all_settings['pap_license_key'])) {
			$license_key = $this->all_settings['pap_license_key'];
		}
		if (class_exists( 'Affiliate_WP' ) ) {
			$license_status = affiliate_wp()->settings->get( 'pap_license_status' );	
		}
			
		if( 'valid' === $license_status && ! empty( $license_key ) ) {

			$status_msg .= '<span style="color:green;">&nbsp;' . __( 'Your license is valid!', 'affiliate-wp-pay-as-points' ) . '</span>';	
					
		} elseif( 'invalid' === $license_status && ! empty( $license_key ) ) {		
		
			$renewal_url = esc_url( add_query_arg( array( 'edd_license_key' => $license_key, 'download_id' => 805 ), 'http://www.clickstudio.com.au/checkout/' ) );			
			$status_msg = '<a href="' . esc_url( $renewal_url ) . '" class="button-primary" target="_blank">' . __( 'Renew Your License', 'affiliate-wp-pay-as-points' ) . '</a>';
			$status_msg .= '<br/><span style="color:red;">&nbsp;' . __( 'Your license has expired or you have hit your activation limit.', 'affiliate-wp-pay-as-points' ) . '</span>';	
				
		} else{
					$status_msg = '<input type="submit" class="button" name="affwp_pap_activate_license" value="' . esc_attr__( 'Activate License', 'affiliate-wp-pay-as-points' ) . '"/>';			
		}
		
		return $status_msg;
	}
	
} // End of class
?>