<?php

class AffiliateWP_PaP_License {

# URL to check for updates, this is where the index.php script goes
public $api_url;

# Type of package to be updated
public $settings;

function __construct() {

// this is the URL our updater / license checker pings. This should be the URL of the site with EDD installed
if ( ! defined( 'SERVER_URL' ) ) {
			define( 'SERVER_URL', 'http://www.clickstudio.com.au' ); 
		}

if ( ! defined( 'PLUGIN_NAME' ) ) {
			// the name of your product. This should match the download name in EDD exactly
			define( 'PLUGIN_NAME', 'AffiliateWP - Pay as Points' );
		}



//add_action('admin_init', array( $this, 'affiliatewp_social_media_tool_kit_check_license'), 0);
add_action('admin_init', array( $this, 'activate_license' ));
add_action('admin_init', array( $this, 'deactivate_license' ));


}

/*public function AffiliateWP_Social_Sharing_License($settings) {
 $this->settings = $settings;
 
if ( ! defined( 'SERVER_URL' ) ) {
			define( 'SERVER_URL', 'http://www.clickstudio.com.au' ); 
		}

if ( ! defined( 'PLUGIN_NAME' ) ) {

			define( 'PLUGIN_NAME', 'AffiliateWP - Social Media Tool Kit' );
		}

add_action('admin_init', array( $this, 'affiliatewp_social_media_tool_kit_activate_license' ));
add_action('admin_init', array( $this, 'affiliatewp_social_media_tool_kit_deactivate_license' ));

}*/

function activate_license() {

	if (class_exists( 'Affiliate_WP' ) ) {
		$this->settings = affiliate_wp()->settings->get_all();
	}

			/*$options = affiliate_wp()->settings->get_all();
			unset($options['affwp_social_media_kit_license_status']);
			update_option( 'affwp_settings', $options );*/

	// listen for our activate button to be clicked
	if(isset($_POST['affwp_pap_activate_license'])){

		// run a quick security check
	 	//if( ! check_admin_referer( 'edd_sample_nonce', 'edd_sample_nonce' ) )
			//return; // get out if we didn't click the Activate button

		// retrieve the license from the database
		//$license = trim( $this->settings['socialsharing_license_key'] );
		if(isset($_POST['affwp_settings']['pap_license_key'])) {
			$license = $_POST['affwp_settings']['pap_license_key'];
		} else {
			$license = trim( $this->settings['pap_license_key'] );
		}
		
		// data to send in our API request
		$api_params = array(
			'edd_action'=> 'activate_license',
			'license' 	=> $license,
			'item_name' => urlencode( PLUGIN_NAME ), // the name of our product in EDD
			'url'       => home_url()
		);

		// Call the custom API.
		$response = wp_remote_post( SERVER_URL, array( 'timeout' => 15, 'body' => $api_params ) );

		// make sure the response came back okay
		if ( is_wp_error( $response ) )
			return false;

		// $license_data->license will be either "valid" or "invalid"

		//update_option( 'edd_sample_license_status', $license_data->license );
		
		
		// Decode the license data
		$license_data = json_decode( wp_remote_retrieve_body( $response ) );
		
		if($license_data->license == 'valid') {
			$options = affiliate_wp()->settings->get_all();
			$options['pap_license_status'] = $license_data->license;
			update_option( 'affwp_settings', $options );
		} /*else {
			$options = affiliate_wp()->settings->get_all();
			$options['affwp_social_media_kit_license_status'] = 'invalid';
			update_option( 'affwp_settings', $options );
		}*/

	}
}


/***********************************************
* Illustrates how to deactivate a license key.
* This will descrease the site count
***********************************************/

function deactivate_license() {

	if (class_exists( 'Affiliate_WP' ) ) {
		$this->settings = affiliate_wp()->settings->get_all();
	}

	// listen for our activate button to be clicked
	if(isset($_POST['affwp_pap_deactivate_license'])) {

		// run a quick security check
	 	//if( ! check_admin_referer( 'edd_sample_nonce', 'edd_sample_nonce' ) )
			//return; // get out if we didn't click the Activate button

		// retrieve the license from the database
		if(isset($_POST['affwp_settings']['pap_license_key'])) {
			$license = $_POST['affwp_settings']['pap_license_key'];
		} else {
			$license = trim( $this->settings['pap_license_key'] );
		}


		// data to send in our API request
		$api_params = array(
			'edd_action'=> 'deactivate_license',
			'license' 	=> $license,
			'item_name' => urlencode( PLUGIN_NAME ), // the name of our product in EDD
			'url'       => home_url()
		);

		// Call the custom API.
		$response = wp_remote_post( SERVER_URL, array( 'timeout' => 15, 'body' => $api_params ) );

		// make sure the response came back okay
		if ( is_wp_error( $response ) )
			return false;

		// decode the license data
		$license_data = json_decode( wp_remote_retrieve_body( $response ) );
		
		// $license_data->license will be either "deactivated" or "failed"
		//if( $license_data->license == 'deactivated' )
			//delete_option( 'edd_sample_license_status' );
			
		// Make sure the response came back okay
		//if ( is_wp_error( $response ) )
			//return false;
		if( $license_data->license == 'deactivated' ) {
			$options = affiliate_wp()->settings->get_all();
			//$options['affwp_social_media_kit_license_status'] = 0;
			unset($options['pap_license_status']);
			update_option( 'affwp_settings', $options );
			//delete_transient( 'affwp_mlm_license_check' );
		}

	}
}


/************************************
* this illustrates how to check if
* a license key is still valid
* the updater does this for you,
* so this is only needed if you
* want to do something custom
*************************************/

function affiliatewp_social_media_tool_kit_check_license() {

	global $wp_version;

	$license = trim( $this->settings['pap_license_key'] );

	$api_params = array(
		'edd_action' => 'check_license',
		'license' => $license,
		'item_name' => urlencode( PLUGIN_NAME ),
		'url'       => home_url()
	);

	// Call the custom API.
	$response = wp_remote_post( SERVER_URL, array( 'timeout' => 15, 'sslverify' => false, 'body' => $api_params ) );

	if ( is_wp_error( $response ) )
		return false;

	$license_data = json_decode( wp_remote_retrieve_body( $response ) );
	
	// Decode the license data
	$options = affiliate_wp()->settings->get_all();
	$options['pap_license_status'] = $license_data->license;
	update_option( 'affwp_settings', $options );

	if( $license_data->license == 'valid' ) {

		return 'valid';
	} else {

		return 'invalid';
	}
}

 
} // End of class
?>
