<?php
/*
Plugin Name: AffiliateWP - Pay as Points
Plugin URI: http://clickstudio.com.au
Description: Converts AffiliateWP Commissions to WooCommerce Points
Version: 1.2.12
Author: Click Studio
Author URI: http://clickstudio.com.au
License: GPL2
*/

//add_action( 'init', array ( AffiliateWP_PAP::instance(), '__construct' ));

class AffiliateWP_PAP {

	private static $instance = NULL;

	public static function instance() {

		NULL === self::$instance and self::$instance = new self;
		
		self::$instance->setup_constants();
		self::$instance->setup_hooks();
		self::$instance->includes();
		self::$instance->setup_objects();
		self::$instance->setup_integrations();
		
		// Must be here to catch the AffiliateWP hook
		self::$instance->process_front_end_actions();

		return self::$instance;		

	}

	public function __construct() {	
	
		if (class_exists( 'Affiliate_WP' ) ) {
			$this->the_settings = affiliate_wp()->settings->get_all();
		}
		
		// Now only required to get front end settings
		$this->get_settings();
		
		//$options = affiliate_wp()->settings->get_all();
		//unset($options['pap_points_rewards_integration']);
		//update_option( 'affwp_settings', $options );
		
		// Load text domain
		//load_plugin_textdomain( 'affiliate-wp-pay-as-points', false, basename( dirname( __FILE__ ) ) . '/languages' );
		$this->load_textdomain();

	}
	
	public function load_textdomain() {

		// Set filter for plugin's languages directory
		$lang_dir = basename( dirname( __FILE__ ) ) . '/languages';

		global $wp_version;
		$get_locale = get_locale();
		if ( $wp_version >= 4.7 ) {
			$get_locale = get_user_locale();
		}

		$locale = apply_filters( 'plugin_locale', $get_locale, 'affiliate-wp-pay-as-points' );
		$mofile = sprintf( '%1$s-%2$s.mo', 'affiliate-wp-pay-as-points', $locale );

		$mofile_global = WP_LANG_DIR . '/affiliate-wp-pay-as-points/'. $mofile;

		if ( file_exists( $mofile_global ) ) {
			// Look in global /wp-content/languages/ folder
			load_textdomain( 'affiliate-wp-pay-as-points', $mofile_global );
		}else {
			// Load the default language files from plugin
			load_plugin_textdomain( 'affiliate-wp-pay-as-points', false, $lang_dir );
		}
	}
	
	// Set up constants
	private function setup_constants() {
		if ( ! defined( 'VERSION_PAP' ) ) {
			define( 'VERSION_PAP', '1.2.11' );
		}	
		if ( ! defined( 'PLUGIN_DIR_PAP' ) ) {
			define( 'PLUGIN_DIR_PAP', plugin_dir_path( __FILE__ ) );
		}		
		if ( ! defined( 'UPDATER_URL' ) ) {
			define( 'UPDATER_URL', 'https://www.clickstudio.com.au' );
		}		
		if ( ! defined( 'UPDATER_ITEM_NAME' ) ) {
			define( 'UPDATER_ITEM_NAME', 'AffiliateWP - Pay as Points' );
		}
	}
	
	// Set up hooks
	private function setup_hooks() {
			// Prepare the settings
			add_action( 'init', array( $this, 'get_settings' ));
			
			// Updater
			add_action( 'admin_init', array ( $this, 'affiliatewp_pap_plugin_updater' ), 0);
			
			// Auto process			
			add_action( 'affwp_complete_referral', array( $this, 'auto_convert_from_complete_referral' ), 99, 3 );
			
			// Auto process	 MLA Referral	
			add_action( 'mla_complete_referral', array( $this, 'auto_convert_mla_referral' ), 99, 1 );
			
			// Add shortcodes
			add_shortcode( 'affiliate-wp-points-template-part', array( $this, 'custom_get_template_part' ) );	
			
			add_shortcode( 'dev_test', array( $this, 'pap_test' ) );
			
			// Custom convert action
			add_action( 'affwp_pap_convert', array( $this, 'process_referrals' ), 10, 3 );

		
		if( is_admin() ) {
		
			// Process backend actions
			add_action( 'admin_init', array( $this, 'process_admin_actions'), 0, 10);
			// Add the backend notices
			add_action( 'admin_notices', array( $this, 'admin_notices'));
			
			// Add affiliates convert filter
			add_filter( 'affwp_affiliate_row_actions', array( $this, 'add_affiliate_convert_action' ), 10, 2 );
			// Add referrals convert filter
			add_filter( 'affwp_referral_action_links', array( $this, 'add_referrals_convert_action' ), 10, 2 );
			
			// Add bulk actions
			add_filter( 'affwp_affilates_bulk_actions', array( $this, 'add_affilates_bulk_actions' ) );
			add_filter( 'affwp_referrals_bulk_actions', array( $this, 'add_referrals_bulk_actions' ) );
			
			
		
		} else {
		
			// Front end actions
			add_action( 'affwp_referrals_dashboard_before_table', array( $this, 'wcpr_before_referrals_table' ));
			add_action( 'affwp_referrals_dashboard_th', array( $this, 'wcpr_frontend_referral_column_ths' ), 10, 0);
			add_action( 'affwp_referrals_dashboard_td', array( $this, 'wcpr_frontend_referral_column_tds' ));
			
			// Front end actions
			add_action( 'affwp_update_affiliate_profile_settings', array( $this, 'process_front_end_actions' ));
			add_action( 'init', array( $this, 'process_front_end_actions' ), 8);
			
			// Front end settings
			add_action( 'affwp_affiliate_dashboard_before_submit', array( $this, 'front_end_settings_output' ), 10, 2 );
		
		}
	}
	
	// Includes
	private function includes() {
		require_once PLUGIN_DIR_PAP . 'includes/class-settings.php';
		require_once PLUGIN_DIR_PAP . 'includes/class-updater.php';
		require_once PLUGIN_DIR_PAP . 'includes/class-licenses.php';
	}
	
	// Set up objects
	private function setup_objects() {
		self::$instance->settings = new PAP_Settings;
		self::$instance->the_settings = self::$instance->settings->all_settings;
		$this->updater = new AffiliateWP_PaP_License();
	}
	
	// Set up integrations
	private function setup_integrations() {
		
		// WC Points and Rewards
		if(self::$instance->the_settings['pap_points_rewards_integration']=='WC_Points_Rewards') {
			if($this->check_third_party_plugin('WC_Points_Rewards')) {
				require_once PLUGIN_DIR_PAP . 'integrations/wc_points_rewards.php';
				self::$instance->points_integration = new PAP_WC_POINTS_REWARDS(self::$instance->the_settings);	
			}
		}
		
	}
	
	// Plugin activation function
	public static function activate_plugin() {
		
		// Add the deafult integration if none exists (prior to v1.2 none existed)
		$options = affiliate_wp()->settings->get_all();
		if(!isset($options['pap_points_rewards_integration'])) {		
			if(AffiliateWP_PAP::check_third_party_plugin('WC_Points_Rewards')) {	
				if (class_exists( 'Affiliate_WP' ) ) {
					//$options = affiliate_wp()->settings->get_all();
					$options['pap_points_rewards_integration'] = 'WC_Points_Rewards';
					update_option( 'affwp_settings', $options );
				}	
			}	
		}
		
		///////////////////////////////////// Upgrade settings (renaming)
		
		$options = affiliate_wp()->settings->get_all();
		
		if(array_key_exists('woocommerce_points_rewards_license_key', $options)) {
			$options['pap_license_key'] = affiliate_wp()->settings->get( 'woocommerce_points_rewards_license_key');
			unset($options['woocommerce_points_rewards_license_key']);
		}
		if(array_key_exists('woocommerce_points_rewards_mark_as_paid', $options)) {
			$options['pap_mark_as_paid'] = affiliate_wp()->settings->get( 'woocommerce_points_rewards_mark_as_paid');
			unset($options['woocommerce_points_rewards_mark_as_paid']);
		}
		if(array_key_exists('woocommerce_points_rewards_enable_auto_convert', $options)) {
			$options['pap_enable_auto_convert'] = affiliate_wp()->settings->get( 'woocommerce_points_rewards_enable_auto_convert');
			unset($options['woocommerce_points_rewards_enable_auto_convert']);
		}
		if(array_key_exists('woocommerce_points_rewards_auto_convert_user_changeable', $options)) {
			$options['pap_auto_convert_user_changeable'] = affiliate_wp()->settings->get( 'woocommerce_points_rewards_auto_convert_user_changeable');
			unset($options['woocommerce_points_rewards_auto_convert_user_changeable']);
		}
		if(array_key_exists('woocommerce_points_rewards_manual_convert_user', $options)) {
			$options['pap_manual_convert_user'] = affiliate_wp()->settings->get( 'woocommerce_points_rewards_manual_convert_user');
			unset($options['woocommerce_points_rewards_manual_convert_user']);
		}
		if(array_key_exists('woocommerce_points_rewards_convert_ratio_override_enable', $options)) {	
			$options['pap_wcpr_convert_ratio_override_enable'] = affiliate_wp()->settings->get( 'woocommerce_points_rewards_convert_ratio_override_enable');
			unset($options['woocommerce_points_rewards_convert_ratio_override_enable']);
		}
		if(array_key_exists('woocommerce_points_rewards_convert_ratio_override_ratio', $options)) {
			$options['pap_wcpr_convert_ratio_override_ratio'] = affiliate_wp()->settings->get( 'woocommerce_points_rewards_convert_ratio_override_ratio');
			unset($options['woocommerce_points_rewards_convert_ratio_override_ratio']);
		}
		if(array_key_exists('affwp_pay_as_points_license_status', $options)) {
			$options['pap_license_status'] = affiliate_wp()->settings->get( 'affwp_pay_as_points_license_status');
			unset($options['affwp_pay_as_points_license_status']);
		}
		
		$rates = AffiliateWP_PAP::get_tiered_rates();
		
		foreach( $rates as $tiered_rate ) {			
		$setting_key = 'woocommerce_points_rewards_'.'tier_convert'.$tiered_rate['type'].'_'.$tiered_rate['threshold'];	
		$new_settings_key = 'pap_'.'tier_convert'.$tiered_rate['type'].'_'.$tiered_rate['threshold'];
			if(array_key_exists($setting_key, $options)) {
				$options[$new_settings_key] = affiliate_wp()->settings->get($setting_key);
				unset($options[$setting_key]);
			}			
		}
		
		update_option( 'affwp_settings', $options );
		
		///////////////////////////////////////////////	End of upgrade settings

	}
	
	// Plugin deactivation function (empty)
	public static function deactivate_plugin() {}
	
	// Plugin updater
	public function affiliatewp_pap_plugin_updater() {
		if(isset($this->the_settings['pap_license_key'])) {
		$license_key = trim( $this->the_settings['pap_license_key'] );	
		$edd_updater = new EDD_SL_Plugin_Updater_Affpap( UPDATER_URL, __FILE__, array(
				'version' 	=> VERSION_PAP, 			// current version number
				'license' 	=> $license_key, 			// license key (used get_option above to retrieve from DB)
				'item_id'	=> 688,
				'item_name' => UPDATER_ITEM_NAME, 		// name of this plugin
				'author' 	=> 'Click Studio'  			// author of this plugin
				)
			);
		}
	}
	
	
	///////////////// Configure some settings ///////////////
	
	
	// Get settings (get front end settings)
	public function get_settings() {		
		$this->front_end_settings();		
	}
	
	// Load and set front end settings
	public function front_end_settings($order_id = '', $user = '') {

	if($order_id) {
		$referrals = affiliate_wp()->referrals->get_referrals( array( 'reference' => $order_id, 'status' => 'unpaid', 'number' => -1 ) );
		$affiliate_id = $referrals[0]->affiliate_id;
		$user_id = affwp_get_affiliate_user_id($affiliate_id);
	} else {
		$user_id = get_current_user_id();
	}
	
	// Override for passed user ID
	if( !empty($user) ) {
		
		$user_id = $user;
		
	}
	
	// Front end settings
		/* Front end auto changeable logic - Set defaults and overrides */
		if(($this->the_settings['pap_enable_auto_convert']) && ($this->the_settings['pap_auto_convert_user_changeable']) ) {
		 
			$frontend_auto_convert = get_user_meta( $user_id, 'pap_frontend_auto_convert', true );

			if($frontend_auto_convert!='') {
				$this->pap_frontend_auto_convert = $frontend_auto_convert;
			} else {
				$this->pap_frontend_auto_convert = '1';
			}
		
		} elseif(($this->the_settings['pap_enable_auto_convert']) && (!$this->the_settings['pap_auto_convert_user_changeable']) ) {
		
			$this->pap_frontend_auto_convert = '1'; 
		} else {
			$this->pap_frontend_auto_convert = '0';
			
			}

	}	

	
	
	///////////////// Output Admin Actions ///////////////
	
	
	// Add bulk action option to affiliates table
	public function add_affilates_bulk_actions($actions) {
		$actions['wcpr-convert-all-affiliates-bulk'] = __( 'Convert Commissions to Points', 'affiliate-wp-pay-as-points' );
		return $actions;
	}
	
	// Add bulk action option to referrals table
	public function add_referrals_bulk_actions($actions) {
		$actions['wcpr-convert-referrals-bulk'] = __( 'Convert Referrals to Points', 'affiliate-wp-pay-as-points' );
		return $actions;
	}
	
	// Add convert action to affiliates table
	public function add_affiliate_convert_action($row_actions, $affiliate) {
	
	$row_custom_actions['convert'] = '<a href="' . esc_url( add_query_arg( array( 'action' => 'wcpr-convert-all-affiliates', 'affiliate_id' => $affiliate->affiliate_id, 'affwp_notice' => false ) ) ) . '">' . __( 'Convert', 'affiliate-wp-pay-as-points' ) . '</a>';
	
	$row_actions = array_merge($row_actions, $row_custom_actions);
	return $row_actions;
	
	}
	
	// Add convert action to referrals table
	public function add_referrals_convert_action($action_links, $referral) {
	
	$action_links[] = '<span class="convert"><a href="' . esc_url( add_query_arg( array( 'action' => 'wcpr-convert-single-referral', 'referral_id' => $referral->referral_id ) ) ) . '" class="delete">' . __( 'Convert', 'affiliate-wp-pay-as-points' ) . '</a></span>';
	
	return $action_links;
	
	}
	
	///////////////// Output Frontend Actions ///////////////
	
	// Add content before the front end referrals dashboard
	public function wcpr_before_referrals_table($affiliate_id) {
	
		if( ( ((self::$instance->the_settings['pap_enable_auto_convert']) && (self::$instance->the_settings['pap_auto_convert_user_changeable'])) || !self::$instance->the_settings['pap_enable_auto_convert']) && (self::$instance->the_settings['pap_manual_convert_user'])) {
		
			$referrals = affiliate_wp()->referrals->get_referrals( array( 'affiliate_id' => $affiliate_id, 'status' => 'unpaid', 'number' => -1 ) );
			$number_unpaid = count($referrals);
			
			if($number_unpaid>=1) {
			
			$link_text = __( 'Convert all unpaid commissions to loyalty points - click here', 'affiliate-wp-pay-as-points' );
			$link_text = apply_filters('wcpr-convert-all-link', $link_text, $affiliate_id);
		
			$content = '<div><span class="wcpr-referral_pay_all_link button"><a href="' . esc_url( add_query_arg( array( 'action' => 'wcpr-convert-all-front-end', 'affiliate_id' => $affiliate_id ) ) ) . '" class="convert">'.$link_text.'</a></span></div>';
			
			} else {
			$content = '';
			}
	
			echo $content;
		}
	
	}
	
	// Add front end referral table colum head
	public function wcpr_frontend_referral_column_ths() {
	
		if( ( ((self::$instance->the_settings['pap_enable_auto_convert']) && (self::$instance->the_settings['pap_auto_convert_user_changeable'])) || !self::$instance->the_settings['pap_enable_auto_convert']) && (self::$instance->the_settings['pap_manual_convert_user'])) {
		
			$header_text = __( 'Convert to points', 'affiliate-wp-pay-as-points' );
			$header_text = apply_filters('wcpr-convert-table-header', $header_text);
	
			$content = '<th>'.$header_text.'</th>';
	
			echo $content;
			
		}
	
	}
	
	// Add front end referral table cell with convert link
	public function wcpr_frontend_referral_column_tds($referral) {
	
		$referral_id = $referral->referral_id;
	
		if( ( ((self::$instance->the_settings['pap_enable_auto_convert']) && (self::$instance->the_settings['pap_auto_convert_user_changeable'])) || !self::$instance->the_settings['pap_enable_auto_convert']) && (self::$instance->the_settings['pap_manual_convert_user'])) {
		
			$referral = affwp_get_referral($referral_id);
			$status = $referral->status;
			
			if($status=='unpaid') {
			
				$link_text = __( 'Convert to points', 'affiliate-wp-pay-as-points' );
				$link_text = apply_filters('wcpr-convert-single-link', $link_text, $referral_id);
		
				$content = '<td class="wcpr-referral_unpaid_link"><span><a href="' . esc_url( add_query_arg( array( 'action' => 'wcpr-convert-single-front-end', 'referral_id' => $referral_id ) ) ) . '" class="button convert">' . $link_text . '</a></span></td>';
			
			} elseif($status=='paid') {
			
				$content = '<td class="wcpr-referral_paid_link"><span>'.ucwords($status).'</span></td>';
			
			}
	
			echo $content;
		}
	
	}
	
	// Add front end settings HTML
	public function front_end_settings_output($affiliate_id, $user_id) {
		if($this->check_all_auto_disabled_settings($affiliate_id)) {
			if((self::$instance->the_settings['pap_enable_auto_convert']) && (self::$instance->the_settings['pap_auto_convert_user_changeable']) ) {
			
				$this->get_settings();
			
				ob_start(); ?>
				
				<!--<h4><?php _e( 'Payout Settings', 'affiliate-wp-pay-as-points' ); ?></h4>-->
				<div class="affwp-wrap affwp-send-notifications-wrap">
					<input id="pap_frontend_auto_convert" type="checkbox" name="pap_frontend_auto_convert" value="1" <?php checked( $this->pap_frontend_auto_convert, '1' ); ?>/>
					<label for="wcpr-enable-auto-convert"><?php _e( 'Automatically convert all referrals to loyalty points', 'affiliate-wp-pay-as-points' ); ?></label>
				</div>
				
				<?php			
				$content = ob_get_contents();			
				ob_end_clean();
				echo $content;
			
			}
		}

	}
	
	
	///////////////// Notices ///////////////
	
	
	// Admin notices
	public function admin_notices() {
		//self::$instance->points_integration->count_referrals_processed;
		//self::$instance->points_integration->pending_admin_notice;
		
		if( (isset(self::$instance->points_integration->pending_admin_notice)) && (!empty(self::$instance->points_integration->pending_admin_notice)) ) {
	
			if(self::$instance->points_integration->count_referrals_processed >1) { 
				$referral_p = 's';
			} else {
				$referral_p = '';
			}
			$this->admin_notice = self::$instance->points_integration->count_referrals_processed.' referral'.$referral_p.' '.self::$instance->points_integration->pending_admin_notice;
		
			?>
			<div class="updated">
				<p><?php echo $this->admin_notice; ?></p>
			</div>
			<?php
		}
	}
	
	// Front end notices
	public function front_end_notices($message) {
		if($message=='front_end_all') {
			$message_string = 'All converted';
		} elseif($message=='front_end_one') {
			$message_string = 'One converted';
		} elseif($message=='validation_error') {
			$message_string = 'Validation error';
		} elseif($message=='profile_updated') {
			$message_string = 'Settings updated';
		}
		wc_add_notice( $message_string, 'success' );
	}
	
	
	///////////// Specific processing tasks /////////////
	
	
	// Process admin actions
	public function process_admin_actions() {
	
		//if(isset($_REQUEST['action'])) {
		
			if( (isset($_REQUEST['action2'])) && ($_REQUEST['action2'] == 'wcpr-convert-all-affiliates-bulk') ) {
				$affiliates = $_REQUEST['affiliate_id'];
					foreach($affiliates as $key => $affiiate_id) {
						$this->process_all_unpaid_referrals($affiiate_id);
					}
			}
			
			if( (isset($_REQUEST['action'])) && ($_REQUEST['action'] == 'wcpr-convert-all-affiliates') && ($_REQUEST['affiliate_id']) ) {
				$this->process_all_unpaid_referrals($_REQUEST['affiliate_id']);
			}
			
			if( (isset($_REQUEST['action'])) && ($_REQUEST['action'] == 'wcpr-convert-referrals-bulk') ) {
				$referrals = $_REQUEST['referral_id'];
					foreach($referrals as $key => $referral_id) {
						$this->process_referrals($referral_id, 'credit', 'paid');
					}
			}
			
			if( (isset($_REQUEST['action'])) && ($_REQUEST['action'] == 'wcpr-convert-single-referral') && ($_REQUEST['referral_id']) ) {
				$this->process_referrals($_REQUEST['referral_id'], 'credit', 'paid');				
			}
			
		//}	
		
	}
	
	// Process the front end actions
	public function process_front_end_actions($data = '') {

		if(is_array($data)) $_REQUEST = $data;
		$this->get_settings();
	 
		if( (isset($_REQUEST['action'])) && ($_REQUEST['action'] == 'wcpr-convert-all-front-end') && (isset($_REQUEST['affiliate_id'])) ) {
		
			if ($this->validate_front_end_request($_REQUEST['affiliate_id'],'')) {
				$this->process_all_unpaid_referrals($_REQUEST['affiliate_id']);
				$this->front_end_notices('front_end_all');	
			} else {
				$this->front_end_notices('validation_error');
			}
			
		}
		
		if( (isset($_REQUEST['action'])) && ($_REQUEST['action'] == 'wcpr-convert-single-front-end') && (isset($_REQUEST['referral_id'])) ) {
		
			if ($this->validate_front_end_request('',$_REQUEST['referral_id'])) {
				$this->process_referrals($_REQUEST['referral_id'], 'credit', 'paid');
				$this->front_end_notices('front_end_one');	
			} else {
				$this->front_end_notices('validation_error');
			}
						
		}	
		
		
		if( (isset($_REQUEST['affwp_action'])) && ($_REQUEST['affwp_action'] == 'update_profile_settings')) {
			
			//echo '<pre>'; print_r(self::$instance->the_settings); echo '</pre>';

			if((self::$instance->the_settings['pap_enable_auto_convert']) && (self::$instance->the_settings['pap_auto_convert_user_changeable']) ) {
			
				//echo '<pre>'; print_r($_REQUEST); echo '</pre>';
				
				if( (isset($_REQUEST['pap_frontend_auto_convert'])) && ($_REQUEST['pap_frontend_auto_convert'] == '1')) {
				$status = '1';
				} else {
				$status = '0';
				}
		
				if(update_user_meta( get_current_user_id(), 'pap_frontend_auto_convert', $status )) {			
				
				}
			
			}
		

		}
		
	
	}
	
	// Validate that the front end user owns the referral
	public function validate_front_end_request($affiliate_id='', $referral_id='') {
		if($affiliate_id!='') {
			$user_id = affwp_get_affiliate_user_id($affiliate_id);
		} elseif($referral_id!='') {
			$referral = affwp_get_referral($referral_id);
			$user_id = affwp_get_affiliate_user_id($referral->affiliate_id);
		}
		
		return($user_id == get_current_user_id());
		
	}
	
	
	// Automatic conversions based on order ID. Only required by the function above now.
	public function auto_convert_mla_referral($referral_id) {
		
		$referral = affwp_get_referral( $referral_id );
		$affiliate_id = $referral->affiliate_id;
		$user_id = affwp_get_affiliate_user_id( $affiliate_id );
		$this->front_end_settings('', $user_id);
		
		if(self::$instance->the_settings['pap_enable_auto_convert']) {
					
			// Check all auto disabled settings
			if($this->check_all_auto_disabled_settings($affiliate_id)) {
			// Check user changeable is still enabled
				if( (self::$instance->the_settings['pap_auto_convert_user_changeable']) && ($this->pap_frontend_auto_convert=='1') ) {
					
					$this->process_all_unpaid_referrals($affiliate_id);
				
				} elseif( (self::$instance->the_settings['pap_auto_convert_user_changeable']) && ($this->pap_frontend_auto_convert!='1') ) {
					
					//$this->process_all_unpaid_referrals($affiliate_id);
				
				} else {
					
					
					$this->process_all_unpaid_referrals($affiliate_id);
				}
			}			
			
		}

	}
	
	// Automatically converts after completed referral
	public function auto_convert_from_complete_referral($referral_id, $referral, $reference) {
		$this->auto_convert_after_transaction($reference);
	}
	
	// Automatic conversions based on order ID. Only required by the function above now.
	public function auto_convert_after_transaction($order_id) {
	
		if($order_id) {
		
			$this->front_end_settings($order_id);
			
			if(self::$instance->the_settings['pap_enable_auto_convert']) {

				// Get affiliate ID from order referrals
				$referrals = affiliate_wp()->referrals->get_referrals( array( 'reference' => $order_id, 'status' => 'unpaid', 'number' => -1 ) );
				$affiliate_id = $referrals[0]->affiliate_id;
				
				  // Check all auto disabled settings
				  if($this->check_all_auto_disabled_settings($affiliate_id)) {
				  // Check user changeable is still enabled
					  if( (self::$instance->the_settings['pap_auto_convert_user_changeable']) && ($this->pap_frontend_auto_convert=='1') ) {
						  
						  $this->process_all_unpaid_referrals($affiliate_id);
					  
					  } elseif( (self::$instance->the_settings['pap_auto_convert_user_changeable']) && ($this->pap_frontend_auto_convert!='1') ) {
						  
						  //$this->process_all_unpaid_referrals($affiliate_id);
					  
					  } else {
						  
						  
						  $this->process_all_unpaid_referrals($affiliate_id);
					  }
				  }
				
			}
		
		}

	}
		
	// Check all disabled auto convert settings
	public function check_all_auto_disabled_settings($affiliate_id) {
		if( 
		($this->tiered_auto_convert_check($affiliate_id)) &&
		($this->user_role_auto_convert_check($affiliate_id)) &&
		($this->group_auto_convert_check($affiliate_id))
		) 
		
		// user role check covers both roles and groups
		
		return TRUE;
	}
	
	
	///////////// Tier related functions /////////////
	
	
	// Get the rates for 'Tiered Affiliate rates'
	public static function get_tiered_rates() {
		$rates = affiliate_wp()->settings->get( 'rates', array() );
		return apply_filters( 'affwp_tiered_rates', array_values( $rates ) );
	}
	
	// Check if affiliate is within an enabled tier for auto convert
	public function tiered_auto_convert_check($affiliate_id) {
		
	if(class_exists('AffiliateWP_Tiered_Rates')) {
		//echo $affiliate_id;
		//$user_id = get_current_user_id();
		//if(empty($affiliate_id)) $affiliate_id = affwp_get_affiliate_id($user_id);
		
		$rates = $this->get_tiered_rates();
		//$rates = array_reverse( $rates );
		$earnings  = affwp_get_affiliate_earnings( $affiliate_id, false );
		$referrals = affwp_get_affiliate_referral_count( $affiliate_id );
		
		// Sort the array. Not needed ?
		$php_version = phpversion();
		if($php_version>='5.3') {			
			usort($rates, function($a, $b) {
    			return $b['rate'] - $a['rate'];
			});
		}
		
		/*print_r($rates);
		echo 'Referrals='.$referrals.'<br>';*/
		
		// Loop through the rates to see if any apply
		foreach( $rates as $tiered_rate ) {
			
			$setting_key = 'pap_'.'tier_convert'.$tiered_rate['type'].'_'.$tiered_rate['threshold']; 
			$tier_setting = self::$instance->the_settings[$setting_key];
			
			/*echo 'Tier Setting='.$tier_setting.'<br>'; 
			echo 'Setting Key='.$setting_key.'<br>';
			echo 'Type='.$tiered_rate['type'].'<br>';
			echo 'Rate='.$tiered_rate['threshold'].'<br>';*/
			
					if($tiered_rate['type']=='earnings') {
						if(!isset($previous_earnings_tier_th)) $previous_earnings_tier_th = '99999999999999999999';
							//echo 'Executed';
							//echo 'Previous Threshhold: '.$previous_earnings_tier_th.'<br>';
							if( ($tier_setting!=1) && ($earnings >= $tiered_rate['threshold']) && ($earnings < $previous_earnings_tier_th) ) {
								return TRUE;
							}
							$previous_earnings_tier_th = $tiered_rate['threshold'];
					} elseif($tiered_rate['type']=='referrals') {
						if(!isset($previous_referrals_tier_th)) $previous_referrals_tier_th = '99999999999999999999';
							//echo 'Executed';
							//echo 'Previous Threshhold: '.$previous_referrals_tier_th.'<br>';
							if( ($tier_setting!=1) && ($referrals >= $tiered_rate['threshold']) && ($referrals < $previous_referrals_tier_th) ) {
								return TRUE;
							}
							$previous_referrals_tier_th = $tiered_rate['threshold'];
					}

			//$tiered_rate['type'] | earnings   or   referrals
			//$tiered_rate['threshold']
			//$tiered_rate['rate']

		}
		
		return FALSE;
		//print_r($rates);
	
	// End of check if tier plugin enabled
	} else {
		return TRUE;
	}
	
	}
	
	
	///////////// Affiliate Group Functions
	
	// Get all active affiliate groups
	public static function get_active_affiliate_groups() {
		$active_groups = AffiliateWP_Affiliate_Groups_Base::get_all_active_affiliate_groups();
		return $active_groups;
	}
	
	
	// Check if affiliate has an enabled group for auto convert
	public function group_auto_convert_check($affiliate_id) {
		
		if(class_exists('AffiliateWP_Affiliate_Groups')) {
		
		  $groups = get_active_affiliate_groups();
		  foreach( $groups as $key => $data) {
			  
			  $setting_key = 'pap_'.'group_'.$key;
			  $group_setting = self::$instance->the_settings[$setting_key];
			  
			  if($group_setting!='1') {
			  
				  $affiliate_groups = get_affiliates_active_groups($affiliate_id);
				  
				  if( !empty($affiliate_groups) ) {
				  
					foreach($affiliate_groups as $id => $name) {
						
						if($key == $id) return TRUE;
						
					}
				  
				  }else{
					  
					  return TRUE;
					  
				  }
			  
			  }
		  }
		
		}else {
			
			return TRUE;
			
		}
		
		
	}
	
	///////////// User Role Functions /////////////
	
	// Get all user roles
	public static function get_user_roles() {
	global $wp_roles;	
	if ( ! isset( $wp_roles ) )
		$wp_roles = new WP_Roles();
	
	return $wp_roles->get_names();
	}
	
	// Get affiliates user roles
	public function get_affiliate_user_roles($affiliate_id) {
		$user_id = affwp_get_affiliate_user_id($affiliate_id);
		$user = get_userdata( $user_id );
    	$user_roles = $user->roles;
		
		return $user_roles;

	}
	
	// Check if affiliate has an enabled user role for auto convert
	public function user_role_auto_convert_check($affiliate_id) {
		
		$roles = $this->get_user_roles();
		foreach( $roles as $key => $name) {
			
			$setting_key = 'pap_'.'user_role_'.$key;
			$user_role_setting = self::$instance->the_settings[$setting_key];
			
			if($user_role_setting!='1') {
			
				$affiliate_user_roles = $this->get_affiliate_user_roles($affiliate_id);
				
				foreach($affiliate_user_roles as $role) {
					if($key == $role) return TRUE;
				}
			
			}
		}
	}

	///////////////////// Actually process the Conversions ////////////////////
	
	
	// Process referrals based on affiliate ID
	public function process_all_unpaid_referrals($affiliate_id) {
		$referrals = affiliate_wp()->referrals->get_referrals( array( 'affiliate_id' => $affiliate_id, 'status' => 'unpaid', 'number' => -1 ) );
		
		if($referrals) {
			$referrals_array = array();
			foreach($referrals as $referrals) {
				array_push($referrals_array,$referrals->referral_id);	
			}
		}
		
		//$user_id = affwp_get_affiliate_user_id($affiliate_id);
		if(isset($referrals_array)) {
			$user_data = get_userdata(affwp_get_affiliate_user_id($affiliate_id));
			
			$this->pending_admin_notice = "for affiliate '".$user_data->nickname."' successfully converted to points";
			$this->process_referrals($referrals_array, 'credit' ,'paid');
		}
		
		
		/* Object Reference
		To access: $referrals->referral_id;
		
		[referral_id]
		[affiliate_id]
		[visit_id]
		[description]
		[status]
		[amount]
		[currency]
		[custom]
		[context]
		[reference]
		[products]
		[date] 
		*/		
	}
		
	// Process Conversions. Accepts an array of referral ID's or a single ID
	public function process_referrals($referrals, $debit_credit, $referral_status='') {

		if(self::$instance->points_integration) {
		
			if(!is_array($referrals)) {
				if(is_numeric($referrals)) {
				$referrals=array($referrals);
				} else {
				return;
				}
			}
	
				foreach($referrals as $key => $value) {
					$referral = affwp_get_referral($value);
					$user_id = affwp_get_affiliate_user_id($referral->affiliate_id);		
					$referral_amount = $referral->amount;
					
					$points = self::$instance->points_integration->calculate_points($referral_amount);
					
					// Process the points	
					if( ($debit_credit=='credit') && ($referral->status=='unpaid') ) {	
						
						self::$instance->points_integration->process_points($value, $points, $user_id, $debit_credit);
						if(self::$instance->the_settings['pap_mark_as_paid']=='1') affwp_set_referral_status($value, 'paid');
						
					} elseif( ($debit_credit=='debit') && ($referral->status!='unpaid') ) {
						
						self::$instance->points_integration->process_points($value, $points, $user_id, $debit_credit);
						if($referral_status=='unpaid') affwp_set_referral_status($value, 'unpaid');
						
					}
	
				}	
		
		}
	
	}
	
	
	//////////////// Other //////////////////
	
	
	// Checks if a third party plugin exists.
	public static function check_third_party_plugin($main_class) {
		if( class_exists( $main_class ) ) {
		return true;
		} else {
		return false;
		}
	}
	
	// PAP test
	public function pap_test() {
		//$this->tiered_auto_convert_check();
		//$this->auto_convert_after_transaction('4416');
		
		// Not related to this plugin
		/*$order = new WC_Order('4421');
		$order_shipping_methods = $order->get_shipping_methods();
		$shipping_method = $order_shipping_methods[key($order_shipping_methods)]['item_meta'];
		$method_id = $shipping_method['method_id']['0'];
		$method_cost = $shipping_method['cost']['0'];
		$method_taxes = unserialize($shipping_method['taxes']['0']);
		$method_taxes = $method_taxes['1'];*/
		
		//$roles = $this->get_user_roles();
		//print_r($roles);
		
		/*$user_id = get_current_user_id();
		$user = get_userdata( $user_id );
    	$user_roles = $user->roles;
		print_r($user_roles);*/
		
		//$this->user_role_auto_convert_check('1');
		
	}
		
	// Get template part. Used ?
	public function custom_get_template_part($atts) {
	extract(shortcode_atts(array(
		  'part' => '',
		  'query' => '',
	   ), $atts));
	   
	   if($query == 'test')  {
	   	$order_id = '3418'; 
		
		$this->auto_convert_after_transaction('', '', $order_id);
	   
	   }
	   	   
	}
	
	// Get plugin version
	/*public function get_pap_version() {
		$plugin_data = get_plugin_data( __FILE__ );
		$plugin_version = $plugin_data[‘Version’];
		return $plugin_version;
	}*/
	
	
} // End of class


add_action( 'init', 'AffiliateWP_PAP_instance' );

// Activation & dependency check
function AffiliateWP_PAP_instance() {
	
	$activation_config = array(
		'plugin_name' => 'AffiliateWP - Pay as Points',
		'plugin_path' => plugin_dir_path( __FILE__ ),
		'plugin_file' => basename( __FILE__ ),
		'plugin_dependencies' => array(
			'Affiliate_WP' => array(
				'name' => 'AffiliateWP',
				'plugin_folder_file' => 'affiliate-wp/affiliate-wp.php',
				'url' => 'https://affiliatewp.com/ref/613/'
			)
		),
		
	);
	
	require_once 'includes/class-activation.php';
	$activation = new AffiliateWP_PaP_Activation( $activation_config );
	
	// If all dependencies are fine return instance
	if($activation->check_dependencies()) {
		return AffiliateWP_PAP::instance();
		register_activation_hook( __FILE__, array( 'AffiliateWP_PAP', 'activate_plugin' ) );
	}
	
}

register_deactivation_hook( __FILE__, array( 'AffiliateWP_PAP', 'deactivate_plugin' ) );

/*function AffiliateWP_PAP_instance() {
  return AffiliateWP_PAP::instance();
}*/

//AffiliateWP_PAP_instance();

// Clear license data
	/*$options = affiliate_wp()->settings->get_all();
	unset($options['pap_license_status']);
	unset($options['pap_license_key']);
	update_option( 'affwp_settings', $options );*/
	
// Register Activation and Deactivation Hooks


// Functions and actions required on plugin load
require_once plugin_dir_path( __FILE__ ) . 'functions.php';
?>