<?php
/**
 * Traits: Shared Logic for AffiliateWP-grouped Fields
 *
 * @package     AffiliateWP Affiliate Forms for Gravity Forms
 * @subpackage  Core
 * @copyright   Copyright (c) 2021, Sandhills Development, LLC
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       1.1
 */
namespace AffiliateWP_AFGF\Traits;

/**
 * Represents logic shared by all AFGF-registered fields intended
 * to be included in the "AffiliateWP Fields" group.
 *
 * @since 1.1
 */
trait AffiliateWP_Grouped_Field {

	/**
	 * Field group slug.
	 *
	 * @since 1.1
	 * @var   string
	 */
	private $field_group = 'affwp_fields';

	/**
	 * Sets the field group.
	 *
	 * @since 1.1
	 *
	 * @return array Form editor button data.
	 */
	public function get_form_editor_button() {
		return array(
			'group' => $this->field_group,
			'text'  => $this->get_form_editor_field_title(),
		);
	}

	/**
	 * Adds the field button to the specified group.
	 *
	 * @since 1.1
	 *
	 * @param array $field_groups The field groups containing the individual field buttons.
	 * @return array (Maybe) modified field groups with fields included.
	 */
	public function add_button( $field_groups ) {
		$field_groups = $this->maybe_add_field_group( $field_groups );

		return parent::add_button( $field_groups );
	}

	/**
	 * Adds the custom field group if it doesn't already exist.
	 *
	 * @since 1.1
	 *
	 * @param array $field_groups The field groups containing the individual field buttons.
	 * @return array (Maybe) modified field groups array.
	 */
	public function maybe_add_field_group( $field_groups ) {
		foreach ( $field_groups as $field_group ) {
			if ( $field_group['name'] == $this->field_group ) {

				return $field_groups;
			}
		}

		$field_groups[] = array(
			'name'   => $this->field_group,
			'label'  => __( 'AffiliateWP Fields', 'affiliatewp-afgf' ),
			'fields' => array(),
		);

		return $field_groups;
	}

	/**
	 * Sets the default label for a field to its field title.
	 *
	 * @since 1.1
	 *
	 * @return string JavaScript enqueued via Gravity Forms at render.
	 */
	public function get_form_editor_inline_script_on_page_render() {

		// Set the default field label for the field.
		$script = sprintf( "function SetDefaultValues_%s(field) {field.label = '%s';}",
			$this->type,
			$this->get_form_editor_field_title()
		);

		return $script . PHP_EOL;
	}
}
