<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

final class Affiliatewp_WooWallet {

    /**
     * The single instance of the class.
     *
     * @var Affiliatewp_WooWallet
     * @since 1.0.0
     */
    protected static $_instance = null;

    /**
     * Plugin license API class.
     * @var Woo_Wallet_License
     */
    public $licence = null;

    /**
     * Main instance
     * @return class object
     */
    public static function instance() {
        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    /**
     * Class constructor
     */
    public function __construct() {
        if (class_exists('Affiliate_WP')) {
            $this->define_constants();
            $this->includes();
            add_action('admin_init', array($this, 'admin_init'));
        } else {
            add_action('admin_notices', array($this, 'admin_notices'), 15);
        }
    }

    /**
     * Constants define
     */
    private function define_constants() {
        $this->define('AFFILIATEWP_WOO_WALLET_ABSPATH', dirname(AFFILIATEWP_WOO_WALLET_PLUGIN_FILE) . '/');
        $this->define('AFFILIATEWP_WOO_WALLET_PLUGIN_FILE', plugin_basename(AFFILIATEWP_WOO_WALLET_PLUGIN_FILE));
        $this->define('AFFILIATEWP_WOO_WALLET_PLUGIN_NAME', 'AffiliateWP - WooWallet');
        $this->define('AFFILIATEWP_WOO_WALLET_PLUGIN_SERVER_URL', 'https://woowallet.in/');
        $this->define('AFFILIATEWP_WOO_WALLET_PLUGIN_TOKEN', 'affiliatewp-woo-wallet');
        $this->define('AFFILIATEWP_WOO_WALLET_VERSION', '1.0.1');
    }

    /**
     * 
     * @param string $name
     * @param mixed $value
     */
    private function define($name, $value) {
        if (!defined($name)) {
            define($name, $value);
        }
    }

    /**
     * Check request
     * @param string $type
     * @return bool
     */
    private function is_request($type) {
        switch ($type) {
            case 'admin' :
                return is_admin();
            case 'ajax' :
                return defined('DOING_AJAX');
            case 'cron' :
                return defined('DOING_CRON');
            case 'frontend' :
                return (!is_admin() || defined('DOING_AJAX') ) && !defined('DOING_CRON');
        }
    }

    /**
     * load plugin files
     */
    public function includes() {
        if ($this->is_request('admin')) {
            include_once(AFFILIATEWP_WOO_WALLET_ABSPATH . 'includes/class-woo-wallet-license.php');
            include_once( AFFILIATEWP_WOO_WALLET_ABSPATH . 'includes/class-affiliatewp-woo-wallet-admin.php' );
        }
        if ($this->is_request('frontend')) {
            include_once( AFFILIATEWP_WOO_WALLET_ABSPATH . 'includes/class-affiliatewp-woo-wallet-frontend.php' );
        }
    }

    public function admin_init() {
        $plugin = array(
            'plugin_server_url' => AFFILIATEWP_WOO_WALLET_PLUGIN_SERVER_URL,
            'plugin_token' => AFFILIATEWP_WOO_WALLET_PLUGIN_TOKEN,
            'version' => AFFILIATEWP_WOO_WALLET_VERSION
        );
        $this->licence = new Woo_Wallet_License($plugin);
    }

    /**
     * Plugin url
     * @return string path
     */
    public function plugin_url() {
        return untrailingslashit(plugins_url('/', AFFILIATEWP_WOO_WALLET_PLUGIN_FILE));
    }

    /**
     * Text Domain loader
     */
    public function load_plugin_textdomain() {
        $locale = is_admin() && function_exists('get_user_locale') ? get_user_locale() : get_locale();
        $locale = apply_filters('plugin_locale', $locale, 'affiliatewp-woo-wallet');

        unload_textdomain('affiliatewp-woo-wallet');
        load_textdomain('affiliatewp-woo-wallet', WP_LANG_DIR . '/affiliatewp-woo-wallet/affiliatewp-woo-wallet-' . $locale . '.mo');
        load_plugin_textdomain('affiliatewp-woo-wallet', false, plugin_basename(dirname(AFFILIATEWP_WOO_WALLET_PLUGIN_FILE)) . '/languages');
    }
    
    public function deactivation_hook(){
        if(!is_null(Affiliatewp_woo_wallet()->licence)){
            Affiliatewp_woo_wallet()->licence->uninstall();
        }
    }

    /**
     * Display admin notice
     */
    public function admin_notices() {
        echo '<div class="error"><p>';
        _e('WooCommerce Wallet - AffiliateWP plugin requires <a href="https://affiliatewp.com/">AffiliateWP</a> plugins to be active!', 'affiliatewp-woo-wallet');
        echo '</p></div>';
    }

}
