<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Affiliatewp_WooWallet_Frontend {

    public function __construct() {
        add_action('affwp_affiliate_dashboard_before_submit', array($this, 'enable_woo_wallet_credit_output'), 10, 2);
        add_action('affwp_update_affiliate_profile_settings', array($this, 'save_profile_settings'), 10, 1);
    }

    public function enable_woo_wallet_credit_output($affiliate_id, $user_id) {
        $woo_wallet_credit_enabled = affiliate_wp()->settings->get('woo-wallet');

        if (!$woo_wallet_credit_enabled) {
            return;
        }

        $global_woo_wallet_credit_enabled = affiliate_wp()->settings->get('woo-wallet-all-affiliates');
        if ($global_woo_wallet_credit_enabled) {
            return;
        }

        $change_payment_method = affiliate_wp()->settings->get('woo-wallet-change-payment-method');
        if (!$change_payment_method) {
            return;
        }

        $affiliate_store_credit_enabled = affwp_get_affiliate_meta($affiliate_id, 'woo_wallet_credit_enabled', true);
        ?>

        <div class="affwp-wrap affwp-sc-enable-woo-wallet-credit-wrap">
            <label for="affwp_sc_enable_woo_wallet_credit">
                <input type="checkbox" name="affwp_sc_enable_woo_wallet_credit" id="affwp_sc_enable_woo_wallet_credit" value="1" <?php checked($affiliate_store_credit_enabled, true); ?> />
                <?php _e('Enable payout via WooWallet credit', 'affiliatewp-store-credit'); ?>
            </label>
        </div>

        <?php
    }

    public function save_profile_settings($data) {

        $change_payment_method = affiliate_wp()->settings->get('woo-wallet-change-payment-method');

        if (!$change_payment_method) {
            return;
        }

        $enable_store_credit = isset($data['affwp_sc_enable_woo_wallet_credit']) ? $data['affwp_sc_enable_woo_wallet_credit'] : '';

        if ($enable_store_credit) {
            affwp_update_affiliate_meta($data['affiliate_id'], 'woo_wallet_credit_enabled', $enable_store_credit);
        } else {
            affwp_delete_affiliate_meta($data['affiliate_id'], 'woo_wallet_credit_enabled');
        }
    }

}

new Affiliatewp_WooWallet_Frontend();
