<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Affiliatewp_WooWallet_Admin {

    public function __construct() {
        add_filter('woo_wallet_extensions_settings_sections', array($this, 'woo_wallet_extensions_settings_sections'));
        add_filter('woo_wallet_extensions_settings_filds', array($this, 'woo_wallet_extensions_settings_filds'));
        add_action('update_option__wallet_settings_extensions_affiliatewp_woo_wallet_license', array($this, 'extensions_affiliatewp_license_check'), 10, 3);
        if (get_option('affiliatewp_woo_wallet_license_activated') != 'Activated') {
            add_action('admin_notices', array($this, 'license_inactive_notice'));
        }
        
        add_filter('affwp_settings_tabs', array($this, 'register_settings_tab'));
        add_filter('affwp_settings', array($this, 'register_settings'));

        add_action('affwp_set_referral_status', array($this, 'process_payout'), 10, 3);
        add_action('affwp_process_update_referral', array($this, 'process_payout'), 0);
        add_action('affwp_add_referral', array($this, 'process_payout'));
    }
    
    public function woo_wallet_extensions_settings_sections($sections) {
        $sections[] = array(
            'id' => '_wallet_settings_extensions_affiliatewp_woo_wallet_license',
            'title' => __('AffiliateWP License', 'affiliatewp-woo-wallet'),
            'icon' => 'dashicons-tickets-alt'
        );
        return $sections;
    }
    
    public function woo_wallet_extensions_settings_filds($settings_fields) {
        $settings_fields['_wallet_settings_extensions_affiliatewp_woo_wallet_license'] = array(
            array(
                'name' => 'licence_key',
                'label' => __('API License Key', 'affiliatewp-woo-wallet'),
                'desc' => __('Enter License Key', 'affiliatewp-woo-wallet'),
                'type' => 'text',
                'default' => ''
            ),
            array(
                'name' => 'license_product_id',
                'label' => __('API Product ID', 'woo-wallet-withdrawal'),
                'desc' => __('Enter License product ID', 'woo-wallet-withdrawal'),
                'type' => 'text',
                'default' => ''
            ),
            array(
                'name' => 'is_activate',
                'label' => __('Deactivate API License Key', 'affiliatewp-woo-wallet'),
                'desc' => __('Deactivates an API License Key so it can be used on another blog.', 'affiliatewp-woo-wallet'),
                'type' => 'checkbox',
            ),
            array(
                'name' => 'nonce_rand',
                'type' => 'rand'
            )
        );
        return $settings_fields;
    }
    
    public function extensions_affiliatewp_license_check($old_value, $value, $option) {
        if (!empty($value)) {
            $args = array(
                'product_id' => $value['license_product_id'],
                'api_key' => $value['licence_key'],
                'activation_status' => $value['is_activate'] ? $value['is_activate'] : 'off'
            );
            if (!is_null(Affiliatewp_woo_wallet()->licence)) {
                Affiliatewp_woo_wallet()->licence->manage_api_license($args);
            }
        }
    }

    public function license_inactive_notice() {
        if (!current_user_can('manage_options')) {
            return;
        }
        if (isset($_GET['page']) && 'woo-wallet-extensions' == $_GET['page']) {
            return;
        }
        ?>
        <div class="notice notice-error is-dismissible">
            <p><?php printf(__('%sClick here%s to activate WooCommerce Wallet - AffiliateWP license key to receive updates and support.', 'affiliatewp-woo-wallet'), '<a href="' . esc_url(admin_url('admin.php?page=woo-wallet-extensions&activewwtab=_wallet_settings_extensions_affiliatewp_woo_wallet_license')) . '">', '</a>'); ?></p>
        </div>
        <?php
    }

    public function register_settings_tab($tabs = array()) {
        $tabs['woo-wallet'] = __('WooWallet', 'affiliatewp-woo-wallet');
        return $tabs;
    }

    public function register_settings($settings = array()) {
        $settings['woo-wallet'] = array(
            'woo-wallet' => array(
                'name' => __('Enable WooWallet Credit', 'affiliatewp-woo-wallet'),
                'desc' => __('Check this box to enable WooWallet credit for referrals.', 'affiliatewp-woo-wallet'),
                'type' => 'checkbox'
            ),
            'woo-wallet-all-affiliates' => array(
                'name' => __('Enable For All Affiliates?', 'affiliatewp-woo-wallet'),
                'desc' => __('Check this box to allow all affiliates to receive WooWallet credit.', 'affiliatewp-woo-wallet'),
                'type' => 'checkbox'
            ),
            'woo-wallet-change-payment-method' => array(
                'name' => __('Enable WooWallet Credit Opt-In', 'affiliatewp-woo-wallet'),
                'desc' => __('Check this box to allow affiliates to enable payout via WooWallet credit from their affiliate dashboard.', 'affiliatewp-woo-wallet'),
                'type' => 'checkbox',
            ),
        );

        return $settings;
    }

    public function process_payout($referral_id = 0, $new_status = '', $old_status = '') {
        if (!$referral_id || 0 === $referral_id) {
            return;
        }
        $referral = affwp_get_referral($referral_id);
        if (!$this->can_receive_woo_wallet_credit($referral->affiliate_id)) {
            return;
        }
        if (!isset($new_status) || '' === $new_status) {
            return;
        }
        if (!isset($old_status) || '' === $old_status) {
            return;
        }
        if ('paid' === $new_status) {
            $this->add_payment($referral_id);
        } elseif (( 'paid' === $old_status ) && ( 'unpaid' === $new_status )) {
            $this->remove_payment($referral_id);
        }
    }

    private function can_receive_woo_wallet_credit($affiliate_id) {
        $ret = false;
        // Get global setting.
        $global_woo_wallet_credit_enabled = affiliate_wp()->settings->get('woo-wallet-all-affiliates');

        if ($global_woo_wallet_credit_enabled) {
            $ret = true;
        } else {
            $ret = affwp_get_affiliate_meta($affiliate_id, 'woo_wallet_credit_enabled', true);
        }
        return $ret;
    }

    private function add_payment($referral_id) {
        // Return if the referral ID isn't valid
        if (!is_numeric($referral_id)) {
            return;
        }
        // Get the referral object
        $referral = affwp_get_referral($referral_id);
        // Get the user id
        $user_id = affwp_get_affiliate_user_id($referral->affiliate_id);
        if (function_exists('woo_wallet')) {
            woo_wallet()->wallet->credit($user_id, $referral->amount, __('New commission received referal #') . $referral->ID);
        }
    }

    private function remove_payment($referral_id) {
        // Return if the referral ID isn't valid
        if (!is_numeric($referral_id)) {
            return;
        }
        // Get the referral object
        $referral = affwp_get_referral($referral_id);
        // Get the user id
        $user_id = affwp_get_affiliate_user_id($referral->affiliate_id);
        if (function_exists('woo_wallet')) {
            woo_wallet()->wallet->debit($user_id, $referral->amount, __('Withdraw commission for referal #') . $referral->ID);
        }
    }

}

new Affiliatewp_WooWallet_Admin();
