<?php

/**
 * Plugin Name: WooCommerce Wallet - AffiliateWP
 * Plugin URI: https://woowallet.in/
 * Description: Pay AffiliateWP referrals as WooWallet credit.
 * Author: WooWallet
 * Author URI: https://www.linkedin.com/in/subrata-mal/
 * Version: 1.0.1
 * Requires at least: 4.4
 * Tested up to: 5.2
 * 
 * Text Domain: affiliatewp-woo-wallet
 * Domain Path: /languages/
 */
if (!defined('ABSPATH')) {
    exit;
}

// Define AFFILIATEWP_WOO_WALLET_PLUGIN_FILE.
if (!defined('AFFILIATEWP_WOO_WALLET_PLUGIN_FILE')) {
    define('AFFILIATEWP_WOO_WALLET_PLUGIN_FILE', __FILE__);
}
// include dependencies file
if (!class_exists('Woo_Wallet_Dependencies')) {
    include_once dirname(__FILE__) . '/includes/class-woo-wallet-dependencies.php';
}

// Include the main class.
if (!class_exists('Affiliatewp_WooWallet')) {
    include_once dirname(__FILE__) . '/includes/class-affiliatewp-woo-wallet.php';
}
if (!function_exists('Affiliatewp_woo_wallet')) {

    function Affiliatewp_woo_wallet() {
        return Affiliatewp_WooWallet::instance();
    }

}
if (!function_exists('affiliatewp_woowallet_not_active_admin_notices')) {

    function affiliatewp_woowallet_not_active_admin_notices() {
        echo '<div class="error"><p>';
        _e('WooCommerce Wallet - AffiliateWP plugin requires <a href="http://wordpress.org/extend/plugins/woo-wallet/">WooCommerce Wallet</a> plugins to be active!', 'affiliatewp-woo-wallet');
        echo '</p></div>';
    }

}
if (Woo_Wallet_Dependencies::is_woo_wallet_active()) {
    register_deactivation_hook(__FILE__, array(Affiliatewp_woo_wallet(), 'deactivation_hook'));
    $GLOBALS['woo_wallet_coupons'] = Affiliatewp_woo_wallet();
} else {
    add_action('admin_notices', 'affiliatewp_woowallet_not_active_admin_notices', 15);
}