<?php
function get_coinbase_api_credentials() {

    return array(
        'client_id' => '0f1ceac678b1e417c88e22f096ca3e0dcc20caf4a30d01b41ddf5af9abf22ac3',
        'client_secret' => 'ef3cde96bcc220bc25e3ab7f0bb980080a8d5a97b1342da333bd2539b46fb466',
        'access_token' => get_option('affwp_crypto_coinbase_access_token'),
        'token_type' => get_option('affwp_crypto_coinbase_token_type'),
        'expires_in' => get_option('affwp_crypto_coinbase_expires_in'),
        'refresh_token' => get_option('affwp_crypto_coinbase_refresh_token'),
        'scope' => get_option('affwp_crypto_coinbase_scope'),
        'created_at' => get_option('affwp_crypto_coinbase_created_at'),
    );

}

add_shortcode('coinbase_tests', 'coinbase_tests');
function coinbase_tests() {

        //coinbase_reset_access_token();

        $end_point = 'accounts';
        $response = coinbase_get($end_point);

        echo '<pre>';
        print_r($response);
        echo '</pre>';

}

function coinbase_is_authorized() {

    $cred = get_coinbase_api_credentials();

    if ( !empty($cred['access_token']) ) return true;

    return false;
}

function coinbase_get($end_point, $parameters = array() ){

        $cred = get_coinbase_api_credentials();

        // Get cURL resource
        $curl = curl_init();
        $headers[]  = 'Authorization: Bearer '.$cred['access_token'];
        curl_setopt_array($curl, [
            CURLOPT_RETURNTRANSFER => 1,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_URL => 'https://api.coinbase.com/v2/'.$end_point,
        ]);
        // Send the request & save response to $resp
        $resp = curl_exec($curl);
        $response = json_decode($resp, true);

        return $response;

}

function get_redirect_uri() {

    return get_home_url() . '/z-crypto-integrations/';
}

add_shortcode('coinbase_oauth2_widget', 'coinbase_oauth2_widget');
function coinbase_oauth2_widget() {

    // Process authorization
    if ( isset($_GET['code']) && isset($_GET['state']) && $_GET['state'] == 'affiliatewp_crypto' ) :
        coinbase_oauth2_process();
    endif;

    if ( coinbase_is_authorized() ) :
        ?>

        <div>Your Coinbase integration is active!</div>

    <?php
    else:

        $cred = get_coinbase_api_credentials();
        ob_start();
        $url_base = 'https://www.coinbase.com/oauth/authorize';
        $url = add_query_arg(
            array(
                'client_id' => $cred['client_id'],
                'redirect_uri' => urlencode(get_redirect_uri()),
                'response_type' => 'code',
                'state' => 'affiliatewp_crypto',
                'scope' => urlencode('wallet:user:read,wallet:accounts:read')
            ), $url_base);
        ?>
        <a href="<?php echo $url; ?>">Click to authorize</a>
        <?php
        $html = ob_get_contents();
        ob_end_clean();
        return $html;

    endif;

}

function coinbase_oauth2_process() {

    if ( isset($_GET['code']) && isset($_GET['state']) && $_GET['state'] == 'affiliatewp_crypto' ) :

        $cred = get_coinbase_api_credentials();
        // Get cURL resource
        $curl = curl_init();
        // Set some options - we are passing in a useragent too here
        curl_setopt_array($curl, [
            CURLOPT_RETURNTRANSFER => 1,
            CURLOPT_URL => 'https://api.coinbase.com/oauth/token',
            CURLOPT_POST => 1,
            CURLOPT_POSTFIELDS => [
                grant_type => 'authorization_code',
                code => $_GET['code'],
                client_id => $cred['client_id'],
                client_secret => $cred['client_secret'],
                redirect_uri => get_redirect_uri(),
            ]
        ]);
        // Send the request & save response to $resp
        $resp = curl_exec($curl);
        $response = json_decode($resp, true);

        foreach ($response as $meta_key => $meta_value) :

            update_option('affwp_crypto_coinbase_' . $meta_key, $meta_value);

            /* Array
             (
                 [access_token] => ac5fe85c5cc9e0bfa5b97c38ff6e689d11780ee404020266401ada7c54f4028e
                 [token_type] => bearer
                 [expires_in] => 7200
                 [refresh_token] => c26c25112d3d53a118d44ca913db37826eddefe7fcf9ff76d6987afe4931690a
                 [scope] => wallet:user:read wallet:accounts:read
                 [created_at] => 1552534096
             )*/

        endforeach;

        //echo '<pre>';
        //print_r($response);
        //echo '</pre>';

        // Close request to clear up some resources
        curl_close($curl);

    endif;

}

function coinbase_reset_access_token() {

   //if ( isset($_GET['code']) && isset($_GET['state']) && $_GET['state'] == 'affiliatewp_crypto' ) :

        $cred = get_coinbase_api_credentials();
        // Get cURL resource
        $curl = curl_init();
        // Set some options - we are passing in a useragent too here
        curl_setopt_array($curl, [
            CURLOPT_RETURNTRANSFER => 1,
            CURLOPT_URL => 'https://api.coinbase.com/oauth/token',
            CURLOPT_POST => 1,
            CURLOPT_POSTFIELDS => [
                grant_type => 'refresh_token',
                client_id => $cred['client_id'],
                client_secret => $cred['client_secret'],
                refresh_token => 'REFRESH_TOKEN'
            ]
        ]);
        // Send the request & save response to $resp
        $resp = curl_exec($curl);
        $response = json_decode($resp, true);

        foreach ($response as $meta_key => $meta_value) :

            update_option('affwp_crypto_coinbase_' . $meta_key, $meta_value);

            /* Array
             (
                 [access_token] => ac5fe85c5cc9e0bfa5b97c38ff6e689d11780ee404020266401ada7c54f4028e
                 [token_type] => bearer
                 [expires_in] => 7200
                 [refresh_token] => c26c25112d3d53a118d44ca913db37826eddefe7fcf9ff76d6987afe4931690a
                 [scope] => wallet:user:read wallet:accounts:read
                 [created_at] => 1552534096
             )*/

        endforeach;

        echo '<pre>';
        print_r($response);
        echo '</pre>';

        // Close request to clear up some resources
        curl_close($curl);

    //endif;

}