<?php

class AFFWP_CRYPTO_Integrations extends AFFWP_CRYPTO_Integrations_Base {

    protected $plugin_config;
    public $services;
    public $payment_sources;

    public function __construct() {

        $this->plugin_config = affiliate_wp_crypto()->plugin_config;

        $this->includes();
        $this->setup_objects();

        $this->services = $this->get_services();
        $this->payment_sources = $this->get_wallet_sources();

        add_shortcode('integration_testing', array($this, 'integration_testing'));

    }

    public function integration_testing() {

        ob_start();

        echo '<pre>';
        print_r($this->get_payment_sources());
        echo '</pre>';

        $html = ob_get_contents();
        ob_end_clean();

        return $html;

    }

    public function includes() {

        require_once $this->plugin_config['plugin_dir'] . 'plugin_core/integrations/class-cryptoapis.php';
        require_once $this->plugin_config['plugin_dir'] . 'plugin_core/integrations/class-coinmarketcap.php';
        require_once $this->plugin_config['plugin_dir'] . 'plugin_core/integrations/class-coinbase.php';
        //require_once $this->plugin_config['plugin_dir'] . 'plugin_core/integrations/metamask.php';

    }

    private function setup_objects() {

        $this->cryptoapis = new AFFWP_CRYPTO_Cryptoapis();
        $this->coinmarketcap = new AFFWP_CRYPTO_Coinmarketcap();
        $this->coinbase = new AFFWP_CRYPTO_Coinbase();

    }

    public function get_default_integration_services() {

        return array(
            'get_meta' => array(
                'label' => 'Get Meta',
                'default_integration' => 'coinmarketcap'
            ),
            'get_exchange_rate' => array(
                'label' => 'Get Exchange Rate',
                'default_integration' => 'coinmarketcap'
            ),
            'generate_address' => array(
                'label' => 'Generate Address',
                'default_integration' => 'cryptoapis'
            ),
            'get_address' => array(
                'label' => 'Get Address',
                'default_integration' => 'cryptoapis'
            ),
            'get_transaction' => array(
                'label' => 'Get Transaction',
                'default_integration' => 'cryptoapis'
            ),

        );

    }

    // Get the service integration
    public function get_service_integration($service) {

        // Just return the default
        $services = $this->get_default_integration_services();
        $integration = $services[$service]['default_integration'];
        return (!empty($integration)) ? $integration : '';

    }

    // Pass in $args( 'api_key', 'integration' )
    // Return ( 'status', message )
    public function check_connection($args) {

        if ( !empty($args['integration']) && !empty($args['api_key']) ) :

            $response = $this->{$args['integration']}->check_connection($args);

            if ( $response['status'] == 'success' ) :

                return true;

            else:
                // array with 'status' (error value) and 'message' keys
                return $response;

            endif;

        endif;

        return array('status' => 'error', 'message' => 'No service and/or API key provided');

    }

    // Pass in $args( 'currencies'). Array of currency tickers in lower case
    // Returns array of meta
    public function get_meta($args) {

        $integration = (!empty($args['integration'])) ? $args['integration'] : $this->get_service_integration('get_meta');

        $response = $this->{$integration}->get_meta($args);

        return $response;

    }

    // Pass in $args( 'base_currency', 'payment_currency'). 'integration' is optional
    // Returns the exchange rate
    public function get_exchange_rate($args) {

        $integration = (!empty($args['integration'])) ? $args['integration'] : $this->get_service_integration('get_exchange_rate');

        $response = $this->{$integration}->get_exchange_rate($args);

        return $response;

    }

    // Pass in $args( 'currency'). 'integration' is optional
    // Return $response['address'], $response['privateKey'], $response['publicKey']
    public function generate_address($args) {

        if ( !empty($args['integration']) ) :

            $integration = (!empty($args['integration'])) ? $args['integration'] : $this->get_service_integration('generate_address');
            $response = $this->{$integration}->generate_address($args);

        else:

            // not used
            return array('status' => 'error', 'message' => 'No integration provided');

        endif;

        //$response = $this->{$integration}->generate_address($args);

        return $response;

    }

    // Pass in $args( 'currency', 'integration').
    // Return $response['address'], $response['password'],
    public function generate_account($args) {

        if ( !empty($args['integration']) ) :

            $response = $this->{$args['integration']}->generate_account($args);

        else:
            // not used
            return array('status' => 'error', 'message' => 'No integration provided');

        endif;

        return $response;

    }

    // Pass in $args( 'currency', 'address', 'integration')
    // Return array of data including 'balance'
    public function get_address($args) {

        $integration = (!empty($args['integration'])) ? $args['integration'] : $this->get_service_integration('get_address');

        if ( !empty($args['currency']) && !empty($args['address']) ) :

            $response = $this->{$integration}->get_address($args);
        //update_option('affwp_crypto_apis_get_address_response', $response);

        else:
            // not used
            return array('status' => 'error', 'message' => 'No currency or address provided');

        endif;

        return $response;


    }

    // Pass in $args( 'currency'(key), 'txs_hash' )
    // Returns array including 'confirmations'
    public function get_transaction($args) {

        $integration = (!empty($args['integration'])) ? $args['integration'] : $this->get_service_integration('get_transaction');

        if ( !empty($args['currency']) && !empty($args['txs_hash']) ) :

            $response = $this->{$integration}->get_transaction($args);

        else:
            // not used
            return array('status' => 'error', 'message' => 'No currency or txs hash provided');

        endif;

        return $response;

    }

    // Pass in $args( 'currency', 'payments( 'payment_id', 'currency', 'address', 'payment_amount' ) )
    // Returns payments array with 'tx_hash' (transaction hash) and/or 'response'( 'api_response' =>('status', 'code', 'message') ), 'message' added
    public function send($args) {

        //update_option( 'affwp_crypto_integrations_send_args', $args);

        if ( !empty($args['integration']) ) :

            $integration = $args['integration'];

            $response = $this->{$integration}->send($args);

            return $response;

        else:
            // not used
            return array('status' => 'error', 'message' => 'No payment integration provided');

        endif;

    }

}


/*
  public function check_connection(){}
  /////// Services ///////
  //public function get_address($args){}
  //public function get_transaction($args){}
  //public function get_exchange_rates($args){}
  public function get_exchange_rate($args){}
  public function buy_currency($args){}
  /////// Wallet Services ///////
  //public function generate_wallet($args){}
  public function generate_address($args){}
  //public function import_pk($args){}
  public function select_wallet($args){}
  public function send($args){}*/