<?php

class AFFWP_CRYPTO_Integrations_Base {

    public function __construct() {
    }

    public function get_integration_credentials($key) {

        $enabled_sources = $this->get_enabled_payment_sources();

        return (!empty($enabled_sources[$key])) ? $enabled_sources[$key] : false;

    }

    // Get enabled sources
    public function get_enabled_payment_sources() {

        $sources = get_option('affwp_crypto_activated_sources', array());

        return $sources;

        /*return $sources = array(
            'cryptoapis' => array(
                'api_key' => '',
            ),
            'coinbase' => array(
                'api_key' => '',
            ),
            'metamask' => array()
        );*/

    }

    // Get enabled sources
    /*public function get_deactivated_payment_sources() {

        $sources = get_option('affwp_crypto_deactivated_sources', array());

        return $sources;

    }*/

    // Saves the active sources in the option
    public function activate_payment_source($source, $data) {

        $enabled_sources = $this->get_enabled_payment_sources();

        $enabled_sources[$source] = $data;

        update_option('affwp_crypto_activated_sources', $enabled_sources);

    }

    // Saves the active sources in the option
    public function remove_payment_source($source) {

        $enabled_sources = $this->get_enabled_payment_sources();

        if ( !empty($enabled_sources) ) :

            // Add data to the deactivated array
            //$deactivated_sources = $this->get_deactivated_payment_sources();
            //$deactivated_sources[$source] = $enabled_sources[$source];
            //update_option('affwp_crypto_deactivated_sources', $enabled_sources);

            // Remove from the activated array
            unset($enabled_sources[$source]);
            update_option('affwp_crypto_activated_sources', $enabled_sources);

        endif;

    }

    public function get_services() {

        $services = array(

            // Display fields array( 'imports_pk', 'tokens', 'metamask')

            'coinmarketcap' => array(
                'required_integration' => array('coinmarketcap'),
                'label' => 'CoinMerketCap',
                'general_services' => array(  // list of available services. not used yet, available services only, not necessarily used
                    /*'get_exchange_rates' => array(
                        'label' => 'Get Exchange Rates'
                    ),*/
                    'get_exchange_rate' => array(
                        'label' => 'Get Exchange Rate'
                    ),
                    'get_currency_meta' => array(
                        'label' => 'Get Currency Meta'
                    ),
                ),
                'send_services' => array()
            ),

            'cryptoapis' => array(
                'required_integration' => array('cryptoapis'),
                'label' => 'Crypto APIs',
                'general_services' => array( // list of available services. not used yet, available services only, not necessarily used
                    'get_address' => array(
                        'label' => 'Get Address Data'
                    ),
                    'get_transaction' => array(
                        'label' => 'Get Transaction'
                    ),
                    'get_exchange_rates' => array(
                        'label' => 'Get Exchange Rates'
                    ),
                    'get_exchange_rate' => array(
                        'label' => 'Get Exchange Rate'
                    ),
                ),
                'send_services' => array(
                    'generate_address' => array(
                        'label' => 'Generate Address',
                        'display_fields' => array('generate_address'),
                        'send_fields' => array(
                            'btc' => array('wif' => array( 'key' => 'wif', 'label' => 'Wif') ),
                            'eth' => array('private_key' => array( 'key' => 'private_key', 'label' => 'Private Key') ),
                            'ltc' => array('wif' => array( 'key' => 'wif', 'label' => 'Wif') ),
                            'bch' => array('wif' => array( 'key' => 'wif', 'label' => 'Wif') ),
                        ),
                        'no_save_fields' => array(
                            'btc' => array('wif', 'privateKey', 'publicKey'),
                            'eth' => array('privateKey', 'publicKey'),
                            'ltc' => array('wif', 'privateKey', 'publicKey'),
                            'bch' => array('wif', 'privateKey', 'publicKey')
                        )
                        /*'send_fields' => array(
                            'btc' => array('privateKey', 'wif'),
                            'eth' => array('privateKey'),
                            'ltc' => array('privateKey', 'wif'),
                            'bch' => array('privateKey', 'wif')
                        )*/
                    ),
                    'generate_account' => array(
                        'label' => 'Generate Account',
                        'display_fields' => array('generate_account'),
                        'limit_currencies' => array('ETH'),
                        'send_fields' => array(
                            'eth' => array('password'=> array( 'key' => 'password', 'label' => 'Password'))
                        ),
                        'no_save_fields' => array(
                            'eth' => array('privateKey', 'publicKey'),
                        )
                    ),
                    'import_address' => array(
                        'label' => 'Import Address',
                        'display_fields' => array('import_address'),
                        'send_fields' => array(
                            'btc' => array('wif' => array( 'key' => 'wif', 'label' => 'Wif') ),
                            'eth' => array('private_key' => array( 'key' => 'private_key', 'label' => 'Private Key') ),
                            'ltc' => array('wif' => array( 'key' => 'wif', 'label' => 'Wif') ),
                            'bch' => array('wif' => array( 'key' => 'wif', 'label' => 'Wif') ),
                        ),
                    ),

                ),
                /*'import_pk' => array(
                    'label' => 'Import Private Key',
                    'display_fields' => array('import_pk')
                )*/
            ),

            'coinbase' => array(
                'required_integration' => array('coinbase'),
                'label' => 'Coinbase',
                'general_services' => array(/*'get_exchange_rate' => array(
                        'label' => 'Get Exchange Rate'
                    ),*/
                ),
                'send_services' => array(/*'select_wallet' => array(
                        'label' => 'Select Wallet',
                        'display_fields' => array('select_wallet'),
                        'send_fields' => array(),
                    )*/
                )
            )


        );

        return $services;

    }

    ///////// Payment API wrappers ///////////
    public function get_wallet_sources() {

        $payment_sources = array(

            // Display fields array( 'imports_pk', 'tokens', 'metamask')

            'cryptoapis' => array(
                /*'required_integration' => array('cryptoapis'),*/
                'label' => 'Crypto APIs',
                'currencies' => array('btc', 'eth', 'ltc', 'bch'),
                'send_services' => $this->services['cryptoapis']['send_services']
            ),

            'coinmarketcap' => array(
                /*'required_integration' => array('coinmarketcap'),*/
                'label' => 'CoinMarketCap',
                'currencies' => array('btc', 'eth', 'ltc'/*, 'bch'*/),
                'send_services' => $this->services['coinmarketcap']['send_services']
            ),

            /*'metamask' => array(
                'label' => 'MetaMask',
                'currencies' => array('eth'),
                'services' => array(
                    'payments_ui' => array(
                        'label' => 'Payments Ui',
                        'display_fields' => array('submit_only'),
                    ),
                )
            ),*/


            /*'coinbase' => array(
                'required_integration' => array('coinbase'),
                'label' => 'Coinbase',
                'currencies' => array('btc', 'eth', 'bch', 'ltc'),
                'methods' => $this->services['coinbase']['wallet_address_services']
            ),*/

            /*'cryptoapis' => array(
                'required_integration' => array('cryptoapis'),
                'label' => 'Crypto APIs',
                'currencies' => array('btc', 'eth', 'bch', 'ltc'),
                'methods' => array(
                    'generate_wallet' => array(
                        'label' => 'Generate Wallet',
                        'display_fields' => array('generate_wallet')
                    ),
                    'import_pk' => array(
                        'label' => 'Import Private Key',
                        'display_fields' => array('import_pk')
                    )
                )
            ),
            'coinbase' => array(
                'required_integration' => array('coinbase'),
                'label' => 'Coinbase',
                'currencies' => array('btc', 'eth'),
                'methods' => array(
                    'select_wallet' => array(
                        'label' => 'Select Wallet',
                        'display_fields' => array('select_wallet')
                    )
                )
            ),*/


        );

        return $payment_sources;
    }

    public function generate_password($length = 20) {
        $chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz' .
            '0123456789`-=~!@#$%^&*()_+,./<>?;:[]{}\|';

        $str = '';
        $max = strlen($chars) - 1;

        for ($i = 0; $i < $length; $i++)
            $str .= $chars[mt_rand(0, $max)];

        return $str;
    }

}