<?php

class AFFWP_CRYPTO_Cryptoapis extends AFFWP_CRYPTO_Integrations_Base {

  //protected $plugin_settings;
  protected $plugin_config;
  public $integration_key;
  private $credentials;
  private $api_key; // only set to override the main credentials

  public function __construct() {

    $this->plugin_config = affiliate_wp_crypto()->plugin_config;
    $this->integration_key = 'cryptoapis';
    $this->credentials = $this->get_integration_credentials($this->integration_key);

    add_shortcode('cryptoapis_testing', array($this, 'cryptoapis_testing'));
  }

  public function cryptoapis_testing() {
    ob_start();
    echo '<pre>';
    //print_r($this->credentials);
    print_r($this->get_exchange_rates());
    echo '</pre>';
    $html = ob_get_contents();
    ob_end_clean();
    return $html;
  }

  /////// Services ///////
  public function the_network($currency_key, $network = '') {

    // Get the default unless specified.
    if ( empty($network) ) :

      $network = apply_filters('affwp_crypto_currency_network', affwp_crypto_get_network(), $currency_key, 'cryptoapis');

    endif;

    $currency_config = affiliate_wp_crypto()->base->wallet->get_currency_config($currency_key);
    $network = $currency_config[$network];

    return $network;


  }

  public function get_address($args) {

    //update_option('crypto_token_df_'.$args['currency'], $args);

    //$currency = $args['currency'];
    $currency_config = affiliate_wp_crypto()->base->wallet->get_currency_config($args['currency']);

    // Get the chain currency. For tokens, it's the parent
    //$currency = (isset($currency_config['parent_currency']) && !empty($currency_config['parent_currency'])) ? $currency_config['parent_currency'] : $currency_config['currency'];

    // The network
    $network = $this->the_network($currency_config['currency']);

    $currency = $currency_config['currency'];
    $type = $currency_config['type'];

    $address = $args['address'];

    // currencies
    if ( $type == 'currency' ) :

      $end_point = "bc/$currency/$network/address/$address";

      $response = $this->api_get(array('end_point' => $end_point));

      if ( !empty($response['meta']['error']) ):

        $response['api_response']['status'] = 'error';
        $response['api_response']['code'] = $response['meta']['error']['code'];
        $response['api_response']['message'] = $response['meta']['error']['message'];

      else:

        $response = $response['payload'];

      endif;

    //$address_data['balance'] = $address_data['token'];

    //update_option('affwp_crypto_address_'.$args['currency'], $response);
    //update_option('affwp_crypto_address1_'.$args['currency'], $address_data);

    // ETH tokens
    elseif ( $type == 'token' && $currency == 'eth' ):

      $token_address = $currency_config['token_address'];

      ///tokens/0x0cb1883c01377f45ee5d7448a32b5ac1709afc11/0xe7d553c3aab5943ec097d60535fd06f1b75db43e/balance
      $end_point = "bc/$currency/$network/tokens/$address/$token_address/balance";

      $response = $this->api_get(array('end_point' => $end_point));

      if ( !empty($response['meta']['error']) ):

        $response['api_response']['status'] = 'error';
        $response['api_response']['code'] = $response['meta']['error']['code'];
        $response['api_response']['message'] = $response['meta']['error']['message'];

      else:

        $response = $response['payload'];

        //update_option('crypto_token_de', $address_data);

        $response['balance'] = $response['token'];

      endif;

    endif;

    return $response;


  }

  public function get_transaction($args) {

    //$currency = $args['currency'];
    $currency_config = affiliate_wp_crypto()->base->wallet->get_currency_config($args['currency']);

    // The network, passes the transactions network in-case it has changed since generating the transaction
    $network = $this->the_network($currency_config['currency'], $args['network']);

    // Get the chain currency. For tokens, it's the parent
    $txs_hash = $args['txs_hash'];
    $currency = $currency_config['currency'];

    if ( $currency == 'eth' ) :

      $end_point = "bc/$currency/$network/txs/hash/$txs_hash";


    elseif ( $currency == 'btc' || $currency == 'ltc' || $currency == 'bch' ) :

      $end_point = "bc/$currency/$network/txs/txid/$txs_hash";

    endif;

    $response = $this->api_get(array('end_point' => $end_point));


    if ( !empty($response['meta']['error']) ):

      $response['api_response']['status'] = 'error';
      $response['api_response']['code'] = $response['meta']['error']['code'];
      $response['api_response']['message'] = $response['meta']['error']['message'];

    else:

      $response = $response['payload'];

      // Coin normalization
      if ( $currency == 'eth' ) :

        if ( $response['status'] == '0x0' )  :

          $response['status'] = 'failed';

        endif;

      endif;

    endif;
    /*elseif ( $currency == 'btc' || $currency == 'ltc' || $currency == 'bch' ) :
    endif;*/

    return $response;

  }

  // Not used but tested and working
  public function get_exchange_rates($args = array()) {

    $base_currency = (!empty($args['base_currency'])) ? $args['base_currency'] : 'USD';
    $end_point = "exchange-rates/$base_currency";

    $exchange_rates = $this->api_get(array('end_point' => $end_point));

    return $exchange_rates;

  }

  // Not the default but tested and working
  public function get_exchange_rate($args) {

    $base_currency = $args['base_currency'];
    //$payment_currency = $args['payment_currency'];
    if ( empty($args['payment_currency']) ) :
      $payment_currency = affiliate_wp_crypto()->base->wallet->get_currency_config($args['payment_currency'], 'ticker');
    else:
      $payment_currency = $args['payment_currency'];
    endif;

    $end_point = "exchange-rates/$base_currency/$payment_currency";

    $exchange_rate_data = $this->api_get(array('end_point' => $end_point));

    $weighted_average_price = $exchange_rate_data['payload']['weightedAveragePrice'];
    //$median_price = $exchange_rate_data['payload']['medianPrice'];
    $exchange_rate = $weighted_average_price;

    return $exchange_rate;

  }


  //public function buy_currency($args){}

  /////// Wallet Services ///////

  public function generate_wallet($args) {
  }

  /////// Wallet Address Services ///////

  public function generate_address($args) {

    //$currency = $args['currency'];
    $currency_config = affiliate_wp_crypto()->base->wallet->get_currency_config($args['currency']);
    $currency = $currency_config['currency'];

    // The network
    $network = $this->the_network($currency_config['currency']);

    $end_point = "bc/$currency/$network/address";
    //update_option( 'affwp_crypto_net', $end_point);
    $response = $this->api_post(array('end_point' => $end_point));

    if ( !empty($response['meta']['error']) ):

      $response['api_response']['status'] = 'error';
      $response['api_response']['code'] = $response['meta']['error']['code'];
      $response['api_response']['message'] = $response['meta']['error']['message'];

    else:

      $response = $response['payload'];

    endif;

    return $response;

  }

  public function generate_account($args) {

    //$currency = $args['currency'];
    $currency_config = affiliate_wp_crypto()->base->wallet->get_currency_config($args['currency']);
    $currency = $currency_config['currency'];

    // The network
    $network = $this->the_network($currency_config['currency']);

    $password = $this->generate_password();
    $post_fields = array('password' => $password);

    $end_point = "bc/$currency/$network/account";
    $response = $this->api_post(array('end_point' => $end_point, 'post_fields' => $post_fields));

    if ( !empty($response['meta']['error']) ):

      $response['api_response']['status'] = 'error';
      $response['api_response']['code'] = $response['meta']['error']['code'];
      $response['api_response']['message'] = $response['meta']['error']['message'];

    else:

      $response = $response['payload'];

    endif;

    if ( $response['success'] == 'keystore saved' ) :

      $response['password'] = $password;

    endif;

    //update_option('crypto_acc1', $response);

    return $response;

  }

  //public function buy_currency($args){}

  //public function import_pk($args) {}

  //public function select_wallet($args){}

  public function send($args) {

    //update_option( 'affwp_crypto_send_args_'.$args['currency'], $args);

    $currency_config = affiliate_wp_crypto()->base->wallet->get_currency_config($args['currency']);

    // The network
    $network = $this->the_network($currency_config['currency']);

    //update_option('affwp_crypto_config_network_'. $args['currency'], $network);

    // Get the chain currency. For tokens, it's the parent
    //$currency = (isset($currency_config['parent_currency']) && !empty($currency_config['parent_currency'])) ? $currency_config['parent_currency'] : $currency_config['currency'];
    $currency = $currency_config['currency'];
    $type = $currency_config['type'];

    $payments = $args['payments'];
    $from_address = $args['currency_args']['address'];

    // currencies
    if ( $type == 'currency' ) :

      //if ( ($currency = 'btc' || $currency = 'ltc') && $args['currency_args']['method'] == 'generate_account' ) :
      if ( ($currency == 'btc' || $currency == 'ltc' || $currency == 'bch') ) :

        $end_point = "bc/$currency/$network/txs/new";

        $count = 0;
        foreach ($payments as $key => $payment) :

          //$payment_id = $payment['payment_id'];

          $post_fields['createTx']['inputs'][$count]['address'] = $from_address;
          $post_fields['createTx']['inputs'][$count]['value'] = $payment['payment_amount'];

          $total = (isset($total)) ? $total + $payment['payment_amount'] : $payment['payment_amount'];

          // Outputs
          /*$post_fields['createTx']['outputs']['address'] = $from_address;
          $post_fields['createTx']['outputs']['value'] = $total;

          // Fee
          $post_fields['createTx']['fee']['address'] = $from_address; // not required for LTC
          $post_fields['createTx']['fee']['value'] = 0.00023141;

          $post_fields['wifs'] = $args['currency_args']['wif'];

          $response = $this->api_post(array('end_point' => $end_point, 'post_fields' => $post_fields));*/

          $count++;

        endforeach;

        // Outputs
        $post_fields['createTx']['outputs'][0]['address'] = $payment['address'];
        $post_fields['createTx']['outputs'][0]['value'] = $total;

        // Fee
        $post_fields['createTx']['fee']['address'] = $from_address; // not required for LTC
        $post_fields['createTx']['fee']['value'] = $currency_config['fee'];

        $post_fields['wifs'] = array($args['currency_args']['wif']);

        $response = $this->api_post(array('end_point' => $end_point, 'post_fields' => $post_fields));

        // Add raw API response
        $payments[$key]['api_response']['raw'] = $response;

        // If success
        if ( isset($response['payload']['txid']) ) :

          if ( !is_array($response['payload']['txid']) ) $response['payload']['txid'] = array($response['payload']['txid']);

          foreach ($response['payload']['txid'] as $key => $tx_hash) :

            $payments[$key]['tx_hash'] = $tx_hash;

          endforeach;
        // Add meta / errors
        elseif ( isset($response['meta']) ) :

          if ( isset($response['meta']['error']) ) :

            $payments[$key]['api_response']['status'] = 'error';
            $payments[$key]['api_response']['code'] = $response['meta']['error']['code'];
            $payments[$key]['api_response']['message'] = $response['meta']['error']['message'];

          endif;

        endif;

        //update_option('crypto_payments_btc', $response);

      endif;

      if ( $currency == 'eth' ) :

        foreach ($payments as $key => $payment) :

          $post_fields['fromAddress'] = $from_address;
          $post_fields['toAddress'] = $payment['address'];
          $post_fields['gasPrice'] = $currency_config['gas_price'];
          $post_fields['gasLimit'] = $currency_config['gas_limit'];
          $post_fields['value'] = $payment['payment_amount'];
          /*$post_fields['nonce'] = time();*/

          if ( $args['currency_args']['method'] == 'generate_account' ) :

            $end_point = "bc/$currency/$network/txs/new";

            $post_fields['password'] = $args['currency_args']['password'];

          elseif ( $args['currency_args']['method'] == 'generate_address' || $args['currency_args']['method'] == 'import_address' ):

            $end_point = "bc/$currency/$network/txs/new-pvtkey";

            $post_fields['privateKey'] = $args['currency_args']['private_key'];

          endif;

          $response = $this->api_post(array('end_point' => $end_point, 'post_fields' => $post_fields));
          //update_option( 'affwp_crypto_eth_send_end_point', $end_point);
          //update_option( 'affwp_crypto_eth_send_post_fields', $post_fields);
          //update_option( 'affwp_crypto_eth_send_response', $response);

          // Add raw API response
          $payments[$key]['api_response']['raw'] = $response;

          // If success
          if ( isset($response['payload']['hex']) ) :

            if ( !is_array($response['payload']['hex']) ) $response['payload']['hex'] = array($response['payload']['hex']);

            foreach ($response['payload']['hex'] as $key => $tx_hash) :

              $payments[$key]['tx_hash'] = $tx_hash;

              // start webhook
              // needs to be tested with a startup plan
              // no action added yet to catch the webhook
              /*

              // build webhook url
              $webhook_url_base = (is_ssl() ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'].'/';
              $webhook_params = array(
                'crypto_payment_id' => $args['payment_id'],
                'crypto_transaction_hash' => $tx_hash
              );
              $webhook_url = esc_url(add_query_arg($webhook_params, $webhook_url_base));

              // build webhook parameters
              $end_point_webhook = "bc/$currency/$network/hooks";
              $post_fields_webhook = array(
                'event' => 'CONFIRMED_TX',
                'url' => $webhook_url,
                'confirmations' => 5,
                'transaction' => $tx_hash
              );

              update_option('crypto_webhook_config_0', $webhook_url);
              update_option('crypto_webhook_config', $post_fields_webhook);

              // send web hook
              $response_webhook = $this->api_post(array('end_point' => $end_point_webhook, 'post_fields' => $post_fields_webhook));
              update_option('crypto_webhook', $response_webhook);


              */
              // end webhook

            endforeach;

          // Add meta / errors
          elseif ( isset($response['meta']) ) :

            if ( isset($response['meta']['error']) ) :

              $payments[$key]['api_response']['status'] = 'error';
              $payments[$key]['api_response']['code'] = $response['meta']['error']['code'];
              $payments[$key]['api_response']['message'] = $response['meta']['error']['message'];

            endif;

          endif;

          //update_option('crypto_payments_eth1', $response);

          //update_option('crypto_payments_args2', $response);

        endforeach;


      endif;

    //update_option('crypto_prepared_tx', $post_fields);

    //update_option('crypto_prepared_send_tx', $response);

    //update_option('crypto_send_response', $response);
    //update_option('crypto_send_response1', $payments);

    /*if ( isset($response['tx_hash']) ) :

        if ( !is_array($response['tx_hash']) ) $response['tx_hash'] = array($response['tx_hash']);

        foreach ($response['tx_hash'] as $key => $tx_hash) :

            $payments[$key]['tx_hash'] = $tx_hash;

        endforeach;

    endif;*/

    // Tokens
    elseif ( $type == 'token' ) :

      // ETH
      if ( $currency == 'eth' ) :

        $end_point = "bc/$currency/$network/tokens/transfer";

        foreach ($payments as $key => $payment) :

          $post_fields['fromAddress'] = $from_address;
          $post_fields['toAddress'] = $payment['address'];
          $post_fields['contract'] = $currency_config['token_address'];
          $post_fields['gasPrice'] = $currency_config['token_gas_price'];
          $post_fields['gasLimit'] = $currency_config['token_gas_limit'];
          $post_fields['token'] = $payment['payment_amount'];

          if ( $args['currency_args']['method'] == 'generate_account' ) :

            $post_fields['password'] = $args['currency_args']['password'];

          elseif ( $args['currency_args']['method'] == 'generate_address' || $args['currency_args']['method'] == 'import_address' ):

            $post_fields['privateKey'] = $args['currency_args']['private_key'];

          endif;

          $response = $this->api_post(array('end_point' => $end_point, 'post_fields' => $post_fields));

          //update_option('crypto_payments_eth2', $response);
          // Add raw API response
          $payments[$key]['api_response']['raw'] = $response;

          // If success
          if ( isset($response['payload']['hex']) ) :

            if ( !is_array($response['payload']['hex']) ) $response['payload']['hex'] = array($response['payload']['hex']);

            foreach ($response['payload']['hex'] as $key => $tx_hash) :

              $payments[$key]['tx_hash'] = $tx_hash;

            endforeach;

          // Add meta / errors
          elseif ( isset($response['meta']) ) :

            if ( isset($response['meta']['error']) ) :

              $payments[$key]['api_response']['status'] = 'error';
              $payments[$key]['api_response']['code'] = $response['meta']['error']['code'];
              $payments[$key]['api_response']['message'] = $response['meta']['error']['message'];

            endif;

          endif;

        endforeach;


      endif;

    endif;

    /*if ( isset($response['tx_hash']) ) :

        if ( !is_array($response['tx_hash']) ) $response['tx_hash'] = array($response['tx_hash']);

        foreach ($response['tx_hash'] as $key => $tx_hash) :

            $payments[$key]['tx_hash'] = $tx_hash;

        endforeach;

    endif;*/

    return $payments;


  }

  /////// Auth, Connection & API ///////

  public function check_connection($args) {

    $this->api_key = $args['api_key'];

    //$response = $this->get_exchange_rates();

    $check_args = array('base_currency' => 'USD', 'payment_currency' => 'BTC');
    $response = $this->get_exchange_rate($check_args);

    $return = array();
    //if ( !empty($response['meta']['results_']) ) :
    if ( !empty($response) ) :

      $return['status'] = 'success';

    elseif ( !empty($response['meta']['error']) ):

      //$return['status'] = 'error';
      //$return['error_message'] = $response['meta']['error']['message'];
      $return['api_response']['status'] = 'error';
      $return['api_response']['code'] = $response['meta']['error']['code'];
      $return['api_response']['message'] = $response['meta']['error']['message'];


    else:

      $return['api_response']['status'] = 'error';
      $return['api_response']['code'] = 'unknown';
      $return['api_response']['message'] = 'An unknown error has occurred';

    endif;

    return $return;

  }

  public function api_get($args) {

    $api_key = (isset($this->api_key) && !empty($this->api_key)) ? $this->api_key : $this->credentials['api_key'];

    // Get cURL resource
    $curl = curl_init();
    $headers[] = 'Accept: application/json';
    $headers[] = 'X-API-KEY: ' . $api_key;
    curl_setopt_array($curl, [
      CURLOPT_RETURNTRANSFER => 1,
      CURLOPT_HTTPHEADER => $headers,
      CURLOPT_URL => 'https://api.cryptoapis.io/v1/' . $args['end_point'],
    ]);
    // Send the request & save response to $resp
    $resp = curl_exec($curl);
    $response = json_decode($resp, true);

    return $response;

  }

  public function api_post($args) {

    update_option('affwp_crypto_api_post_args', $args);

    $api_key = (isset($this->api_key) && !empty($this->api_key)) ? $this->api_key : $this->credentials['api_key'];

    // Get cURL resource
    $curl = curl_init();
    $headers[] = 'Content-Type: application/json';
    $headers[] = 'X-API-KEY: ' . $api_key;
    $post_fields = (!empty($args['post_fields']) ? $args['post_fields'] : array());
    curl_setopt_array($curl, [
      CURLOPT_RETURNTRANSFER => 1,
      CURLOPT_HTTPHEADER => $headers,
      CURLOPT_URL => 'https://api.cryptoapis.io/v1/' . $args['end_point'],
      CURLOPT_POST => 1,
      CURLOPT_POSTFIELDS => json_encode($post_fields)
    ]);

    // Send the request & save response to $resp
    $resp = curl_exec($curl);
    $response = json_decode($resp, true);

    return $response;
  }

}

?>