<?php

class AFFWP_CRYPTO_Coinmarketcap extends AFFWP_CRYPTO_Integrations_Base {

    //protected $plugin_settings;
    protected $plugin_config;
    public $integration_key;
    private $credentials;
    private $api_key; // only set to override the main credentials

    public function __construct() {

        $this->plugin_config = affiliate_wp_crypto()->plugin_config;
        $this->integration_key = 'coinmarketcap';
        $this->credentials = $this->get_integration_credentials($this->integration_key);

        add_shortcode('coinmarketcap_testing', array($this, 'coinmarketcap_testing'));
    }

    public function coinmarketcap_testing() {
        ob_start();
        echo '<pre>';
        //print_r($this->credentials);
        /* print_r($this->get_exchange_rate(array(
                 'payment_currency' => 'ETH',
                 'base_currency' => 'USD')
         ));*/
        echo '</pre>';
        $html = ob_get_contents();
        ob_end_clean();
        return $html;
    }

    public function get_exchange_rates($args = array()) {
    }

    public function get_exchange_rate($args) {

        //update_option('affwp_crypto_cmc_exchange_rate_args', $args);

        $base_currency = $args['base_currency'];
        //$payment_currency = $args['payment_currency'];
        $c_config = affiliate_wp_crypto()->base->wallet->get_currency_config($args['payment_currency']);
        $payment_currency = $c_config['ticker'];

        $end_point = "cryptocurrency/quotes/latest";

        $args = array('symbol' => $payment_currency, 'convert' => $args['base_currency']);
        $response = $this->api_get(array('end_point' => $end_point, 'args' => $args));

        //update_option('affwp_crypto_cmc_exchange_rate_' . $payment_currency, $response);

        if ( $response['status']['error_code'] == 0 ) :

            $base_currency_price = $response['data'][$payment_currency]['quote'][$base_currency]['price'];

            //$c_config = affiliate_wp_crypto()->base->wallet->get_currency_config($args['payment_currency']);
            $decimals = ($c_config['type'] == 'token') ? $c_config['token_decimals'] : $c_config['decimals'];

            //$exchange_rate = (1 / $base_currency_price);
            $exchange_rate = bcdiv('1', $base_currency_price, $decimals);

            //update_option('affwp_crypto_cmc_exchange_rate_mod' . $payment_currency, $exchange_rate);

            return $exchange_rate;

        else:

            $return['api_response']['status'] = 'error';
            $return['api_response']['code'] = $response['status']['error_code'];
            $return['api_response']['message'] = $response['status']['error_message'];

            return $return;

        endif;

    }

    public function get_meta($args) {

        $end_point = "cryptocurrency/info";

        $args = array('symbol' => $args['currencies']);
        $response = $this->api_get(array('end_point' => $end_point, 'args' => $args));

        if ( $response['status']['error_code'] == 0 ) :

            $meta = $response['data'];

            return $meta;

        else:

            $return['api_response']['status'] = 'error';
            $return['api_response']['code'] = $response['status']['error_code'];
            $return['api_response']['message'] = $response['status']['error_message'];

            return $return;

        endif;

    }

    /////// Auth, Connection & API ///////

    public function check_connection($args) {

        $this->api_key = $args['api_key'];

        $args['currencies'] = 'ETH';
        $response = $this->get_meta($args);

        if ( !isset($response['api_response']['code']) ) :

            $return['status'] = 'success';

            return $return;

        else:

            return $response;

        endif;

    }

    public function api_get($args) {

        $api_key = (isset($this->api_key) && !empty($this->api_key)) ? $this->api_key : $this->credentials['api_key'];

        $url = 'https://pro-api.coinmarketcap.com/v1/' . $args['end_point'];

        $parameters = $args['args'];

        $qs = http_build_query($parameters);
        $request = "{$url}?{$qs}";

        // Get cURL resource
        $curl = curl_init();
        $headers[] = 'Accepts: application/json';
        $headers[] = 'X-CMC_PRO_API_KEY: ' . $api_key;
        curl_setopt_array($curl, [
            CURLOPT_RETURNTRANSFER => 1,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_URL => $request,
        ]);
        // Send the request & save response to $resp
        $resp = curl_exec($curl);
        $response = json_decode($resp, true);

        return $response;

    }

    /*public function api_post($args) {

        $api_key = (isset($this->api_key) && !empty($this->api_key)) ? $this->api_key : $this->credentials['api_key'];

        // Get cURL resource
        $curl = curl_init();
        $headers[] = 'Content-Type: application/json';
        $headers[] = 'X-API-KEY: ' . $api_key;
        $post_fields = (!empty($args['post_fields']) ? $args['post_fields'] : array());
        curl_setopt_array($curl, [
            CURLOPT_RETURNTRANSFER => 1,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_URL => 'https://api.cryptoapis.io/v1/' . $args['end_point'],
            CURLOPT_POST => 1,
            CURLOPT_POSTFIELDS => json_encode($post_fields)
        ]);
        // Send the request & save response to $resp
        $resp = curl_exec($curl);
        $response = json_decode($resp, true);

        return $response;
    }*/

}

?>