jQuery(document).ready(function () {

    // Load the wallet settings UI
    affwp_crypto_settings_load_ui({'action': 'affwp_crypto', 'task': 'load_wallet_settings_ui'});

    // Ajax submit a Source activation
    jQuery(document).on("click", ".source_submit", function () {
        sourcekey = jQuery(this).data('sourcekey');
        submit_source_form(sourcekey);
    });

    // Ajax submit a Currency activation
    jQuery(document).on("click", ".currency_submit", function () {
        currencykey = jQuery(this).data('currencykey');
        submit_currency_form(currencykey);
    });

    // Ajax submit a Token activation
    jQuery(document).on("click", ".token_submit", function () {
        currencykey = jQuery(this).data('currencykey');
        submit_token_form(currencykey);
    });

    // Ajax deactivate Source
    jQuery(document).on("click", ".wallet_action.remove_source.enabled", function () {
        sourcekey = jQuery(this).data('source');
        //alert(sourcekey);
        remove_source(sourcekey);
    });

    // Ajax deactivate Currency
    jQuery(document).on("click", ".wallet_action.deactivate_currency", function () {
        currencykey = jQuery(this).data('currency');
        sourcekey = jQuery(this).data('source');
        methodtype = jQuery(this).data('methodtype');
        //alert(currencykey );
        deactivate_currency(currencykey, sourcekey, methodtype);
    });

    // Ajax deactivate Currency
    jQuery(document).on("click", ".wallet_action.reactivate_currency", function () {
        currencykey = jQuery(this).data('currency');
        sourcekey = jQuery(this).data('source');
        methodtype = jQuery(this).data('methodtype');
        //alert(currencykey );
        reactivate_currency(currencykey, sourcekey, methodtype);
    });

    // Ajax remove Currency
    jQuery(document).on("click", ".wallet_action.remove_currency", function () {
        currencykey = jQuery(this).data('currency');
        //alert(currencykey );
        remove_currency(currencykey);
    });

    // Show or hide available currency fields
    jQuery(document).on("change", ".currency_source_method", function () {

        currencykey = jQuery(this).find(':selected').data('currencykey');
        servicekey = jQuery(this).find(':selected').data('servicekey');
        //sourcekey = jQuery(this).find(':selected').data('sourcekey');

        // Curenecy specific optional send fields
        jQuery("#currency_row_" + currencykey + " .currency_specific").hide();
        jQuery("#currency_row_" + currencykey + " ." + servicekey + ".currency_specific." + currencykey).show();

        // Setting groups (display fields)
        displayfields = jQuery(this).find(':selected').data('displayfields');
        option_value = jQuery(this).find(':selected').val();
        if (option_value != '') {
            jQuery(this).closest(".wallet_settings_table_row").attr('class', 'wallet_settings_table_row enabled ' + displayfields);
        } else {
            jQuery(this).closest(".wallet_settings_table_row").attr('class', 'wallet_settings_table_row ' + displayfields);
        }
        /*jQuery(this).nextAll(".wallet_settings_table_column.options2").toggleClass(fields);*/
        //alert(currencykey+' '+ sourcekey);
        //alert(method.data.fields);
    });

});

function affwp_crypto_settings_load_ui(args) {

    jQuery.ajax({
        type: "post",
        dataType: "json",
        url: affwp_crypto_vars.ajaxurl,
        data: args,
        success: function (response) {

            if (response.type == "success") {
                jQuery("#tab_container").after(response.html);
                //jQuery("#affwp_crypto_settings_sources").html(response.html);
                //console.log(response.type);

                affwp_crypto_settings_load_sources();
            } else {
                //alert("Ajax Error");
            }

        }
    });

}

function affwp_crypto_settings_load_sources() {

    jQuery.ajax({
        type: "post",
        dataType: "json",
        url: affwp_crypto_vars.ajaxurl,
        data: {'action': 'affwp_crypto', 'task': 'load_sources'},
        success: function (response) {

            if (response.type == "success") {
                jQuery("#affwp_crypto_settings_sources").html(response.html);
                //console.log(response.type);

                affwp_crypto_settings_load_currencies();
            } else {
                //alert("Ajax Error");
            }

        }
    });
}

function affwp_crypto_settings_load_currencies() {

    jQuery.ajax({
        type: "post",
        dataType: "json",
        url: affwp_crypto_vars.ajaxurl,
        data: {'action': 'affwp_crypto', 'task': 'load_currencies'},
        success: function (response) {

            if (response.type == "success") {
                jQuery("#affwp_crypto_settings_currencies").html(response.html);
                //console.log(response.type);

                jQuery(".affwp_crypto_wallet_ui .loading_indicator").hide();

            } else {
                //alert("Ajax Error");
                jQuery(".affwp_crypto_wallet_ui .loading_indicator").hide();
            }

        }
    });
}

function submit_source_form(sourcekey) {
    event.preventDefault(); //prevent default action

    jQuery(".affwp_crypto_loading").show();

    var form_data = jQuery('#source_settings_' + sourcekey).serialize();

    args = {
        'action': 'affwp_crypto',
        'task': 'save_sources',
        'form_data': form_data
    };

    //console.log(1);

    jQuery.ajax({
        type: "post",
        dataType: "json",
        url: affwp_crypto_vars.ajaxurl,
        data: args,
        success: function (response) {
            //console.log(2);

            if (response.type == "success") {

                //jQuery("#source_row_" + sourcekey).html('');
                //jQuery("#activated_sources").append(response.activated_row);

                //affwp_crypto_settings_load_currencies({'action': 'affwp_crypto', 'task': 'load_currencies'});

                affwp_crypto_settings_load_sources();
                //affwp_crypto_settings_load_currencies();

            }

            if (response.type == "error") {

                affwp_crypto_settings_load_sources();

                //jQuery(".wallet_settings_table_row.notifications." + sourcekey).html(response.errors);
                //jQuery(".wallet_settings_table_row.notifications." + sourcekey).append(response.debug);

            }

            // Hide Loading indicator
            jQuery(".affwp_crypto_wallet_ui .loading_indicator").hide();

            // Modal Notification
            if (response.notification != "") {

                if (response.notification_type != null) {
                    notification_type = response.notification_type;
                } else {
                    notification_type = '';
                }

                if (response.notification_style != null) {
                    notification_style = response.notification_style;
                } else {
                    notification_style = '';
                }

                if (notification_type === 'prompt') {
                    if (response.prompt_text != null) {
                        prompt_text = response.prompt_text;
                    } else {
                        prompt_text = 'I have completed the above actions';
                    }
                } else {
                    prompt_text = '';
                }

                affwp_crypto_display_modal(response.notification, notification_type, prompt_text, notification_style);
            }

        }
    });

}

function remove_source(sourcekey) {

    jQuery(".affwp_crypto_loading").show();

    //event.preventDefault(); //prevent default action

    //alert(sourcekey);

    //var form_data = jQuery('#currency_tokens_' + currencykey).serialize();

    args = {
        'action': 'affwp_crypto',
        'task': 'remove_source',
        'source': sourcekey
    };

    //console.log(1);

    jQuery.ajax({
        type: "post",
        dataType: "json",
        url: affwp_crypto_vars.ajaxurl,
        data: args,
        success: function (response) {
            //console.log(2);

            if (response.type == "success") {

                //alert(response.type);
                affwp_crypto_settings_load_sources();
                //affwp_crypto_settings_load_currencies();

                //jQuery(".activated_currency_message").html('');
                //jQuery("#activated_currencies").append(response.activated_row);

                //jQuery(".wallet_settings_table_row.notifications." + currencykey).html(''); // incase of previous errors
                //jQuery(".wallet_settings_table_row.notifications." + currencykey).html(response.notifications);

                //document.getElementById("currency_tokens_"+currencykey).reset();


            }

            if (response.type == "error") {

                affwp_crypto_settings_load_sources();

                //alert(response.type);

                //jQuery(".wallet_settings_table_row.notifications." + currencykey).html(response.errors);
                //jQuery(".wallet_settings_table_row.notifications." + currencykey).append(response.debug);

            }

            // Hide Loading indicator
            jQuery(".affwp_crypto_wallet_ui .loading_indicator").hide();

            // Modal Notification
            if (response.notification != "") {

                if (response.notification_type != null) {
                    notification_type = response.notification_type;
                } else {
                    notification_type = '';
                }

                if (response.notification_style != null) {
                    notification_style = response.notification_style;
                } else {
                    notification_style = '';
                }

                if (notification_type === 'prompt') {
                    if (response.prompt_text != null) {
                        prompt_text = response.prompt_text;
                    } else {
                        prompt_text = 'I have completed the above actions';
                    }
                } else {
                    prompt_text = '';
                }

                affwp_crypto_display_modal(response.notification, notification_type, prompt_text, notification_style);
            }

        }
    });

}

function submit_currency_form(currencykey) {

    event.preventDefault(); //prevent default action

    jQuery(".affwp_crypto_loading").show();

    //alert(currencykey);

    var form_data = jQuery('#currency_settings_' + currencykey).serialize();

    args = {
        'action': 'affwp_crypto',
        'task': 'save_currency',
        'form_data': form_data
    };

    //console.log(1);

    jQuery.ajax({
        type: "post",
        dataType: "json",
        url: affwp_crypto_vars.ajaxurl,
        data: args,
        success: function (response) {
            //console.log(response.type);

            if (response.type == "success") {

                //jQuery("#currency_row_" + currencykey).html('');
                //jQuery("#activated_currencies").append(response.activated_row);

                //jQuery(".wallet_settings_table_row.notifications." + currencykey).html(''); // incase of previous errors
                //jQuery(".wallet_settings_table_row.notifications." + currencykey).html(response.notifications);

                affwp_crypto_settings_load_currencies();

            }

            if (response.type == "error") {

                affwp_crypto_settings_load_currencies();

                //jQuery(".wallet_settings_table_row.notifications." + currencykey).html(response.errors);
                //jQuery(".wallet_settings_table_row.notifications." + currencykey).append(response.debug);

            }

            // Hide Loading indicator
            jQuery(".affwp_crypto_wallet_ui .loading_indicator").hide();

            // Modal Notification
            if (response.notification != "") {

                if (response.notification_type != null) {
                    notification_type = response.notification_type;
                } else {
                    notification_type = '';
                }

                if (response.notification_style != null) {
                    notification_style = response.notification_style;
                } else {
                    notification_style = '';
                }

                if (notification_type === 'prompt') {
                    if (response.prompt_text != null) {
                        prompt_text = response.prompt_text;
                    } else {
                        prompt_text = 'I have completed the above actions';
                    }
                } else {
                    prompt_text = '';
                }

                affwp_crypto_display_modal(response.notification, notification_type, prompt_text, notification_style);
            }

        }
    });

}

function submit_token_form(currencykey) {

    event.preventDefault(); //prevent default action

    jQuery(".affwp_crypto_loading").show();

    //alert(currencykey);

    var form_data = jQuery('#currency_tokens_' + currencykey).serialize();

    args = {
        'action': 'affwp_crypto',
        'task': 'save_currency_token',
        'form_data': form_data
    };

    //console.log(1);

    jQuery.ajax({
        type: "post",
        dataType: "json",
        url: affwp_crypto_vars.ajaxurl,
        data: args,
        success: function (response) {
            //console.log(2);

            if (response.type == "success") {

                //jQuery(".activated_currency_message").html('');
                //jQuery("#activated_currencies").append(response.activated_row);

                //jQuery(".wallet_settings_table_row.notifications." + currencykey).html(''); // incase of previous errors
                //jQuery(".wallet_settings_table_row.notifications." + currencykey).html(response.notifications);

                document.getElementById("currency_tokens_" + currencykey).reset();

                affwp_crypto_settings_load_currencies();

            }

            if (response.type == "error") {

                affwp_crypto_settings_load_currencies();

                //jQuery(".wallet_settings_table_row.notifications." + currencykey).html(response.errors);
                //jQuery(".wallet_settings_table_row.notifications." + currencykey).append(response.debug);

            }

            // Hide Loading indicator
            jQuery(".affwp_crypto_wallet_ui .loading_indicator").hide();

            // Modal Notification
            if (response.notification != "") {

                if (response.notification_type != null) {
                    notification_type = response.notification_type;
                } else {
                    notification_type = '';
                }

                if (response.notification_style != null) {
                    notification_style = response.notification_style;
                } else {
                    notification_style = '';
                }

                if (notification_type === 'prompt') {
                    if (response.prompt_text != null) {
                        prompt_text = response.prompt_text;
                    } else {
                        prompt_text = 'I have completed the above actions';
                    }
                } else {
                    prompt_text = '';
                }

                affwp_crypto_display_modal(response.notification, notification_type, prompt_text, notification_style);
            }

        }
    });

}

function deactivate_currency(currencykey, sourcekey, methodtype) {

    //event.preventDefault(); //prevent default action

    jQuery(".affwp_crypto_loading").show();

    //alert(currencykey);

    //var form_data = jQuery('#currency_tokens_' + currencykey).serialize();

    args = {
        'action': 'affwp_crypto',
        'task': 'deactivate_currency',
        'currency': currencykey,
        'source': sourcekey,
        'methodtype': methodtype
    };

    //console.log(1);

    jQuery.ajax({
        type: "post",
        dataType: "json",
        url: affwp_crypto_vars.ajaxurl,
        data: args,
        success: function (response) {
            //console.log(2);

            if (response.type == "success") {

                //alert(response.type);
                //affwp_crypto_settings_load_currencies();
                affwp_crypto_settings_load_sources();

                //jQuery(".activated_currency_message").html('');
                //jQuery("#activated_currencies").append(response.activated_row);

                //jQuery(".wallet_settings_table_row.notifications." + currencykey).html(''); // incase of previous errors
                //jQuery(".wallet_settings_table_row.notifications." + currencykey).html(response.notifications);

                //document.getElementById("currency_tokens_"+currencykey).reset();


            }

            if (response.type == "error") {

                //affwp_crypto_settings_load_currencies();
                affwp_crypto_settings_load_sources();

                //alert(response.type);

                //jQuery(".wallet_settings_table_row.notifications." + currencykey).html(response.errors);
                //jQuery(".wallet_settings_table_row.notifications." + currencykey).append(response.debug);

            }

            // Hide Loading indicator
            jQuery(".affwp_crypto_wallet_ui .loading_indicator").hide();

            // Modal Notification
            if (response.notification != "") {

                if (response.notification_type != null) {
                    notification_type = response.notification_type;
                } else {
                    notification_type = '';
                }

                if (response.notification_style != null) {
                    notification_style = response.notification_style;
                } else {
                    notification_style = '';
                }

                if (notification_type === 'prompt') {
                    if (response.prompt_text != null) {
                        prompt_text = response.prompt_text;
                    } else {
                        prompt_text = 'I have completed the above actions';
                    }
                } else {
                    prompt_text = '';
                }

                affwp_crypto_display_modal(response.notification, notification_type, prompt_text, notification_style);
            }

        }
    });

}

function reactivate_currency(currencykey, sourcekey, methodtype) {

    //event.preventDefault(); //prevent default action

    jQuery(".affwp_crypto_loading").show();

    //alert(currencykey);

    //var form_data = jQuery('#currency_tokens_' + currencykey).serialize();

    args = {
        'action': 'affwp_crypto',
        'task': 'reactivate_currency',
        'currency': currencykey,
        'source': sourcekey,
        'methodtype': methodtype
    };

    //console.log(1);

    jQuery.ajax({
        type: "post",
        dataType: "json",
        url: affwp_crypto_vars.ajaxurl,
        data: args,
        success: function (response) {
            //console.log(2);

            if (response.type == "success") {

                //alert(response.type);
                affwp_crypto_settings_load_currencies();
                affwp_crypto_settings_load_sources();

                //jQuery(".activated_currency_message").html('');
                //jQuery("#activated_currencies").append(response.activated_row);

                //jQuery(".wallet_settings_table_row.notifications." + currencykey).html(''); // incase of previous errors
                //jQuery(".wallet_settings_table_row.notifications." + currencykey).html(response.notifications);

                //document.getElementById("currency_tokens_"+currencykey).reset();


            }

            if (response.type == "error") {

                affwp_crypto_settings_load_currencies();
                affwp_crypto_settings_load_sources();

                //alert(response.type);

                //jQuery(".wallet_settings_table_row.notifications." + currencykey).html(response.errors);
                //jQuery(".wallet_settings_table_row.notifications." + currencykey).append(response.debug);

            }

            // Hide Loading indicator
            jQuery(".affwp_crypto_wallet_ui .loading_indicator").hide();

            // Modal Notification
            if (response.notification != "") {

                if (response.notification_type != null) {
                    notification_type = response.notification_type;
                } else {
                    notification_type = '';
                }

                if (response.notification_style != null) {
                    notification_style = response.notification_style;
                } else {
                    notification_style = '';
                }

                if (notification_type === 'prompt') {
                    if (response.prompt_text != null) {
                        prompt_text = response.prompt_text;
                    } else {
                        prompt_text = 'I have completed the above actions';
                    }
                } else {
                    prompt_text = '';
                }

                affwp_crypto_display_modal(response.notification, notification_type, prompt_text, notification_style);
            }

        }
    });

}

function remove_currency(currencykey) {

    //event.preventDefault(); //prevent default action

    jQuery(".affwp_crypto_loading").show();

    //alert(currencykey);

    //var form_data = jQuery('#currency_tokens_' + currencykey).serialize();

    args = {
        'action': 'affwp_crypto',
        'task': 'remove_currency',
        'currency': currencykey
    };

    //console.log(1);

    jQuery.ajax({
        type: "post",
        dataType: "json",
        url: affwp_crypto_vars.ajaxurl,
        data: args,
        success: function (response) {
            //console.log(2);

            if (response.type == "success") {

                //alert(response.type);
                affwp_crypto_settings_load_sources();
                //affwp_crypto_settings_load_currencies();

                //jQuery(".activated_currency_message").html('');
                //jQuery("#activated_currencies").append(response.activated_row);

                //jQuery(".wallet_settings_table_row.notifications." + currencykey).html(''); // incase of previous errors
                //jQuery(".wallet_settings_table_row.notifications." + currencykey).html(response.notifications);

                //document.getElementById("currency_tokens_"+currencykey).reset();


            }

            if (response.type == "error") {

                affwp_crypto_settings_load_sources();
                //affwp_crypto_settings_load_currencies();

                //alert(response.type);

                //jQuery(".wallet_settings_table_row.notifications." + currencykey).html(response.errors);
                //jQuery(".wallet_settings_table_row.notifications." + currencykey).append(response.debug);

            }

            // Hide Loading indicator
            jQuery(".affwp_crypto_wallet_ui .loading_indicator").hide();

            // Modal Notification
            if (response.notification != "") {

                if (response.notification_type != null) {
                    notification_type = response.notification_type;
                } else {
                    notification_type = '';
                }

                if (response.notification_style != null) {
                    notification_style = response.notification_style;
                } else {
                    notification_style = '';
                }

                if (notification_type === 'prompt') {
                    if (response.prompt_text != null) {
                        prompt_text = response.prompt_text;
                    } else {
                        prompt_text = 'I have completed the above actions';
                    }
                } else {
                    prompt_text = '';
                }

                affwp_crypto_display_modal(response.notification, notification_type, prompt_text, notification_style);
            }

        }
    });

}
