jQuery(document).ready(function () {

    // Show or hide available currency fields
    jQuery(document).on("change", ".crypto_payment_currency", function () {

        paymentCurrencyKey = jQuery(this).find(':selected').data('currencykey');

        // Curenecy specific optional send fields
        jQuery(".payment_currency_p").hide();
        jQuery(".payment_currency_p." + paymentCurrencyKey).show();

    });

    // Close button on modals
    jQuery(document).on("click", ".affwp_crypto_modal_close, .affwp_crypto_modal_prompt_button", function () {

        jQuery(".affwp_crypto_modal.notification").toggle();

        jQuery(".affwp_crypto_modal.notification .affwp_crypto_modal_content").html('');

    });

});

function affwp_crypto_generate_modal_content(type, heading, content){

    block = '<div class="affwp_crypto_modal_block '+ type +'"><h3>' + heading + '</h3><p>' + content + '</p></div>';

        return block;
}

// types: standard, prompt, fade
function affwp_crypto_display_modal(content, type, prompt_text, style) {

    //jQuery(".affwp_crypto_modal.notification").hide();

    // Reset modal types
    jQuery(".affwp_crypto_modal.notification").removeClass("standard fade prompt");

    // Set modal type.  standard, fade, prompt
    //if (type != 'standard') {

        jQuery(".affwp_crypto_modal.notification").addClass(type);

    //}

    // Reset modal styles
    jQuery(".affwp_crypto_modal.notification").removeClass("generic success warning error");

    // Set modal styles.  generic, success, warning, error
    //if (style != 'generic') {

        jQuery(".affwp_crypto_modal.notification").addClass(style);

    //}

    // Add prompt content
    if (type == 'prompt') {

        if (prompt_text == '') {
            prompt_text = 'Close';
        }

        jQuery(".affwp_crypto_modal.notification .affwp_crypto_modal_prompt_button").html(prompt_text);
    }

    // Add main Modal content
    jQuery(".affwp_crypto_modal.notification .affwp_crypto_modal_content").html(content);


    // Show the Modal
    jQuery('.affwp_crypto_modal.notification').fadeIn('fast', function () {

        // Fade out if required
        if (type == 'fade') {
            jQuery('.affwp_crypto_modal.notification').delay(4000).fadeOut();
        }

    });

}