// Globally scoped objects
var payments_ui_data;
var payments_processing = {};
var send_payments = [];
var sent_payments = [];

var api_send_status = '';

var walletConnector = {};

var processingInterval = 15000; // 15 seconds

payments_processing["provided_send_fields"] = {}
payments_processing["completed_payments"] = {}

//var runSendPayments = setInterval(runSendPayments, 10000);
var runSentPayments = setInterval(runSendPayments, processingInterval);


jQuery(document).ready(function () {

    // Trigger the payouts screen from an individual affiliate
    jQuery(document).on("click", ".crypto_payout_trigger", function () {

        event.preventDefault(); //prevent default action

        affiliate_id = jQuery(this).data('affiliate');
        if (affiliate_id) {
            args = {
                'action': 'affwp_crypto',
                'task': 'payout_single_affiliate',
                'affiliate_id': affiliate_id
            };
        }

        referral_id = jQuery(this).data('referral');
        if (referral_id) {
            args = {
                'action': 'affwp_crypto',
                'task': 'payout_single_referral',
                'referral_id': referral_id
            };
        }

        affwp_crypto_payouts_load_ui(args);

    });

    // Trigger the payouts modal from the affiliates bulk action
    jQuery(document).on("click", "#doaction", function () {

        bulkaction_affiliates = jQuery('.bulkactions #bulk-action-selector-top').find(':selected').val();

        if (bulkaction_affiliates == 'crypto-convert-affiliates-bulk') {

            event.preventDefault(); //prevent default action

            var form_data = jQuery('#affwp-affiliates-filter').serialize();

            args = {
                'action': 'affwp_crypto',
                'task': 'payout_bulk_affiliates',
                'form_data': form_data
            };
            affwp_crypto_payouts_load_ui(args);

        }

        bulkaction_referrals = jQuery('.bulkactions [name="action"]').find(':selected').val();

        if (bulkaction_referrals == 'crypto-convert-referrals-bulk') {

            event.preventDefault(); //prevent default action

            var form_data = jQuery('#affwp-referrals-filter-form').serialize();

            args = {
                'action': 'affwp_crypto',
                'task': 'payout_bulk_referrals',
                'form_data': form_data
            };
            affwp_crypto_payouts_load_ui(args);

        }

    });

    // Close button on payments modal
    jQuery(document).on("click", ".affwp_crypto_payouts_ui_close", function () {

        jQuery("#affwp_crypto_payouts_ui").remove();
        jQuery(".affwp_crypto_loading").show();
        location.href = payments_ui_data['redirect_url'];

    });

    // Wallet Connect
    jQuery(document).on("click", ".connect_to_wallet_connect", function () {

        initiate_WalletConnect();

    });

    // Payment Buttons
    jQuery(document).on("click", ".payout_action.enabled", function () {

        //jQuery(".payout_action").remove();
        if (jQuery(this).data('currency') != undefined) {
            payments_processing["currency"] = jQuery(this).data('currency');

        }

        payments_processing["type"] = jQuery(this).data('type');
        payments_processing["method"] = jQuery(this).data('method');
        payments_processing["payment_ids"] = jQuery(this).data('payments');

        if (payments_processing["type"] == "currency") {
            payments_processing["required_send_fields"] = payments_ui_data['currencies'][payments_processing["currency"]]["required_send_fields"];

            // Disable buttons
            /*jQuery(".payout_action." + jQuery(this).data('ticker')).removeClass("enabled");
            jQuery(".payout_action." + jQuery(this).data('ticker')).addClass("disabled");
            jQuery(".payout_action.bulk").removeClass("enabled");
            jQuery(".payout_action.bulk").addClass("disabled");*/

        }

        if (payments_processing["type"] == "affiliate") {
            payments_processing["affiliate_id"] = jQuery(this).data('affiliate');
            payments_processing["required_send_fields"] = payments_ui_data['currencies'][payments_processing["currency"]]["required_send_fields"];

            // Disable buttons
            /*jQuery(".payout_action.affiliate." + jQuery(this).data('affiliate')).removeClass("enabled");
            jQuery(".payout_action.affiliate." + jQuery(this).data('affiliate')).addClass("disabled");
            jQuery(".payout_action.currency." + jQuery(this).data('ticker')).removeClass("enabled");
            jQuery(".payout_action.currency." + jQuery(this).data('ticker')).addClass("disabled");
            jQuery(".payout_action.bulk").removeClass("enabled");
            jQuery(".payout_action.bulk").addClass("disabled");*/

        }

        if (payments_processing["type"] == "all") {
            payments_processing["required_send_fields"] = payments_ui_data['all']['required_send_fields'];

            // Disable buttons
            /*jQuery(".payout_action").removeClass("enabled");
            jQuery(".payout_action").addClass("disabled");*/

        }

        //alert(JSON.stringify(payments_processing));

        if (payments_processing["method"] == 'wallet_connect') {

            if (walletConnector) {

                //initiate_WalletConnect();

                //} else {

                process_payments();

            }

        } else if (payments_processing["method"] == 'metamask') {

            process_payments();

        } else {

            if (send_fields_validation()) { /////////////////////////////////////////////////////////////////////////////////////////////////

                //if (balance_checks()) {

                //alert('Yes');

                process_pre_checks();

                //process_payments();

                //}

            } else {

                jQuery(".affwp_crypto_send_fields_form").toggle();

            }

        }

        //localStorage.setItem("required_fields", required_fields);

        //required_fields_data = JSON.parse(localStorage.getItem("required_fields"));
        //alert(payments_processing["currency"]);

    });

    // Send fields submit
    jQuery(document).on("click", "#send_fields_submit", function () {

        event.preventDefault(); //prevent default action

        required_send_fields_status = '';

        jQuery('#send_fields input.send_field').each(function (key, value) {
            //console.log(this.value);
            if (jQuery(this).css('display') != 'none') {

                if (this.value == '') {
                    //alert('error');
                    //id = this.id;
                    //console.log(id);
                    jQuery(this).addClass('affwp_crypto_validation_error');
                    required_send_fields_status = 'validation_failed';
                } else {
                    jQuery(this).removeClass('affwp_crypto_validation_error');
                    payments_processing["provided_send_fields"][this.name] = this.value;
                }

            }
            //payments_processing["provided_send_fields"]
            //alert(this.value);
            //alert(this.name);
            //payments_processing["provided_send_fields"][this.name] = this.value;
            //alert(payments_processing["provided_send_fields"][this.name]);
        });

        if (required_send_fields_status != 'validation_failed') {

            jQuery(".affwp_crypto_send_fields_form").toggle();
            /*jQuery(".affwp_crypto_send_fields_form").toggle("fast", function () {
                process_pre_checks();
            });*/

            //if (balance_checks()) {

            //alert('Yes');

            process_pre_checks();
            //process_payments();

            //}

        }

    });

    // Send fields modal close button
    jQuery(document).on("click", ".affwp_crypto_send_fields_close", function () {

        jQuery(".affwp_crypto_send_fields_form").toggle();

    });

});

function affwp_crypto_payouts_load_ui(args) {
    // temp for dev only
    //localStorage.removeItem("payments_ui_data");

    var loadingHtml = '<div class="affwp_crypto_loading loading_indicator lds-dual-ring"></div>';
    jQuery(document.body).append(loadingHtml);

    jQuery(".affwp_crypto_payouts_ui_loading").show();

    jQuery.ajax({
        type: "post",
        dataType: "json",
        url: affwp_crypto_vars.ajaxurl,
        data: args,
        success: function (response) {

            if (response.type == "success") {

                payments_ui_data = JSON.parse(response.payments_ui_data);

                var UiHtml = '<div id="affwp_crypto_payouts_ui" class="affwp_crypto_payouts_modal"><div class="affwp_crypto_payouts_ui"><span class="affwp_crypto_payouts_ui_close">&times;</span><div class="affwp_crypto_payouts_ui_content"></div></div></div>';
                jQuery(document.body).append(UiHtml);

                jQuery(".affwp_crypto_payouts_ui_content").html(response.html);

                jQuery(".affwp_crypto_loading").hide();


                // temp for dev only
                //localStorage.setItem("payments_ui_data", response.payments_ui_data);
                //payments_ui_data = JSON.parse(localStorage.getItem("payments_ui_data"));

                //alert(payouts['41']['address']);

                //localStorage.setItem("payments_ui_data", response.payments_ui_data);
                //payments_ui_data = response.payments_ui_data;

            } else {
            }

        }
    });

}

// Submit the send fields
function send_fields_validation() {

    send_field_validation_result = true;

    // Hide all send fields
    jQuery(".send_field").hide();

    //required_send_fields_class_string = "affwp_crypto_send_fields_form";
    if (payments_processing["required_send_fields"] != undefined) {

        jQuery.each(payments_processing["required_send_fields"], function (index, value) {

            if (payments_processing["provided_send_fields"][value] === undefined) {

                //alert(JSON.stringify(payments_processing["provided_send_fields"][value]));

                c_class = "." + value;
                jQuery(c_class).toggle();

                send_field_validation_result = false;

            }

        });

    }

    return send_field_validation_result;

}

function process_pre_checks() {

    //payments_processing["completed_payments"] = {}
    //payments_processing["completed_payments"][payment_id] = {};
    //payments_processing["completed_payments"][payment_id]["payment_id"] = payment_id;
    //payments_processing["completed_payments"][payment_id]["transaction_hash"] = txHash;

    modal_content = affwp_crypto_generate_modal_content('standard', 'Running Pre-checks.', '- Running Balance Checks');
    affwp_crypto_display_modal(modal_content, 'standard', '', 'success');

    //jQuery(".affwp_crypto_modal.notification").hide();

    //modal_content = affwp_crypto_generate_modal_content('error', 'There was an issue signing you in to MetaMask.', '');
    //affwp_crypto_display_modal(modal_content, 'fade', '', 'error');

    //jQuery(".affwp_crypto_payouts_ui_loading").show();

    args = {
        'action': 'affwp_crypto',
        'task': 'pre_checks',
        'payments_ui_data': payments_ui_data,
        'payment_ids': payments_processing['payment_ids'],
    };

    jQuery.ajax({
        type: "post",
        dataType: "json",
        /*async: false,*/
        url: affwp_crypto_vars.ajaxurl,
        data: args,
        success: function (response) {

            if (response.type == "success") {

                //jQuery(".affwp_crypto_loading").hide();
                //alert('Checked');

                process_payments();

            } else {

                // Modal Notification
                if (response.notification != "") {

                    if (response.notification_type != null) {
                        notification_type = response.notification_type;
                    } else {
                        notification_type = '';
                    }

                    if (response.notification_style != null) {
                        notification_style = response.notification_style;
                    } else {
                        notification_style = '';
                    }

                    if (notification_type === 'prompt') {
                        if (response.prompt_text != null) {
                            prompt_text = response.prompt_text;
                        } else {
                            prompt_text = 'I have completed the above actions';
                        }
                    } else {
                        prompt_text = '';
                    }

                    //jQuery(".affwp_crypto_loading").hide();

                    affwp_crypto_display_modal(response.notification, notification_type, prompt_text, notification_style);
                }

            }

        }
    });

}

// Process payments
function process_payments() {

    //localStorage.setItem("provided_send_fields", JSON.stringify(payments_processing["provided_send_fields"]) );

    //test = localStorage.getItem("provided_send_fields");

    if (payments_processing["method"] == 'metamask' || payments_processing["method"] == 'wallet_connect') {

        jQuery.each(payments_processing['payment_ids'], function (index, value) {

            web3_amount_wei = web3.toWei(payments_ui_data['payments'][value]['payment_amount'], 'ether');
            web3_amount_hex = web3.toHex(web3_amount_wei);

            web3_args = {
                'address': payments_ui_data['payments'][value]['address'],
                'amount': web3_amount_hex,
                'payment_id': value,
                'currency_type': 'eth'
            };

            if (payments_ui_data['payments'][value]['currency_type'] != undefined) {

                web3_args['currency_type'] = payments_ui_data['payments'][value]['currency_type']

                if (payments_ui_data['payments'][value]['currency_type'] == 'token') {

                    web3_args['token_amount'] = payments_ui_data['payments'][value]['payment_amount'];
                    web3_args['token_address'] = payments_ui_data['payments'][value]['token_address'];
                    web3_args['token_decimals'] = payments_ui_data['payments'][value]['token_decimals'];

                }

            }

            if (payments_processing["method"] == 'metamask') {

                sendMetamask(web3_args);

            } else if (payments_processing["method"] == 'wallet_connect') {

                sendWalletConnect(web3_args);

            }

            // Log entry
            log_name = payments_ui_data['payments'][value]['affiliate_name'];
            log_amount = payments_ui_data['payments'][value]['payment_amount'];
            log_currency = payments_ui_data['payments'][value]['payment_currency'];
            log_currency_upper = log_currency.toUpperCase();
            log_method = payments_processing["method"];
            add_log_entry('Payment to ' + log_name + ' -> ' + log_amount + ' ' + log_currency_upper + ' -> Sent to ' + log_method + ' for processing');

        });

    }

    if (payments_processing["method"] == 'api') {

        // Process payments on front end
        //if (payments_processing["required_send_fields"].length > 0) {
        //if (1 == 1) {

        //payments_processing['payment_ids'].each(function (key, value) {

        jQuery.each(payments_processing['payment_ids'], function (index, value) {

            send_payments.push(value);

            // Log entry
            log_name = payments_ui_data['payments'][value]['affiliate_name'];
            log_amount = payments_ui_data['payments'][value]['payment_amount'];
            log_currency = payments_ui_data['payments'][value]['payment_currency'];
            log_currency_upper = log_currency.toUpperCase();
            log_method = payments_processing["method"];

            update_log_status(send_payments.length + ' pending');
            add_log_entry('Payment to ' + log_name + ' -> ' + log_amount + ' ' + log_currency_upper + ' -> Sent to queue for processing.');

            // Modal Notification

            modal_content = affwp_crypto_generate_modal_content('success', 'Payments added to the queue for processing', 'Please keep this browser window/tab open until the queue status is complete.');

            affwp_crypto_display_modal(modal_content, 'prompt', 'Okay, I understand', 'success');

        });


        // approve all and let the cron handle the payments
        //}
        /*else {

            args = {
                'action': 'affwp_crypto',
                'task': 'approve_payments',
                'payments_data': payments_processing
            };

            jQuery.ajax({
                type: "post",
                dataType: "json",
                url: affwp_crypto_vars.ajaxurl,
                data: args,
                success: function (response) {

                    if (response.type == "success") {

                        jQuery.each(payments_processing['payment_ids'], function (index, value) {

                            sent_payments.push(value);

                        });

                    } else {
                    }

                }
            });

        }*/

    }

}

function update_log_status(status, style = '') {

    jQuery(".payments_ui_log_status_label").html(status);

    jQuery(".payments_ui_log_footer").show();

}

function add_log_entry(content) {

    log_row = '<div class="payments_ui_log_row">' + Date.now() + ' -> ' + content + '</div>';

    jQuery(".affwp_crypto_ui_section.payments_ui_log .payments_ui_log_content").prepend(log_row);

    jQuery(".affwp_crypto_payouts_ui").addClass("log_open");

}

// Update the UI after a successful payment
function update_ui(payment_id, response) {

    jQuery("#payment_id_" + payment_id + " > td.status").html(response.payment_status);
    jQuery("#payment_id_" + payment_id + " > td.tx_info").html(response.payment_tx_info);
    jQuery("#payment_id_" + payment_id + " > td.payout_id").html(response.payment_payout_id);

    // Log entry
    log_affiliate_id = payments_ui_data['payments'][payment_id]['affiliate_id'];
    log_name = payments_ui_data['payments'][payment_id]['affiliate_name'];
    log_amount = payments_ui_data['payments'][payment_id]['payment_amount'];
    log_currency = payments_ui_data['payments'][payment_id]['payment_currency'];
    log_currency_upper = log_currency.toUpperCase();
    //log_method = payments_processing["method"];
    add_log_entry('Payment to ' + log_name + ' -> ' + log_amount + ' ' + log_currency_upper + ' -> ' + 'Processed by the blockchain');

    affiliate_id = payments_ui_data['payments'][payment_id]['affiliate_id'];

    jQuery('[data-affiliate="' + log_affiliate_id + '"]').removeClass("enabled");
    jQuery('[data-affiliate="' + log_affiliate_id + '"]').addClass("disabled");
    jQuery('[data-currency="' + log_currency + '"]').removeClass("enabled");
    jQuery('[data-currency="' + log_currency + '"]').addClass("disabled");
    jQuery(".payout_action.bulk").removeClass("enabled");
    jQuery(".payout_action.bulk").addClass("disabled");

}

// Process the payments in the queue
function runSendPayments() {

    //jQuery.each(send_payments, function (index, value) {
    if (send_payments.length >= 1) {

        console.log(api_send_status);

        if (api_send_status != 'in_progress') {

            api_send_status = 'in_progress';
            update_log_status(send_payments.length + ' pending');

            //alert(send_payments[0]);

            send_payment_id = send_payments[0];

            args = {
                'action': 'affwp_crypto',
                'task': 'pay_payments',
                'payments_data': payments_processing,
                'payment_id': send_payment_id
            };

            jQuery.ajax({
                type: "post",
                dataType: "json",
                url: affwp_crypto_vars.ajaxurl,
                data: args,
                success: function (response) {

                    if (response.type == "success") {

                        update_ui(send_payment_id, response);
                        sent_payments.push(send_payment_id);

                        // Remove payment ID from send array
                        //itemtoRemove = send_payment_id;
                        send_payments.splice(jQuery.inArray(send_payment_id, send_payments), 1);

                        if (send_payments.length >= 1) {

                            update_log_status(send_payments.length + ' pending');

                        } else {

                            update_log_status('Complete');

                        }

                        api_send_status = 'available';

                    } else if (response.type == "error") {

                        api_error_code = response.api_code;
                        api_error_message = response.api_message;

                        log_name = payments_ui_data['payments'][send_payment_id]['affiliate_name'];
                        log_amount = payments_ui_data['payments'][send_payment_id]['payment_amount'];
                        log_currency = payments_ui_data['payments'][send_payment_id]['payment_currency'];
                        log_currency_upper = log_currency.toUpperCase();
                        //log_method = payments_processing["method"];

                        console.log(response.api_code);
                        console.log(payments_ui_data['payments'][send_payment_id]['payment_currency']);

                        // Ignore ETH nonce issue, BTC Can not sign transaction, BTC Can not send transaction: txn-mempool-conflict, BTC txn-mempool-conflict (code 18)
                        // All above are just temporary when sending multiple
                        if (response.api_code != 3014 || response.api_code != 2002 || response.api_code != 2003 || response.api_code != 18) {

                            add_log_entry('Payment to ' + log_name + ' -> ' + log_amount + ' ' + log_currency_upper + ' -> ' + 'Error -> Code: ' + api_error_code + ' Message: ' + api_error_message);

                        }

                        // BTC - No left UTXOs in address
                        if (response.api_code == 2328 && payments_ui_data['payments'][send_payment_id]['payment_currency'] == 'btc') {

                            //processingInterval = 60000; // 1 minute
                            processingInterval = 120000; // 2 minutes

                            if (processingInterval != 120000) {
                                add_log_entry('Increasing the wait between payments to 2 minutes to prevent excess attempts');
                            }
                            add_log_entry('Payment to ' + log_name + ' -> ' + log_amount + ' ' + log_currency_upper + ' -> ' + 'Payment will be attempted again soon');

                        }

                        api_send_status = 'failed - available';
                    }

                }
                //});

            });

            //update_log_status( send_payments.length + ' pending' );

        }

    } else {

        //update_log_status('Complete');

    }
}

// Complete payments from web3 method
function completePayments(payment_id, txHash) {

    payments_processing["completed_payments"] = {}
    payments_processing["completed_payments"][payment_id] = {};
    payments_processing["completed_payments"][payment_id]["payment_id"] = payment_id;
    payments_processing["completed_payments"][payment_id]["transaction_hash"] = txHash;

    args = {
        'action': 'affwp_crypto',
        'task': 'complete_web3_payments',
        'payments_data': payments_processing
    };

    jQuery.ajax({
        type: "post",
        dataType: "json",
        url: affwp_crypto_vars.ajaxurl,
        data: args,
        success: function (response) {

            if (response.type == "success") {

                //alert("success");

                update_ui(payment_id, response);
                sent_payments.push(payment_id);

                //jQuery(".affwp_crypto_payouts_ui_content").html(response.html);

                //payments_ui_data = JSON.parse(response.payments_ui_data);


            } else {
            }

        }
    });

}

// Failed payments from web3 method
function failedPayments(payment_id, error_string) {

    // Log entry
    log_name = payments_ui_data['payments'][payment_id]['affiliate_name'];
    log_amount = payments_ui_data['payments'][payment_id]['payment_amount'];
    log_currency = payments_ui_data['payments'][payment_id]['payment_currency'];
    log_currency_upper = log_currency.toUpperCase();
    log_method = payments_processing["method"];
    add_log_entry('Payment to ' + log_name + ' -> ' + log_amount + ' ' + log_currency_upper + ' -> ' + error_string);

}

// Web3 / Metamask

function sendMetamask(web3_args) {

    const desiredNetwork = '1' // '1' is the Ethereum main network ID.

    // Detect whether the current browser is ethereum-compatible,
    // and handle the case where it isn't:
    if (typeof window.ethereum === 'undefined') {
        //alert('Looks like you need a Dapp browser to get started.')
        //alert('Consider installing MetaMask!')
        //affwp_crypto_display_modal('Looks like you need a Dapp browser to get started. Please install MetaMask');

        modal_content = affwp_crypto_generate_modal_content('warning', 'Looks like you need a Dapp browser to get started. Please install MetaMask.', '');

        affwp_crypto_display_modal(modal_content, 'fade', '', 'warning');

    } else {

        // In the case the user has MetaMask installed, you can easily
        // ask them to sign in and reveal their accounts:
        ethereum.enable()

        // Remember to handle the case they reject the request:
            .catch(function (reason) {
                if (reason === 'User rejected provider access') {
                    // The user didn't want to sign in!
                } else {
                    // This shouldn't happen, so you might want to log this...
                    //alert('There was an issue signing you in.')
                    //affwp_crypto_display_modal('There was an issue signing you in to MetaMask');

                    modal_content = affwp_crypto_generate_modal_content('error', 'There was an issue signing you in to MetaMask.', '');

                    affwp_crypto_display_modal(modal_content, 'fade', '', 'error');

                }
            })

            // In the case they approve the log-in request, you'll receive their accounts:
            .then(function (accounts) {
                // You also should verify the user is on the correct network:
                if (ethereum.networkVersion !== desiredNetwork) {
                    //alert('This application requires the main network, please switch it in your MetaMask UI.')
                    //affwp_crypto_display_modal('This application requires the main network, please switch it in your MetaMask UI.');

                    modal_content = affwp_crypto_generate_modal_content('warning', 'This application requires the main network, please switch it in your MetaMask UI.', '');

                    affwp_crypto_display_modal(modal_content, 'standard', '', 'warning');

                    // We plan to provide an API to make this request in the near future.
                    // https://github.com/MetaMask/metamask-extension/issues/3663
                }

                // Once you have a reference to user accounts,
                // you can suggest transactions and signatures:
                if (web3_args['currency_type'] == 'eth') {

                    const account = accounts[0]
                    sendMetamaskEther(web3_args, account, function (err, transaction) {
                        /*if (err) {
                            return alert(`Sorry you weren't able to contribute!`)
                        }*/

                        //alert('Thanks for your successful contribution!')
                    })

                } else if (web3_args['currency_type'] == 'token') {
                    sendMetamaskTokens(web3_args);
                }

            })
    }

}

function sendMetamaskEther(web3_args, account, callback) {

    //alert( metamask_amount);

    // We're going to use the lowest-level API here, with simpler example links below
    const method = 'eth_sendTransaction'
    const parameters = [{
        from: account,
        to: web3_args['address'],
        value: web3_args['amount'],
    }]
    const from = account

    // Now putting it all together into an RPC request:
    const payload = {
        method: method,
        params: parameters,
        from: from,
    }

    // Methods that require user authorization like this one will prompt a user interaction.
    // Other methods (like reading from the blockchain) may not.
    ethereum.sendAsync(payload, function (err, response) {
        const rejected = 'User denied transaction signature.'
        if (response.error && response.error.message.includes(rejected)) {
            //return alert(`We can't take your money without your permission.`)
            failedPayments(payment_id, 'MetaMask permission rejected');
        }

        if (err) {
            //return alert('There was an issue, please try again.')
            failedPayments(payment_id, 'MetaMask error, please try again');
        }

        if (response.result) {
            // If there is a response.result, the call was successful.
            // In the case of this method, it is a transaction hash.
            const txHash = response.result
            //alert(txHash)

            // You can poll the blockchain to see when this transaction has been mined:
            //pollForCompletion(txHash, callback)

            completePayments(web3_args['payment_id'], txHash);

        }
    })
}

function sendMetamaskTokens(web3_args) {

    let tokenAddress = web3_args['token_address'];
    let toAddress = web3_args['address'];
    // Use BigNumber
    let decimals = web3.toBigNumber(web3_args['token_decimals']);
    let amount = web3.toBigNumber(web3_args['token_amount']);
    let minABI = [
        // transfer
        {
            "constant": false,
            "inputs": [
                {
                    "name": "_to",
                    "type": "address"
                },
                {
                    "name": "_value",
                    "type": "uint256"
                }
            ],
            "name": "transfer",
            "outputs": [
                {
                    "name": "",
                    "type": "bool"
                }
            ],
            "type": "function"
        }
    ];
    // Get ERC20 Token contract instance
    let contract = web3.eth.contract(minABI).at(tokenAddress);
    // calculate ERC20 token amount
    let value = amount.times(web3.toBigNumber(10).pow(decimals));
    // call transfer function
    contract.transfer(toAddress, value, (error, txHash) => {
        // it returns tx hash because sending tx
        console.log(web3_args['payment_id']);
        completePayments(web3_args['payment_id'], txHash);
    });

}

// Web3 / WalletConnect
function sendWalletConnect(web3_args) {

    //initiate_WalletConnect();

    /*if (web3_args['currency_type'] == 'eth') {

        sendWalletConnectEther(web3_args);

    } else if (web3_args['currency_type'] == 'token') {

        sendWalletConnectTokens(web3_args);

    }*/
}

function sendWalletConnectEther(web3_args) {

    //initiate_WalletConnect();

    // Draft transaction
    var tx = {
        //from: "0xB103f6F384068F67Ab6b6FD16966f386845D6F4b",
        from: "0xB103f6F384068F67Ab6b6FD16966f386845D6F4b",
        // Required
        to: web3_args['address'],
        // Required (for non contract deployments)
        data: "0x",
        // Required
        gasPrice: "0x02540be400",
        // Optional
        gasLimit: "0x9c40",
        // Optional
        value: web3_args['amount'],
        // Optional
        nonce: "0x0114"
        // Optional

    }; // Send transaction

    walletConnector.sendTransaction(tx).then(function (result) {
        // Returns transaction id (hash)
        console.log(result);
        //completePayments(web3_args['payment_id'], result);
    }).catch(function (error) {
        // Error returned when rejected
        console.error(error);
    });
}

function sendWalletConnectTokens(web3_args) {
}

// Function content copied from includes/js/wallet_connect/dist/main.js
// Compiled/Bundled from https://docs.walletconnect.org/quick-start/dapps
function initiate_WalletConnect() {
    //onInit();
}