<?php

if ( ! class_exists( 'AffiliateWP_Process_Manager_1' ) ) :

	class AffiliateWP_Process_Manager_1 {
	
	public function __construct( $config ) {
			
		$this->config = $config;
		
		$this->task = $config['task'];
		$this->schedule = $config['schedule'];
		$this->limit = ( !empty($config['limit']) ) ? $config['limit'] : 10 ;
		$this->data_age_limit = $config['data_age_limit'];
		
		$this->process_meta_key = $this->get_process_meta_key();
		
		$this->set_batch_config();
			
	}
	
	public function set_batch_config() {
		
		//$batch_config = get_option( $this->process_meta_key );
		$batch_config = get_transient( $this->process_meta_key );
		
		if( !empty( $batch_config ) ) {
		
			$this->batch_config = unserialize($batch_config);
		
		} else {
			
			$this->generate_batch_config();
		}

	}
	
	public function generate_batch_config() {
		
		$this->batch_config['last_processed'] = 0;
		$this->batch_config['last_to_process'] = $this->get_last_to_process();
		$this->batch_config['total_processed'] = 0;
		
		$this->save_batch_config();
		
	}
	
	public function save_batch_config() {
		
		$batch_config = serialize($this->batch_config);

		//update_option( $this->process_meta_key, $batch_config, false );
		set_transient( $this->process_meta_key, $batch_config, 17520 * HOUR_IN_SECONDS ); // 2 years. hours * seconds in hour
		
	}
	
	public function complete_process( $affiliate_id ) {
		
		$this->batch_config['last_processed'] = $affiliate_id;
		++ $this->batch_config['total_processed'];
		
		$this->save_batch_config();
		
	}
	
	public function get_process_meta_key() {
		
		$meta_key = $this->task.'_'.$this->schedule.'_'.$this->get_process_meta_key_value( 'current' );
		
		return $meta_key;
	}
	
	public function get_process_meta_key_value( $version ) {
		
		if($this->schedule == 'monthly') :
			
			if( $version = 'current') {
		
				$meta_value = date('Ym');
			
			}elseif( $version = 'previous') {
				
				$meta_value = date('Ym', strtotime(date('Y-m')." -1 month") );
				
			}
		
		endif;
		
		if($this->schedule == 'daily') :
			
			if( $version = 'current') {
		
				$meta_value = date('Ymd');
			
			}
		
		endif;
		
		return ( !empty($meta_value) ) ? $meta_value : '';
		
	}
	
	public function get_last_to_process() {
		
		$args = array(
			'limit' => 1,
			'order' => 'DESC',
		);
		
		$results = $this->query_affiliates( $args );
		
		$affiliate_id = $results[0]->affiliate_id;

		return $affiliate_id;
		
	}
	
	public function query_affiliates( $args = array() ) {
		
		global $wpdb;
		
		$defaults = array(
			'limit'       => $this->limit,
			'status'       => 'active',
			'order'        => 'ASC',
			'orderby'      => 'affiliate_id'
		);

		$args = wp_parse_args( $args, $defaults );
		
		$last_processed = ( !empty($this->batch_config['last_processed']) ) ? $this->batch_config['last_processed'] : 0;
		$last_to_process = ( !empty($this->batch_config['last_to_process']) ) ? $this->batch_config['last_to_process'] : '';
		
		$limit = $args['limit'];
		$order = $args['order'];
		$order_by = $args['orderby'];
		
		$aff_table  = $wpdb->prefix.'affiliate_wp_affiliates';
		
		$sql = 	"SELECT *";
		$sql .= " FROM $aff_table";
		$sql .= " WHERE affiliate_id > $last_processed";
		
		if( !empty($last_to_process) ) $sql .= " AND affiliate_id <= $last_to_process";
		
		$sql .= " ORDER BY $order_by $order";
		$sql .= " LIMIT $limit";
		;
		
		//print_r($this->batch_config);
		
		$results = $wpdb->get_results( $sql );
		
		return $results;
		
	}

}

endif;

/*Example*/

//public function monthly_process() {
//		
//		// Config
//		$process_config = array(
//			'task' 				=> 'affwp_mla_binary',
//			'schedule'			=> 'monthly',
//			'limit'				=> 10,
//			'data_age_limit'	=> 'year',
//		);
//		
//		
//		// New object and get all affiliate
//		$process_manager = new AffiliateWP_Process_Manager_1( $process_config );
//		$affiliate_ids = $process_manager->query_affiliates();
//
//		if( count($affiliate_ids) >= 1) :
//
//			foreach( $affiliate_ids as $affiliate) :
//
//				$affiliate_id = $affiliate->affiliate_id;
//
//      		$bonus_config = array(
//				'affiliate_id' 		=> $affiliate_id,
//				'default_amount'	=> '150',
//				);
//			
//				$monthly_bonus = new AffiliateWP_M_B( $bonus_config );
//				
//				$amount = $this->plugin_setting( 'monthly_bonus' );
//				
//				// Run required function and complete the process
//				if( $monthly_bonus->process_affiliate( $amount ) ) :
//					
//					$process_manager->complete_process( $affiliate_id );
//				
//				endif;
//			
//			endforeach;	
//		
//		endif;
//		
//	}