<?php
add_shortcode('test_crypto', 'test_crypto');
function test_crypto() {
    echo affwp_crypto_setting('max_address_verifications');
}

function affwp_crypto_setting($key) {
    $common = new AFFWP_CRYPTO_Common();
    $setting = $common->plugin_setting($key);
    return $setting;
}

function affwp_crypto_get_network(){

    // 'mainnet' or 'testnet' only if filtering. see docs for further explanation
    $network = 'mainnet';
    return apply_filters( 'affwp_crypto_network', $network );

}

function affiliate_has_active_address($affiliate_id) {

    return affiliate_wp_crypto()->base->payments->affiliate_has_active_address($affiliate_id);

}

function minify_hash($address, $chars = 4) {

    return substr($address, 0, $chars) . '.....' . substr($address, -$chars);

}

function minify_amount($amount, $chars = 8) {

    return substr($amount, 0, $chars);

}

function affwp_crypto_get_currency_meta($currency_key, $meta_key) {

    return affiliate_wp_crypto()->base->wallet->get_currency_meta($currency_key, $meta_key);

}

function affwp_crypto_get_asset_logo($asset_key, $title = '') {

    //affiliate_wp_crypto()->plugin_config['plugin_file']

    $logo_src = plugins_url('affiliatewp-crypto/plugin_core/includes/images/' . $asset_key . '.png');

    return '<img class="affwp_crypto_asset_icon" title="' . $title . '" src="' . $logo_src . '">';

}

function affwp_crypto_generate_modal($atts = array()) {

    ob_start();
    ?>
    <div class="affwp_crypto_modal notification">
        <div class="affwp_crypto_modal_close" title="close"></div>
        <div class="affwp_crypto_modal_content"></div>
        <div class="affwp_crypto_modal_prompt_button"></div>
    </div>

    <?php
    $html = ob_get_contents();
    ob_end_clean();

    return $html;

}

function affwp_crypto_array_to_messages($array) {

    ob_start();
    foreach ($array as $item) :
        ?>

        <div class="affwp_crypto_modal_block <?php echo $item['type']; ?>">
            <h3><?php echo $item['heading']; ?></h3>
            <p><?php echo $item['content']; ?></p>
        </div>

    <?php
    endforeach;
    $html = ob_get_contents();
    ob_end_clean();

    return $html;

}
