<?php
//add_action( 'affwp_crypto_seconds_15', 'affwp_crypto_monthly');
function affwp_crypto_monthly() {

    $process_config = array(
        'task' => 'affwp_crypto_payout_monthly',
        'schedule' => 'monthly',
        'limit' => 5,
        'data_age_limit' => 'year',
    );

    $process_manager = new AffiliateWP_Process_Manager_1($process_config);

    $affiliate_ids = $process_manager->query_affiliates();

    if ( count($affiliate_ids) >= 1 ) :

        foreach ($affiliate_ids as $affiliate) :

            $affiliate_id = $affiliate->affiliate_id;

            $payments = new AFFWP_CRYPTO_Payments();
            $payments_array = $payments->generate_affiliate_payments($affiliate_id);
            $payments->process_payments($payments_array);

            $process_manager->complete_process($affiliate_id);

        endforeach;

    endif;

}
?>