<?php
add_action('affwp_affiliates_page_top', 'affwp_payout_button_page_top');
add_action('affwp_referrals_page_top', 'affwp_payout_button_page_top');
add_action('affwp_payouts_page_top', 'affwp_payout_button_page_top');
function affwp_payout_button_page_top() {

    ob_start();
    ?>
    <div>
        <a class="crypto_payout_trigger payout_all" data-affiliate="all"
           href="javascript:;"><?php _e('Generate Crypto Payouts', 'affiliatewp-crypto'); ?></a>
    </div>
    <?php
    $html = ob_get_contents();
    ob_end_clean();
    echo $html;

}

// Add bulk action option to affiliates table
add_filter('affwp_affiliates_bulk_actions', 'affwp_crypto_add_affilates_bulk_actions');
function affwp_crypto_add_affilates_bulk_actions($actions) {

    $actions['crypto-convert-affiliates-bulk'] = __('Crypto Payout', 'affiliatewp-crypto');
    return $actions;

}

// Add affiliates convert action
add_filter('affwp_affiliate_row_actions', 'affwp_crypto_add_affiliate_convert_action', 10, 2);
function affwp_crypto_add_affiliate_convert_action($row_actions, $affiliate) {

    if ( affiliate_has_active_address($affiliate->affiliate_id) ) :

        //$row_actions['convert'] = '<a class="crypto_payout_trigger" href="' . esc_url(add_query_arg(array('action' => 'crypto-convert-single-affiliate', 'affiliate_id' => $affiliate->affiliate_id, 'affwp_notice' => false))) . '">' . __('Crypto Payout', 'affiliate-wp-pay-as-points') . '</a>';
        $row_actions['convert'] = '<a class="crypto_payout_trigger" data-affiliate="' . $affiliate->affiliate_id . '" href="javascript:;">' . __('Crypto Payout', 'affiliatewp-crypto') . '</a>';

    endif;

    return $row_actions;

}

// Add bulk action option to referrals table
add_filter('affwp_referrals_bulk_actions', 'affwp_crypto_add_referrals_bulk_actions');
function affwp_crypto_add_referrals_bulk_actions($actions) {

    $actions['crypto-convert-referrals-bulk'] = __('Crypto Payout', 'affiliatewp-crypto');
    return $actions;

}

// Add referrals convert action
add_filter('affwp_referral_action_links', 'affwp_crypto_add_referrals_convert_action', 10, 2);
function affwp_crypto_add_referrals_convert_action($action_links, $referral) {

    if ( affiliate_has_active_address($referral->affiliate_id) ) :

        if ( $referral->status == 'unpaid' ) :
            $action_links[] = '<span><a class="crypto_payout_trigger" data-referral="' . $referral->referral_id . ' "href="javascript:;">' . __('Crypto Payout', 'affiliatewp-crypto') . '</a></span>';
        endif;

    endif;

    if ( $referral->status == 'sent' ) :
        $action_links = array();
    endif;

    return $action_links;

}

// Filter Payouts row actions
add_filter('affwp_payout_row_actions', 'affwp_payout_row_actions', 10, 2);
function affwp_payout_row_actions($row_actions, $payout) {

    if ( $payout->status == 'failed' && $payout->payout_method == 'crypto' ) :

        unset($row_actions['retry']);

    endif;

    return $row_actions;

}

// Add crypto amount to the payouts > amount column
/*add_filter('affwp_payout_table_amount', 'affwp_payout_table_amount', 10, 2);
function affwp_payout_table_amount($value, $payout) {

    $add = '';

    $formatted_payment = affiliate_wp_crypto()->base->payments->get_formatted_payment(array('payout_id' => $payout->ID));
    if ( !empty($formatted_payment) ) :

        if ( $formatted_payment['payment_amount'] > 0 ) :
            $add .= '</br>(';
            $add .= $formatted_payment['formatted_amount'];
            $add .= ')';
        endif;

    endif;

    return $value . $add;
}*/

// Add crypto status and explorer link to the payouts > status column
/*add_filter('affwp_referral_table_status', 'affwp_payout_table_status', 10, 2);
function affwp_payout_table_status($value, $payout) {

    $add = '';

    $formatted_payment = affiliate_wp_crypto()->base->payments->get_formatted_payment(array('payout_id' => $payout->ID));
    if ( !empty($formatted_payment) ) :

        if ( $formatted_payment['status'] ) :
            $add .= '</br>(';
            $add .= (!empty($formatted_payment['explorer_url_at'])) ? $formatted_payment['explorer_url_at'] : '';
            $add .= ')';
        endif;

    endif;

    return $value . $add;
}*/

// Custom column to the affiliates table
add_filter('affwp_affiliate_table_columns', 'affwp_affiliate_table_columns', 10, 3);
function affwp_affiliate_table_columns($prepared_columns, $columns, $affiliate_obj) {

    $cols = array();

    foreach ($prepared_columns as $key => $label) :

        $cols[$key] = $label;

        if ( $key == 'cb' ) :

            $cols['crypto'] = '';

        endif;

    endforeach;

    //$columns['crypto'] = 'Crypto';

    return $cols;

}

// Custom affiliates table column content
add_filter('affwp_affiliate_table_crypto', 'affwp_affiliate_table_crypto', 10, 2);
function affwp_affiliate_table_crypto($value, $affiliate) {

    $add = '';

    $currency_key = affiliate_wp_crypto()->base->payments->get_affiliates_payment_currency($affiliate->affiliate_id);
    $currency_config = affiliate_wp_crypto()->base->wallet->get_currency_config($currency_key);
    $address = affiliate_wp_crypto()->base->payments->get_affiliates_address($affiliate->affiliate_id, $currency_key);

    if ( !empty($currency_key) && !empty($address) ) :

        if ( $logo_src = affwp_crypto_get_currency_meta($currency_key, 'logo') ) : ?>
            <img class="affwp_crypto_currency_icon sml" title="<?php echo $currency_config['ticker']; ?>"
                 src="<?php echo $logo_src; ?>">
        <?php
        else:
            echo $currency_config['ticker'];
        endif;

    endif;

    //$formatted_payment = affiliate_wp_crypto()->base->payments->get_formatted_payment(array('payout_id' => $payout->ID));
    //if ( !empty($formatted_payment) ) :

    //$add .= '<span title="' . $formatted_payment["formatted_amount"] . '">' . $formatted_payment['formatted_amount_min'] . '</span>';

    /*if ( $formatted_payment['status'] ) :
        $add .= '</br>(';
        $add .= (!empty($formatted_payment['explorer_url_at'])) ? '<span title="' . $formatted_payment['transaction'] . '">' . $formatted_payment['explorer_url_at'] . '</span>' : '';
        $add .= ')';
    endif;*/

    //endif;

    return $value . $add;

}

// Add explorer link to the admin payouts > method column
add_filter('affwp_payout_table_payout_method', 'affwp_payout_table_payout_method', 10, 2);
function affwp_payout_table_payout_method($value, $payout) {

    $add = '';

    $formatted_payment = affiliate_wp_crypto()->base->payments->get_formatted_payment(array('payout_id' => $payout->ID));
    if ( !empty($formatted_payment) ) :

        if ( $formatted_payment['status'] ) :
            $add .= '</br>(';
            $add .= (!empty($formatted_payment['explorer_url_at'])) ? $formatted_payment['explorer_url_at'] : '';
            $add .= ')';
        endif;

    endif;

    return $value . $add;
}

// Payouts - Crypto Custom Column
add_filter('affwp_payout_table_columns', 'affwp_payout_table_columns');
function affwp_payout_table_columns($columns) {

    $cols = array();

    foreach ($columns as $key => $label) :

        $cols[$key] = $label;

        if ( $key == 'amount' ) :

            $cols['crypto'] = 'Crypto';

        endif;

    endforeach;

    //$columns['crypto'] = 'Crypto';

    return $cols;

}

// Payouts - Crypto column content
add_filter('affwp_payout_table_crypto', 'affwp_payout_table_crypto', 10, 2);
function affwp_payout_table_crypto($value, $payout) {

    $add = '';

    $formatted_payment = affiliate_wp_crypto()->base->payments->get_formatted_payment(array('payout_id' => $payout->ID));
    if ( !empty($formatted_payment) ) :

        $add .= '<span title="' . $formatted_payment["formatted_amount"] . '">' . $formatted_payment['formatted_amount_min'] . '</span>';

        /*if ( $formatted_payment['status'] ) :
            $add .= '</br>(';
            $add .= (!empty($formatted_payment['explorer_url_at'])) ? '<span title="' . $formatted_payment['transaction'] . '">' . $formatted_payment['explorer_url_at'] . '</span>' : '';
            $add .= ')';
        endif;*/

    endif;

    return $value . $add;

}

//apply_filters( 'affwp_referrals_dashboard_get_referrals',)
// Requested hook
add_filter('affwp_referrals_dashboard_get_referrals', 'affwp_referrals_dashboard_get_referrals');
function affwp_referrals_dashboard_get_referrals($referrals_args) {

    array_push($referrals_args['status'], "sent");

    return $referrals_args;

}

add_filter('affwp_referral_status_label', 'affwp_referral_status_label', 10, 2);
function affwp_referral_status_label($label, $referral) {

    // Modify this to display the 'Unpaid' status on the front end for 'sent' status.

    if ( $referral->status == 'sent' ) :

        if ( is_admin() ) :

            $label = ' Sent';

        else:

            $label = 'Unpaid';

        endif;

    endif;

    if ( $referral->status == 'failed' ) :

        $label = ' Failed';

    endif;

    return $label;

}

add_filter('affwp_payout_status_label', 'affwp_payout_status_label', 10, 2);
function affwp_payout_status_label($label, $payout) {

    if ( $payout->status == 'sent' ) :

        //if ( is_admin() ) :

        $label = ' Sent';

        //else:

        //$label = 'Unpaid';

        //endif;

    endif;

    if ( $payout->status == 'failed' ) :

        //if ( is_admin() ) :

        $label = ' Failed';

        //else:

        //$label = 'Unpaid';

        //endif;

    endif;

    return $label;

}

// Add data to the view payout screen
add_filter('affwp_edit_payout_end', 'affwp_edit_payout_end');
function affwp_edit_payout_end($payout) {

    ob_start();

    //$payout->ID
    $payment_data = affiliate_wp_crypto()->base->payments->get_payment(array('payout_id' => $payout->ID));
    $formatted_payment_data = affiliate_wp_crypto()->base->payments->get_formatted_payment(array('payout_id' => $payout->ID));
    $c_config = affiliate_wp_crypto()->base->wallet->get_currency_config($formatted_payment_data['payment_currency']);
    ?>

    <tr class="form-row">

        <th scope="row">
            <?php _e('Crypto Amount', 'affiliatewp_crypto'); ?>
        </th>

        <td>
            <?php echo $formatted_payment_data['formatted_amount']; ?>
        </td>

    </tr>
    <tr class="form-row">

        <th scope="row">
            <?php _e('Crypto Exchange Rate', 'affiliatewp_crypto'); ?>
        </th>

        <td>
            <?php echo $payment_data['exchange_rate']; ?>
        </td>

    </tr>
    <tr class="form-row">

        <th scope="row">
            <?php _e('Crypto Transaction ID', 'affiliatewp_crypto'); ?>
        </th>

        <td>
            <?php echo '<a href="' . $formatted_payment_data["explorer_url"] . '" target="_blank" class="explorer_link icon ' . $c_config['currency'] . '">' . $payment_data["transaction"] . '</a>'; ?>
        </td>

    </tr>

    <?php
    $html = ob_get_contents();
    ob_end_clean();
    echo $html;

}

add_action('affwp_payouts_dashboard_th', 'affwp_payouts_dashboard_th');
function affwp_payouts_dashboard_th() {

    echo '<th class="payout-crypto">' . __('Crypto', 'affiliatewp_crypto') . '</th>';
}

add_action('affwp_payouts_dashboard_td', 'affwp_payouts_dashboard_td');
function affwp_payouts_dashboard_td($payout) {

    //$payment_data = affiliate_wp_crypto()->base->payments->get_payment(array('payout_id' => $payout->ID));
    $formatted_payment = affiliate_wp_crypto()->base->payments->get_formatted_payment(array('payout_id' => $payout->ID));

    if ( !empty($formatted_payment) ) :
        echo '<td data-th="' . __("Crypto", "affiliatewp_crypto") . '"><span title="' . $formatted_payment["formatted_amount"] . '">' . $formatted_payment['formatted_amount_min'] . '</span></br><span title="' . $formatted_payment['transaction'] . '">' . $formatted_payment['explorer_url_at'] . '</span></td>';
    else:
        echo '<td data-th="' . __("Crypto", "affiliatewp_crypto") . '">NA</td>';
    endif;
}

// Catch all ajax requests
add_action('wp_ajax_affwp_crypto', 'affwp_crypto_ajax_action');
add_action('wp_ajax_nopriv_affwp_crypto', 'affwp_crypto_ajax_action'); // Front end non logged in users.
function affwp_crypto_ajax_action() {

    /*if ( !wp_verify_nonce( $_REQUEST['nonce'], "my_ajax_nonce")) {
       exit("No naughty business please");
    }*/
    //$action = $_REQUEST['action'];
    $task = $_REQUEST['task'];

    // Run some code here, Return either success or error and the response
    $result['type'] = "error";
    //$result['type'] = "success";

    $result = apply_filters('affwp_crypto_ajax_' . $task, $result);

    if ( !empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest' ) {
        $result = json_encode($result);
        echo $result;
    } else {
        header("Location: " . $_SERVER["HTTP_REFERER"]);
    }

    die();

}